/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.ReferencedPermission;
import ai.digital.deploy.permissions.model.ReferencedPermission$;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.view.RoleReferencedPermissionView;
import ai.digital.deploy.permissions.repository.ReferencedPermissionRepository;
import ai.digital.deploy.permissions.repository.RoleReferencedPermissionViewRepository;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import ai.digital.deploy.permissions.service.impl.package$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Service
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001B\f\u0019\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0002bBA\u0013\u0001\u0011\u0005\u00131\b\u0005\b\u0003K\u0001A\u0011IA\"\u0011\u001d\t)\u0003\u0001C!\u0003\u0017Bq!a\"\u0001\t\u0003\nI\tC\u0004\u0002\u0012\u0002!\t%a%\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u00111\u0017\u0001\u0005B\u0005U\u0006bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011\u001d\t9\u000e\u0001C!\u00033Dq!a6\u0001\t\u0003\nYOA\u0010SK\u001a,'/\u001a8dK\u0012\u0004VM]7jgNLwN\\*feZL7-Z%na2T!!\u0007\u000e\u0002\t%l\u0007\u000f\u001c\u0006\u00037q\tqa]3sm&\u001cWM\u0003\u0002\u001e=\u0005Y\u0001/\u001a:nSN\u001c\u0018n\u001c8t\u0015\ty\u0002%\u0001\u0004eKBdw.\u001f\u0006\u0003C\t\nq\u0001Z5hSR\fGNC\u0001$\u0003\t\t\u0017n\u0001\u0001\u0014\u0007\u00011C\u0006\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VM\u001a\t\u0003[9j\u0011AG\u0005\u0003_i\u00111DU3gKJ,gnY3e!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017A\b:fM\u0016\u0014XM\\2fIB+'/\\5tg&|gNU3q_NLGo\u001c:z!\t\u0011T'D\u00014\u0015\t!D$\u0001\u0006sKB|7/\u001b;pefL!AN\u001a\u0003=I+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8o%\u0016\u0004xn]5u_JL\u0018a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"!L\u001d\n\u0005iR\"a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\fAC]8mKB\u0013\u0018N\\2ja\u0006d7+\u001a:wS\u000e,\u0007CA\u0017>\u0013\tq$D\u0001\u000bS_2,\u0007K]5oG&\u0004\u0018\r\\*feZL7-Z\u0001'e>dWMU3gKJ,gnY3e!\u0016\u0014X.[:tS>tg+[3x%\u0016\u0004xn]5u_JL\bC\u0001\u001aB\u0013\t\u00115G\u0001\u0014S_2,'+\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:4\u0016.Z<SKB|7/\u001b;pef\fa\u0001P5oSRtD#B#H\u0011&S\u0005C\u0001$\u0001\u001b\u0005A\u0002\"\u0002\u0019\u0006\u0001\u0004\t\u0004\"B\u001c\u0006\u0001\u0004A\u0004\"B\u001e\u0006\u0001\u0004a\u0004\"B \u0006\u0001\u0004\u0001\u0015aA1eIR!Qj[;\u0000!\u0011qe+\u0017/\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*%\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002VQ\u00059\u0001/Y2lC\u001e,\u0017BA,Y\u0005\u0019)\u0015\u000e\u001e5fe*\u0011Q\u000b\u000b\t\u0003[iK!a\u0017\u000e\u0003AI{G.\u001a(b[\u0016tu\u000e\u001e$pk:$7+\u001a:wS\u000e,W\t_2faRLwN\u001c\t\u0005Ou{V-\u0003\u0002_Q\t1A+\u001e9mKJ\u0002\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u000f\u0002\u000b5|G-\u001a7\n\u0005\u0011\f'\u0001\u0002*pY\u0016\u00042A\u00144i\u0013\t9\u0007L\u0001\u0003MSN$\bC\u00011j\u0013\tQ\u0017M\u0001\u000bSK\u001a,'/\u001a8dK\u0012\u0004VM]7jgNLwN\u001c\u0005\u0006Y\u001a\u0001\r!\\\u0001\fe\u00164WM]3oG\u0016LE\r\u0005\u0002og6\tqN\u0003\u0002qc\u0006!Q\u000f^5m\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\tU+\u0016\n\u0012\u0005\u0006m\u001a\u0001\ra^\u0001\te>dWMT1nKB\u0011\u0001\u0010 \b\u0003sj\u0004\"\u0001\u0015\u0015\n\u0005mD\u0013A\u0002)sK\u0012,g-\u0003\u0002~}\n11\u000b\u001e:j]\u001eT!a\u001f\u0015\t\ru1\u0001\u0019AA\u0001!\rqem^\u0001\u0007e\u0016lwN^3\u0015\u000f5\u000b9!!\u0003\u0002\f!)An\u0002a\u0001[\")ao\u0002a\u0001o\"1Qd\u0002a\u0001\u0003\u0003\tQB]3n_Z,gi\u001c:S_2,G\u0003BA\t\u0003/\u00012aJA\n\u0013\r\t)\u0002\u000b\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u001a!\u0001\raX\u0001\u0005e>dW-\u0001\nsK6|g/\u001a$peJ+g-\u001a:f]\u000e,G\u0003BA\t\u0003?AQ\u0001\\\u0005A\u00025\f\u0011B]3n_Z,\u0017\t\u001c7\u0015\u0005\u0005E\u0011\u0001\u0002:fC\u0012$B!!\u000b\u0002,A!aJV-f\u0011\u001518\u00021\u0001xQ\rY\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u000f\u0002\u0007)\u0004\u0018-\u0003\u0003\u0002:\u0005M\"A\n*fC\u0012|e\u000e\\=Ue\u0006t7/Y2uS>t\u0017\r\u001c)fe6L7o]5p]N+'O^5dKR!\u0011\u0011FA\u001f\u0011\u001d\ty\u0004\u0004a\u0001\u0003\u0003\t\u0011B]8mK:\u000bW.Z:)\u00071\ty\u0003\u0006\u0004\u0002*\u0005\u0015\u0013q\t\u0005\u0006Y6\u0001\r!\u001c\u0005\u0006m6\u0001\ra\u001e\u0015\u0004\u001b\u0005=B\u0003CA'\u0003k\n9(a\u001f\u0011\r\u001dj\u0016qJA4!\u0015\t\t&a\u0019`\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013A\u00023p[\u0006LgN\u0003\u0003\u0002Z\u0005m\u0013\u0001\u00023bi\u0006TA!!\u0018\u0002`\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002b\u0005\u0019qN]4\n\t\u0005\u0015\u00141\u000b\u0002\u0005!\u0006<W\r\u0005\u0003OM\u0006%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=\u0014-\u0001\u0003wS\u0016<\u0018\u0002BA:\u0003[\u0012ADU8mKJ+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8o-&,w\u000fC\u0003m\u001d\u0001\u0007Q\u000e\u0003\u0004\u0002z9\u0001\ra^\u0001\fe>dW\rU1ui\u0016\u0014h\u000eC\u0004\u0002~9\u0001\r!a \u0002\u0011A\fw-Z1cY\u0016\u0004B!!\u0015\u0002\u0002&!\u00111QA*\u0005!\u0001\u0016mZ3bE2,\u0007f\u0001\b\u00020\u0005\u0011\"/Z1e\r>\u0014(k\u001c7f!\u0006$H/\u001a:o)\u0015)\u00171RAG\u0011\u0015aw\u00021\u0001n\u0011\u0019\tIh\u0004a\u0001o\"\u001aq\"a\f\u0002\t\u0015$\u0017\u000e\u001e\u000b\n\u001b\u0006U\u0015qSAM\u0003;CQ\u0001\u001c\tA\u00025DQA\u001e\tA\u0002]Dq!a'\u0011\u0001\u0004\t\t!\u0001\tqKJl\u0017n]:j_:\u001cHk\\!eI\"9\u0011q\u0014\tA\u0002\u0005\u0005\u0011A\u00059fe6L7o]5p]R{G)\u001a7fi\u0016\fAcZ3u%\u00164WM]3oG\u0016\u001chi\u001c:S_2,GCBAS\u0003W\u000by\u000b\u0005\u0003y\u0003Ok\u0017bAAU}\n\u00191+\u001a;\t\r\u00055\u0016\u00031\u0001n\u0003\u0019\u0011x\u000e\\3JI\"1Q$\u0005a\u0001\u0003\u0003A3!EA\u0018\u0003U9W\r\u001e*fM\u0016\u0014XM\\2fg\u001a{'OU8mKN$b!!*\u00028\u0006u\u0006bBA]%\u0001\u0007\u00111X\u0001\be>dW-\u00133t!\rqe-\u001c\u0005\u0007;I\u0001\r!!\u0001)\u0007I\ty#\u0001\rhKR\u0014VMZ3sK:\u001cWm\u001d$peJ{G.\u001a(b[\u0016$b!!*\u0002F\u0006\u001d\u0007\"\u0002<\u0014\u0001\u00049\bBB\u000f\u0014\u0001\u0004\t\t\u0001K\u0002\u0014\u0003_\tQdZ3u%\u00164WM]3oG\u0016\u001chi\u001c:Qe&t7-\u001b9bY:\u000bW.\u001a\u000b\u0007\u0003K\u000by-a5\t\r\u0005EG\u00031\u0001x\u00035\u0001(/\u001b8dSB\fGNT1nK\"1Q\u0004\u0006a\u0001\u0003\u0003A3\u0001FA\u0018\u0003=\u0019\u0007.Z2l!\u0016\u0014X.[:tS>tG\u0003CAn\u0003C\f\u0019/!:\u0011\u0007\u001d\ni.C\u0002\u0002`\"\u0012qAQ8pY\u0016\fg\u000eC\u0003m+\u0001\u0007Q\u000e\u0003\u0004\u001e+\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003O,\u0002\u0019AA\u0001\u0003!\tG\u000e\u001c*pY\u0016\u001c\bfA\u000b\u00020QQ\u00111\\Aw\u0003_\f\t0a=\t\u000b14\u0002\u0019A7\t\ru1\u0002\u0019AA\u0001\u0011\u001d\t9O\u0006a\u0001\u0003\u0003Aq!!>\u0017\u0001\u0004\t\t!\u0001\u0006qe&t7-\u001b9bYND3AFA\u0018Q\r\u0001\u00111 \t\u0005\u0003c\ti0\u0003\u0003\u0002\u0000\u0006M\"A\b+sC:\u001c\u0018m\u0019;j_:\fG\u000eU3s[&\u001c8/[8o'\u0016\u0014h/[2fQ\r\u0001!1\u0001\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)!!\u0011BA.\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005\u001b\u00119AA\u0004TKJ4\u0018nY3")
public class ReferencedPermissionServiceImpl
implements ReferencedPermissionService {
    private final ReferencedPermissionRepository referencedPermissionRepository;
    private final RoleService roleService;
    private final RolePrincipalService rolePrincipalService;
    private final RoleReferencedPermissionViewRepository roleReferencedPermissionViewRepository;

    @Override
    public Either<RoleNameNotFoundServiceException, Tuple2<Role, List<ReferencedPermission>>> add(UUID referenceId, String roleName, List<String> permissions) {
        return (Either)this.roleService.read(roleName).map((Function1 & Serializable)role -> {
            List<ReferencedPermission> savedPermissions = $this.referencedPermissionRepository.get(referenceId, (Role)role);
            Tuple2 tuple2 = savedPermissions.partition((Function1 & Serializable)rp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)rp.permissionName())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List exists = (List)tuple2._1();
            List toDelete = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)exists, (Object)toDelete);
            Tuple2 tuple23 = tuple22;
            List exists2 = (List)tuple23._1();
            List toDelete2 = (List)tuple23._2();
            List toSave = permissions.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ReferencedPermissionServiceImpl.$anonfun$add$3(exists2, p))).map((Function1 & Serializable)p -> ReferencedPermission$.MODULE$.apply((Role)role, (String)p, referenceId));
            $this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
            return scala.package$.MODULE$.Right().apply((Object)new Tuple2(role, exists2.$plus$plus($this.referencedPermissionRepository.add((List<ReferencedPermission>)toSave))));
        }).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    public Either<RoleNameNotFoundServiceException, Tuple2<Role, List<ReferencedPermission>>> remove(UUID referenceId, String roleName, List<String> permissions) {
        return (Either)this.roleService.read(roleName).map((Function1 & Serializable)role -> {
            Tuple2 tuple2 = $this.referencedPermissionRepository.get(referenceId, (Role)role).partition((Function1 & Serializable)rp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)rp.permissionName())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List toDelete = (List)tuple2._1();
            List rp2 = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)rp2);
            Tuple2 tuple23 = tuple22;
            List toDelete2 = (List)tuple23._1();
            List rp3 = (List)tuple23._2();
            $this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
            return scala.package$.MODULE$.Right().apply((Object)new Tuple2(role, (Object)rp3));
        }).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    public void removeForRole(Role role) {
        this.referencedPermissionRepository.removeForRole(role);
    }

    @Override
    public void removeForReference(UUID referenceId) {
        this.referencedPermissionRepository.removeForReference(referenceId);
    }

    @Override
    public void removeAll() {
        this.referencedPermissionRepository.removeAll();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Either<RoleNameNotFoundServiceException, List<ReferencedPermission>> read(String roleName) {
        return (Either)this.roleService.read(roleName).map((Function1 & Serializable)role -> scala.package$.MODULE$.Right().apply($this.referencedPermissionRepository.get(role.name()))).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Either<RoleNameNotFoundServiceException, List<ReferencedPermission>> read(List<String> roleNames) {
        Left left;
        Either<RoleNameNotFoundServiceException, List<Role>> either = this.roleService.read(roleNames);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left2.value();
            left = scala.package$.MODULE$.Left().apply((Object)exception);
        } else if (either instanceof Right) {
            left = scala.package$.MODULE$.Right().apply(this.referencedPermissionRepository.get(roleNames));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Either<RoleNameNotFoundServiceException, List<ReferencedPermission>> read(UUID referenceId, String roleName) {
        return (Either)this.roleService.read(roleName).map((Function1 & Serializable)role -> scala.package$.MODULE$.Right().apply($this.referencedPermissionRepository.get(referenceId, role.name()))).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Tuple2<Page<Role>, List<RoleReferencedPermissionView>> read(UUID referenceId, String rolePattern, Pageable pageable) {
        Page<Role> rolePage = this.roleService.read(rolePattern, pageable);
        List roleIds = CollectionConverters$.MODULE$.ListHasAsScala(rolePage.getContent()).asScala().toList().map((Function1 & Serializable)x$4 -> x$4.id());
        List<RoleReferencedPermissionView> views = this.roleReferencedPermissionViewRepository.get((List<UUID>)roleIds, referenceId);
        return new Tuple2(rolePage, views);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<ReferencedPermission> readForRolePattern(UUID referenceId, String rolePattern) {
        return (List)package$.MODULE$.wrapNullablePatternSearch(rolePattern, (Function1 & Serializable)p -> $this.referencedPermissionRepository.listByRoleNamePattern((String)p, referenceId), (Function0 & Serializable)() -> $this.referencedPermissionRepository.get(referenceId));
    }

    @Override
    public Either<RoleNameNotFoundServiceException, Tuple2<Role, List<ReferencedPermission>>> edit(UUID referenceId, String roleName, List<String> permissionsToAdd, List<String> permissionToDelete) {
        return (Either)this.roleService.read(roleName).map((Function1 & Serializable)role -> {
            List<ReferencedPermission> permissions = $this.referencedPermissionRepository.get(referenceId, (Role)role);
            Tuple2 tuple2 = permissions.partition((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)permissionToDelete.contains((Object)p.permissionName())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List toDelete = (List)tuple2._1();
            List exists = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)exists);
            Tuple2 tuple23 = tuple22;
            List toDelete2 = (List)tuple23._1();
            List exists2 = (List)tuple23._2();
            $this.referencedPermissionRepository.remove((List<ReferencedPermission>)toDelete2);
            List toAdd = permissionsToAdd.map((Function1 & Serializable)p -> ReferencedPermission$.MODULE$.apply((Role)role, (String)p, referenceId));
            return scala.package$.MODULE$.Right().apply((Object)new Tuple2(role, exists2.$plus$plus($this.referencedPermissionRepository.add((List<ReferencedPermission>)toAdd))));
        }).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<UUID> getReferencesForRole(UUID roleId, List<String> permissions) {
        return this.referencedPermissionRepository.listByRoleAndPermissions(roleId, permissions).map((Function1 & Serializable)x$6 -> x$6.reference()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<UUID> getReferencesForRoles(List<UUID> roleIds, List<String> permissions) {
        return this.referencedPermissionRepository.listByRolesAndPermissions(roleIds, permissions).map((Function1 & Serializable)x$7 -> x$7.reference()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<UUID> getReferencesForRoleName(String roleName, List<String> permissions) {
        return this.referencedPermissionRepository.listByRoleNameAndPermissions(roleName, permissions).map((Function1 & Serializable)x$8 -> x$8.reference()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<UUID> getReferencesForPrincipalName(String principalName, List<String> permissions) {
        return this.referencedPermissionRepository.listByPrincipalNameAndPermissions(principalName, permissions).map((Function1 & Serializable)x$9 -> x$9.reference()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(UUID referenceId, List<String> permissions, List<String> allRoles) {
        return this.referencedPermissionRepository.getByPermissionsAndRoles(referenceId, permissions, (Set<String>)allRoles.toSet()).nonEmpty();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(UUID referenceId, List<String> permissions, List<String> allRoles, List<String> principals) {
        Set principalRoleIds = this.rolePrincipalService.readAll(principals).map((Function1 & Serializable)x$10 -> x$10.role().name()).toSet();
        return this.referencedPermissionRepository.getByPermissionsAndRoles(referenceId, permissions, (Set<String>)((Set)principalRoleIds.$plus$plus(allRoles))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$add$3(List exists$1, String p) {
        return exists$1.map((Function1 & Serializable)x$2 -> x$2.permissionName()).contains((Object)p);
    }

    public ReferencedPermissionServiceImpl(ReferencedPermissionRepository referencedPermissionRepository, RoleService roleService, RolePrincipalService rolePrincipalService, RoleReferencedPermissionViewRepository roleReferencedPermissionViewRepository) {
        this.referencedPermissionRepository = referencedPermissionRepository;
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
        this.roleReferencedPermissionViewRepository = roleReferencedPermissionViewRepository;
    }
}

