/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.policies;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.activemq.artemis.core.server.balancing.BrokerBalancer;
import org.apache.activemq.artemis.core.server.balancing.policies.ConsistentHashPolicy;
import org.apache.activemq.artemis.core.server.balancing.policies.FirstElementPolicy;
import org.apache.activemq.artemis.core.server.balancing.policies.LeastConnectionsPolicy;
import org.apache.activemq.artemis.core.server.balancing.policies.PolicyFactory;
import org.apache.activemq.artemis.core.server.balancing.policies.RoundRobinPolicy;

public class PolicyFactoryResolver {
    private static PolicyFactoryResolver instance;
    private final Map<String, PolicyFactory> policyFactories = new HashMap<String, PolicyFactory>();

    public static PolicyFactoryResolver getInstance() {
        if (instance == null) {
            instance = new PolicyFactoryResolver();
        }
        return instance;
    }

    private PolicyFactoryResolver() {
        this.policyFactories.put("CONSISTENT_HASH", () -> new ConsistentHashPolicy());
        this.policyFactories.put("FIRST_ELEMENT", () -> new FirstElementPolicy());
        this.policyFactories.put("LEAST_CONNECTIONS", () -> new LeastConnectionsPolicy());
        this.policyFactories.put("ROUND_ROBIN", () -> new RoundRobinPolicy());
        this.loadPolicyFactories();
    }

    public PolicyFactory resolve(String policyName) throws ClassNotFoundException {
        PolicyFactory policyFactory = this.policyFactories.get(policyName);
        if (policyFactory == null) {
            throw new ClassNotFoundException("No PolicyFactory found for the policy " + policyName);
        }
        return policyFactory;
    }

    private void loadPolicyFactories() {
        ServiceLoader<PolicyFactory> serviceLoader = ServiceLoader.load(PolicyFactory.class, BrokerBalancer.class.getClassLoader());
        for (PolicyFactory policyFactory : serviceLoader) {
            this.policyFactories.put(this.keyFromClassName(policyFactory.getClass().getName()), policyFactory);
        }
    }

    public void registerPolicyFactory(String name, PolicyFactory policyFactory) {
        this.policyFactories.put(name, policyFactory);
    }

    String keyFromClassName(String name) {
        return name.substring(0, name.indexOf("PolicyFactory"));
    }
}

