/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.name;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameCache;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.util.XMLChar;

public class NameFormat {
    private static final Pattern NAME_PATTERN = Pattern.compile("(([^ /:\\[\\]*'\"|](?:[^/:\\[\\]*'\"|]*[^ /:\\[\\]*'\"|])?):)?([^ /:\\[\\]*'\"|](?:[^/:\\[\\]*'\"|]*[^ /:\\[\\]*'\"|])?)");
    private static final ThreadLocal NAME_MATCHER = new ThreadLocal(){

        protected Object initialValue() {
            return NAME_PATTERN.matcher("dummy");
        }
    };

    public static QName parse(String jcrName, NamespaceResolver resolver) throws IllegalNameException, UnknownPrefixException {
        if (resolver instanceof NameCache) {
            QName name = ((NameCache)((Object)resolver)).retrieveName(jcrName);
            if (name == null) {
                name = NameFormat.parseIgnoreCache(jcrName, resolver);
                ((NameCache)((Object)resolver)).cacheName(jcrName, name);
            }
            return name;
        }
        return NameFormat.parseIgnoreCache(jcrName, resolver);
    }

    public static QName[] parse(String[] jcrNames, NamespaceResolver resolver) throws IllegalNameException, UnknownPrefixException {
        QName[] ret = new QName[jcrNames.length];
        if (resolver instanceof NameCache) {
            for (int i = 0; i < ret.length; ++i) {
                QName name = ((NameCache)((Object)resolver)).retrieveName(jcrNames[i]);
                if (name == null) {
                    name = NameFormat.parseIgnoreCache(jcrNames[i], resolver);
                    ((NameCache)((Object)resolver)).cacheName(jcrNames[i], name);
                }
                ret[i] = name;
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = NameFormat.parseIgnoreCache(jcrNames[i], resolver);
            }
        }
        return ret;
    }

    public static void checkFormat(String jcrName) throws IllegalNameException {
        NameFormat.doParse(jcrName);
    }

    public static String format(QName qName, NamespaceResolver resolver) throws NoPrefixDeclaredException {
        if (resolver instanceof NameCache) {
            String jcrName = ((NameCache)((Object)resolver)).retrieveName(qName);
            if (jcrName == null) {
                StringBuffer buf = new StringBuffer();
                NameFormat.formatIgnoreCache(qName, resolver, buf);
                jcrName = buf.toString();
                ((NameCache)((Object)resolver)).cacheName(jcrName, qName);
            }
            return jcrName;
        }
        StringBuffer buf = new StringBuffer();
        NameFormat.formatIgnoreCache(qName, resolver, buf);
        return buf.toString();
    }

    public static String[] format(QName[] qNames, NamespaceResolver resolver) throws NoPrefixDeclaredException {
        String[] ret = new String[qNames.length];
        if (resolver instanceof NameCache) {
            for (int i = 0; i < ret.length; ++i) {
                String jcrName = ((NameCache)((Object)resolver)).retrieveName(qNames[i]);
                if (jcrName == null) {
                    StringBuffer buf = new StringBuffer();
                    NameFormat.formatIgnoreCache(qNames[i], resolver, buf);
                    jcrName = buf.toString();
                    ((NameCache)((Object)resolver)).cacheName(jcrName, qNames[i]);
                }
                ret[i] = jcrName;
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                StringBuffer buf = new StringBuffer();
                NameFormat.formatIgnoreCache(qNames[i], resolver, buf);
                ret[i] = buf.toString();
            }
        }
        return ret;
    }

    public static void format(QName qName, NamespaceResolver resolver, StringBuffer buffer) throws NoPrefixDeclaredException {
        if (resolver instanceof NameCache) {
            String jcrName = ((NameCache)((Object)resolver)).retrieveName(qName);
            if (jcrName == null) {
                int l = buffer.length();
                NameFormat.formatIgnoreCache(qName, resolver, buffer);
                ((NameCache)((Object)resolver)).cacheName(buffer.substring(l), qName);
            } else {
                buffer.append(jcrName);
            }
        } else {
            NameFormat.formatIgnoreCache(qName, resolver, buffer);
        }
    }

    private static QName parseIgnoreCache(String jcrName, NamespaceResolver resolver) throws IllegalNameException, UnknownPrefixException {
        String uri;
        String[] parts = NameFormat.doParse(jcrName);
        try {
            uri = resolver.getURI(parts[0]);
        }
        catch (NamespaceException nse) {
            throw new UnknownPrefixException(parts[0]);
        }
        return new QName(uri, parts[1]);
    }

    private static String[] doParse(String jcrName) throws IllegalNameException {
        String prefix;
        if (jcrName == null || jcrName.length() == 0) {
            throw new IllegalNameException("empty name");
        }
        if (".".equals(jcrName) || "..".equals(jcrName)) {
            throw new IllegalNameException("'" + jcrName + "' is not a valid name");
        }
        Matcher matcher = (Matcher)NAME_MATCHER.get();
        matcher.reset(jcrName);
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                prefix = matcher.group(2);
                if (!XMLChar.isValidNCName(prefix)) {
                    throw new IllegalNameException("'" + jcrName + "' is not a valid name: illegal prefix");
                }
            } else {
                prefix = "";
            }
        } else {
            throw new IllegalNameException("'" + jcrName + "' is not a valid name");
        }
        String localName = matcher.group(3);
        return new String[]{prefix, localName};
    }

    private static void formatIgnoreCache(QName qName, NamespaceResolver resolver, StringBuffer buffer) throws NoPrefixDeclaredException {
        String prefix;
        try {
            prefix = resolver.getPrefix(qName.getNamespaceURI());
        }
        catch (NamespaceException nse) {
            throw new NoPrefixDeclaredException("no prefix declared for URI: " + qName.getNamespaceURI());
        }
        if (prefix.length() != 0) {
            buffer.append(prefix);
            buffer.append(':');
        }
        buffer.append(qName.getLocalName());
    }
}

