/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix.bsd;

import java.util.ArrayList;
import java.util.Iterator;
import org.rzo.yajsw.os.posix.PosixProcess;

public class AppStarter {
    public static void main(String[] args) {
        int umask;
        int pid = PosixProcess.CLibrary.INSTANCE.getpid();
        System.out.println("PID:" + pid);
        System.out.flush();
        if (PosixProcess.CLibrary.INSTANCE.nice(1) == -1) {
            System.out.println("could not set priority ");
        }
        if (AppStarter.getUser() != null) {
            try {
                new PosixProcess().switchUser(AppStarter.getUser(), AppStarter.getPassword());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        PosixProcess.CLibrary.INSTANCE.umask(0);
        PosixProcess.CLibrary.INSTANCE.setsid();
        System.out.println("calling exec");
        if (!AppStarter.isPipeStreams()) {
            System.out.close();
            System.err.close();
        }
        if ((umask = AppStarter.getUmask()) != -1) {
            PosixProcess.umask(umask);
        }
        String[] env = null;
        int ret = -1;
        try {
            if (env == null) {
                PosixProcess.CLibrary.INSTANCE.execvp(args[0], args);
            } else {
                PosixProcess.CLibrary.INSTANCE.execvpe(args[0], args, env);
            }
            System.out.println("ret " + ret);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isPipeStreams() {
        return System.getProperty("wrapperx.pipeStreams") != null;
    }

    private static String getPassword() {
        return System.getProperty("wrapperx.password");
    }

    private static String getUser() {
        return System.getProperty("wrapperx.user");
    }

    private static int getUmask() {
        String u = System.getProperty("wrapperx.umask", "-1");
        return Integer.parseInt(u);
    }

    private static String[] getEnv() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : System.getenv().keySet()) {
            result.add(key + "=" + System.getenv(key));
        }
        if (result.isEmpty()) {
            return null;
        }
        String[] arr = new String[result.size()];
        int i = 0;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            String x;
            arr[i] = x = (String)iterator.next();
            System.out.println(x);
            ++i;
        }
        return arr;
    }
}

