/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ServerConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public final class ServerConfigResource {
    private final Resource configResource;
    private static final Logger logger = LoggerFactory.getLogger(ServerConfigResource.class);

    public ServerConfigResource(Resource resource) {
        this.configResource = resource;
    }

    public boolean exists() {
        return this.configResource.exists();
    }

    public String getName() {
        return this.configResource.getFilename();
    }

    public void readIntoConfiguration(ServerConfiguration serverConfiguration) {
        serverConfiguration.load(ServerConfigResource.readConfigurationFile(this.configResource));
    }

    public ServerConfiguration loadConfig() {
        return this.loadConfig(true);
    }

    public ServerConfiguration loadConfig(boolean encryptedPasswords) {
        if (this.configResource.exists()) {
            ServerConfiguration serverConfiguration = ServerConfigResource.readConfiguration(this.configResource, encryptedPasswords);
            if (!serverConfiguration.isValid()) {
                throw new Error("Configuration " + this.configResource.getFilename() + " is not valid please run with -setup option.");
            }
            return serverConfiguration;
        }
        throw new Error("Configuration " + this.configResource.getFilename() + " does not exist, please run with -setup option before starting the server or command line interface.");
    }

    static ServerConfiguration readConfiguration(Resource configResource, boolean encryptedPasswords) {
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        serverConfiguration.setConfigResource(configResource);
        serverConfiguration.load(ServerConfigResource.readConfigurationFile(configResource), encryptedPasswords);
        return serverConfiguration;
    }

    static Properties readConfigurationFile(Resource configResource) {
        Properties properties = new Properties();
        try (InputStream inputStream = configResource.getInputStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public String toString() {
        return this.configResource.toString();
    }
}

