/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.util.OverthereUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class PathMapper {
    private static final String DRIVE_DESIGNATOR = ":";
    private static final String ADMIN_SHARE_DESIGNATOR = "$";
    private static final Pattern ADMIN_SHARE_PATTERN = Pattern.compile("[a-zA-Z]" + Pattern.quote("$"));
    private final SortedMap<String, String> sharesForPaths;
    private final Map<String, String> pathsForShares;

    public PathMapper(Map<String, String> mappings) {
        TreeMap<String, String> sharesForPath = new TreeMap<String, String>((o1, o2) -> o2.compareTo((String)o1));
        HashMap<String, String> pathsForShare = new HashMap<String, String>();
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            String pathPrefixToMatch = mapping.getKey();
            String shareForPathPrefix = mapping.getValue();
            OverthereUtils.checkArgument(sharesForPath.put(pathPrefixToMatch.toLowerCase(), shareForPathPrefix) == null, "path prefix is not unique in mapping %s -> %s", pathPrefixToMatch, shareForPathPrefix);
            OverthereUtils.checkArgument(pathsForShare.put(shareForPathPrefix.toLowerCase(), pathPrefixToMatch) == null, "share is not unique in mapping %s -> %s", shareForPathPrefix, pathPrefixToMatch);
        }
        this.sharesForPaths = Collections.unmodifiableSortedMap(sharesForPath);
        this.pathsForShares = Collections.unmodifiableMap(pathsForShare);
    }

    public String toSharedPath(String path) {
        String lowerCasePath = path.toLowerCase();
        String mappedPathPrefix = null;
        for (String s : this.sharesForPaths.keySet()) {
            if (!lowerCasePath.startsWith(s)) continue;
            mappedPathPrefix = s;
            break;
        }
        return mappedPathPrefix != null ? (String)this.sharesForPaths.get(mappedPathPrefix) + path.substring(mappedPathPrefix.length()) : path.substring(0, 1) + ADMIN_SHARE_DESIGNATOR + path.substring(2);
    }

    public String toLocalPath(String path) {
        String lowerCasePath = path.toLowerCase();
        String mappedShare = null;
        for (String s : this.pathsForShares.keySet()) {
            if (!lowerCasePath.startsWith(s)) continue;
            mappedShare = s;
            break;
        }
        if (mappedShare != null) {
            return this.pathsForShares.get(mappedShare) + path.substring(mappedShare.length());
        }
        if (path.length() >= 2 && ADMIN_SHARE_PATTERN.matcher(path.substring(0, 2)).matches()) {
            return path.substring(0, 1) + DRIVE_DESIGNATOR + path.substring(2);
        }
        throw new IllegalArgumentException(String.format("Remote path name '%s' uses unrecognized (i.e. neither mapped nor administrative) share", path));
    }
}

