/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.testng.ITestResult;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.util.Strings;

public class Reporter {
    private static ThreadLocal<ITestResult> m_currentTestResult = new InheritableThreadLocal<ITestResult>();
    private static List<String> m_output = new Vector<String>();
    private static Map<Integer, List<Integer>> m_methodOutputMap = Maps.newHashMap();
    private static boolean m_escapeHtml = false;
    private static ThreadLocal<List<String>> m_orphanedOutput = new InheritableThreadLocal<List<String>>();

    public static void setCurrentTestResult(ITestResult iTestResult) {
        m_currentTestResult.set(iTestResult);
    }

    public static List<String> getOutput() {
        return m_output;
    }

    public static void clear() {
        m_methodOutputMap.clear();
        m_output.clear();
    }

    public static boolean getEscapeHtml() {
        return m_escapeHtml;
    }

    public static void setEscapeHtml(boolean bl) {
        m_escapeHtml = bl;
    }

    private static synchronized void log(String string, ITestResult iTestResult) {
        if (m_escapeHtml) {
            string = Strings.escapeHtml(string);
        }
        if (iTestResult == null) {
            if (m_orphanedOutput.get() == null) {
                m_orphanedOutput.set(new ArrayList());
            }
            m_orphanedOutput.get().add(string);
            return;
        }
        int n = Reporter.getOutput().size();
        List<Integer> list = m_methodOutputMap.get(iTestResult.hashCode());
        if (list == null) {
            list = Lists.newArrayList();
            m_methodOutputMap.put(iTestResult.hashCode(), list);
        }
        if (m_orphanedOutput.get() != null) {
            n += m_orphanedOutput.get().size();
            Reporter.getOutput().addAll((Collection<String>)m_orphanedOutput.get());
            m_orphanedOutput.remove();
        }
        list.add(n);
        Reporter.getOutput().add(string);
    }

    public static void log(String string) {
        Reporter.log(string, Reporter.getCurrentTestResult());
    }

    public static void log(String string, int n, boolean bl) {
        if (TestRunner.getVerbose() >= n) {
            Reporter.log(string, Reporter.getCurrentTestResult());
            if (bl) {
                System.out.println(string);
            }
        }
    }

    public static void log(String string, boolean bl) {
        Reporter.log(string, Reporter.getCurrentTestResult());
        if (bl) {
            System.out.println(string);
        }
    }

    public static void log(String string, int n) {
        if (TestRunner.getVerbose() >= n) {
            Reporter.log(string, Reporter.getCurrentTestResult());
        }
    }

    public static ITestResult getCurrentTestResult() {
        return m_currentTestResult.get();
    }

    public static synchronized List<String> getOutput(ITestResult iTestResult) {
        List<String> list = Lists.newArrayList();
        if (iTestResult == null) {
            return list;
        }
        List<Integer> list2 = m_methodOutputMap.get(iTestResult.hashCode());
        if (list2 != null) {
            for (Integer n : list2) {
                list.add(Reporter.getOutput().get(n));
            }
        }
        return list;
    }
}

