/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.parser;

import java.util.ArrayList;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.parser.ParseException;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.FeatureConfiguration;

public abstract class AbstractJSqlParser<P> {
    protected int jdbcParameterIndex = 0;
    protected boolean errorRecovery = false;
    protected List<ParseException> parseErrors = new ArrayList<ParseException>();

    public P withSquareBracketQuotation(boolean bl2) {
        return this.withFeature(Feature.allowSquareBracketQuotation, bl2);
    }

    public P withAllowComplexParsing(boolean bl2) {
        return this.withFeature(Feature.allowComplexParsing, bl2);
    }

    public P withFeature(Feature feature, boolean bl2) {
        this.getConfiguration().setValue(feature, bl2);
        return this.me();
    }

    public abstract FeatureConfiguration getConfiguration();

    public abstract P me();

    public boolean getAsBoolean(Feature feature) {
        return this.getConfiguration().getAsBoolean(feature);
    }

    public void setErrorRecovery(boolean bl2) {
        this.errorRecovery = bl2;
    }

    public List<ParseException> getParseErrors() {
        return this.parseErrors;
    }
}

