/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import java.util.ArrayList;
import liquibase.CatalogAndSchema;
import liquibase.change.Change;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangeGeneratorFactory;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class MissingPrimaryKeyChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (PrimaryKey.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, Column.class};
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Index.class};
    }

    @Override
    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Index backingIndex;
        ArrayList<Change> returnList = new ArrayList<Change>();
        PrimaryKey pk2 = (PrimaryKey)missingObject;
        AddPrimaryKeyChange change = this.createAddPrimaryKeyChange();
        change.setTableName(pk2.getTable().getName());
        if (control.getIncludeCatalog()) {
            change.setCatalogName(pk2.getTable().getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(pk2.getTable().getSchema().getName());
        }
        change.setConstraintName(pk2.getName());
        change.setColumnNames(pk2.getColumnNames());
        if (control.getIncludeTablespace()) {
            change.setTablespace(pk2.getTablespace());
        }
        if (referenceDatabase instanceof MSSQLDatabase && pk2.getBackingIndex() != null && pk2.getBackingIndex().getClustered() != null && !pk2.getBackingIndex().getClustered().booleanValue()) {
            change.setClustered(false);
        }
        if (referenceDatabase instanceof PostgresDatabase && pk2.getBackingIndex() != null && pk2.getBackingIndex().getClustered() != null && pk2.getBackingIndex().getClustered().booleanValue()) {
            change.setClustered(true);
        }
        if ((comparisonDatabase instanceof OracleDatabase || comparisonDatabase instanceof AbstractDb2Database && pk2.getBackingIndex() != null && !comparisonDatabase.isSystemObject(pk2.getBackingIndex())) && (backingIndex = pk2.getBackingIndex()) != null && backingIndex.getName() != null) {
            Object schema;
            try {
                Change[] fixes;
                if (!control.getIncludeCatalog() && !control.getIncludeSchema()) {
                    schema = comparisonDatabase.getDefaultSchema().customize(comparisonDatabase);
                    backingIndex.getRelation().setSchema(((CatalogAndSchema)schema).getCatalogName(), ((CatalogAndSchema)schema).getSchemaName());
                }
                if ((referenceDatabase.equals(comparisonDatabase) || !SnapshotGeneratorFactory.getInstance().has(backingIndex, comparisonDatabase)) && (fixes = ChangeGeneratorFactory.getInstance().fixMissing(backingIndex, control, referenceDatabase, comparisonDatabase)) != null) {
                    for (Change fix : fixes) {
                        if (fix == null) continue;
                        returnList.add(fix);
                    }
                }
            }
            catch (Exception e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
            change.setForIndexName(backingIndex.getName());
            schema = backingIndex.getSchema();
            if (schema != null) {
                if (control.getIncludeCatalog()) {
                    change.setForIndexCatalogName(((Schema)schema).getCatalogName());
                }
                if (control.getIncludeSchema()) {
                    change.setForIndexSchemaName(((Schema)schema).getName());
                }
            }
        }
        control.setAlreadyHandledMissing(pk2.getBackingIndex());
        returnList.add(change);
        return returnList.toArray(new Change[returnList.size()]);
    }

    protected AddPrimaryKeyChange createAddPrimaryKeyChange() {
        return new AddPrimaryKeyChange();
    }
}

