/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.util.concurrent.atomic.AtomicLong;
import org.agrona.concurrent.status.Position;

public class AtomicLongPosition
extends Position {
    private boolean isClosed = false;
    private final int id;
    private final AtomicLong value;

    public AtomicLongPosition() {
        this(0, 0L);
    }

    public AtomicLongPosition(int id) {
        this(id, 0L);
    }

    public AtomicLongPosition(int id, long initialValue) {
        this.id = id;
        this.value = new AtomicLong(initialValue);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public long get() {
        return this.value.get();
    }

    @Override
    public long getVolatile() {
        return this.value.get();
    }

    @Override
    public void set(long value) {
        this.value.lazySet(value);
    }

    @Override
    public void setOrdered(long value) {
        this.value.lazySet(value);
    }

    @Override
    public void setVolatile(long value) {
        this.value.set(value);
    }

    @Override
    public boolean proposeMax(long proposedValue) {
        return this.proposeMaxOrdered(proposedValue);
    }

    @Override
    public boolean proposeMaxOrdered(long proposedValue) {
        boolean updated = false;
        if (this.get() < proposedValue) {
            this.setOrdered(proposedValue);
            updated = true;
        }
        return updated;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public String toString() {
        return "AtomicLongPosition{isClosed=" + this.isClosed() + ", id=" + this.id + ", value=" + (this.isClosed() ? Integer.valueOf(-1) : this.value) + '}';
    }
}

