/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.ConnectException;
import java.util.Set;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryBuilder;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryFactory;
import org.rzo.netty.ahessian.bootstrap.DefaultEndpoint;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;

public class DefaultClient<T>
extends DefaultEndpoint {
    Bootstrap bootstrap;
    EventExecutorGroup internalGroup;
    EventLoopGroup workerGroup;
    ChannelPipelineFactoryBuilder<T> builder;
    private volatile boolean _stop = false;
    private volatile T _proxy;
    ChannelPipelineFactoryFactory _factory;

    public DefaultClient(Class channelClass, ChannelPipelineFactoryFactory factory, Set<String> channelOptions) {
        if (!Channel.class.isAssignableFrom(channelClass)) {
            throw new RuntimeException("serverChannelClass must implement ServerChannel");
        }
        this._factory = factory;
        if (factory instanceof ChannelPipelineFactoryBuilder) {
            this.builder = (ChannelPipelineFactoryBuilder)factory;
        }
        this.bootstrap = new Bootstrap();
        this.workerGroup = this.isNio(channelClass) ? new NioEventLoopGroup() : (this.isOio(channelClass) ? new OioEventLoopGroup() : new LocalEventLoopGroup());
        this.bootstrap.group(this.workerGroup);
        this.bootstrap.channel(channelClass);
        this.internalGroup = new DefaultEventExecutorGroup(10);
    }

    public void setRemoteAddress(String host, int port) {
        this.bootstrap.remoteAddress(host, port);
    }

    @Override
    public void start() throws Exception {
        this.bootstrap.handler((ChannelHandler)this._factory.create(this.internalGroup, (AbstractBootstrap)this.bootstrap));
        if (this.builder == null || !this.builder.hasReconnect()) {
            this._channel = this.connect();
        } else {
            while (this._channel == null && !this._stop) {
                try {
                    this._channel = this.connect();
                }
                catch (Exception ex) {
                    if (!(ex instanceof ConnectException)) continue;
                    System.out.println(ex);
                    Thread.sleep(this.builder._reconnectTimeout);
                }
            }
        }
    }

    private Channel connect() {
        ChannelFuture future = this.bootstrap.connect();
        try {
            Channel channel = future.sync().channel();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (future.isSuccess()) {
            return future.channel();
        }
        return null;
    }

    @Override
    public void stop() throws Exception {
        this._stop = true;
        this._channel.close().sync();
        this.workerGroup.shutdownGracefully();
        this.internalGroup.shutdownGracefully();
    }

    public void connectedListener(HessianRPCServiceHandler.ConnectListener listener) {
        this.builder.connectedListener(listener);
    }

    public void disconnectedListener(HessianRPCServiceHandler.ConnectListener listener) {
        this.builder.disconnectedListener(listener);
    }

    public T proxy() throws Exception {
        return this.builder.proxy();
    }

    public boolean isConnected() {
        return this._channel != null && this._channel.isActive();
    }

    public void close() {
        this.builder.close();
        if (this.getChannel() != null && this.getChannel().isActive()) {
            this.getChannel().close();
        }
    }

    public void unblock() {
        this.builder.unblock();
    }
}

