/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionUtils {
    private static final Map<ClassFieldName, Field> FIELD_CACHE = new ConcurrentHashMap<ClassFieldName, Field>();

    public static Field searchField(Class<?> clazz, String name) {
        return FIELD_CACHE.computeIfAbsent(new ClassFieldName(clazz, name), k -> ReflectionUtils._searchField(k.clazz, k.fieldName));
    }

    public static Field _searchField(Class<?> clazz, String name) {
        Class<?> scan = clazz;
        while (!scan.equals(Object.class)) {
            try {
                Field declaredField = scan.getDeclaredField(name);
                declaredField.setAccessible(true);
                return declaredField;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                scan = scan.getSuperclass();
            }
        }
        throw new IllegalArgumentException("Cannot find '" + name + "' field on " + clazz.getName());
    }

    public static RuntimeException handleInvocationTargetException(InvocationTargetException e, String msg) {
        Throwable cause = e.getCause();
        if (cause != null) {
            return new RuntimeException(msg + "\n" + cause.getMessage(), cause);
        }
        return new RuntimeException(msg, e);
    }

    public static void setField(Object on, String fieldName, Object value) {
        Field field = ReflectionUtils.searchField(on.getClass(), fieldName);
        ReflectionUtils.setField(on, field, value);
    }

    public static Object getField(Object on, Field field) {
        try {
            return field.get(on);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Could not get field %s on %s.", field.getName(), on), e);
        }
    }

    static void setField(Object on, Field field, Object value) {
        try {
            field.set(on, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Could not set field %s on %s to value %s.", field.getName(), on, value), e);
        }
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList interfacesFound = new ArrayList();
        ReflectionUtils.getAllInterfaces(cls, interfacesFound);
        return interfacesFound;
    }

    private static void getAllInterfaces(Class<?> cls, List<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = cls.getInterfaces()) {
                if (interfacesFound.contains(anInterface)) continue;
                interfacesFound.add(anInterface);
                ReflectionUtils.getAllInterfaces(anInterface, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static void setFieldWithConversion(Object on, String fieldName, String value) {
        block5: {
            Field field = ReflectionUtils.searchField(on.getClass(), fieldName);
            Class<?> type = field.getType();
            try {
                if (type.equals(String.class)) {
                    ReflectionUtils.setField(on, field, (Object)value);
                    break block5;
                }
                if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                    field.set(on, Integer.parseInt(value));
                    break block5;
                }
                if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                    field.set(on, Boolean.parseBoolean(value));
                    break block5;
                }
                throw new IllegalArgumentException(String.format("Cannot yet convert type [%s] for field [%s]", type, field));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Could not set field %s on %s to value %s.", field.getName(), on, value), e);
            }
        }
    }

    private static class ClassFieldName {
        private Class<?> clazz;
        private String fieldName;

        public ClassFieldName(Class<?> clazz, String fieldName) {
            this.clazz = clazz;
            this.fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassFieldName that = (ClassFieldName)o;
            return this.clazz.equals(that.clazz) && this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.fieldName.hashCode();
            return result;
        }
    }
}

