/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.AutoValue_XdsClusterResource_CdsUpdate;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.ClientXdsClient;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LoadBalancerConfigFactory;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsResourceType;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.CircuitBreakers;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.Cluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.cluster.v3.OutlierDetection;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.RoutingPriority;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.clusters.aggregate.v3.ClusterConfig;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;

class XdsClusterResource
extends XdsResourceType<CdsUpdate> {
    static final String ADS_TYPE_URL_CDS_V2 = "type.googleapis.com/envoy.api.v2.Cluster";
    static final String ADS_TYPE_URL_CDS = "type.googleapis.com/envoy.config.cluster.v3.Cluster";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT = "type.googleapis.com/envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext";
    private static final String TYPE_URL_UPSTREAM_TLS_CONTEXT_V2 = "type.googleapis.com/envoy.api.v2.auth.UpstreamTlsContext";
    private static final XdsClusterResource instance = new XdsClusterResource();

    XdsClusterResource() {
    }

    public static XdsClusterResource getInstance() {
        return instance;
    }

    @Override
    @Nullable
    String extractResourceName(Message unpackedResource) {
        if (!(unpackedResource instanceof Cluster)) {
            return null;
        }
        return ((Cluster)unpackedResource).getName();
    }

    @Override
    AbstractXdsClient.ResourceType typeName() {
        return AbstractXdsClient.ResourceType.CDS;
    }

    @Override
    String typeUrl() {
        return ADS_TYPE_URL_CDS;
    }

    @Override
    String typeUrlV2() {
        return ADS_TYPE_URL_CDS_V2;
    }

    @Override
    @Nullable
    AbstractXdsClient.ResourceType dependentResource() {
        return AbstractXdsClient.ResourceType.EDS;
    }

    @Override
    Class<Cluster> unpackedClassName() {
        return Cluster.class;
    }

    @Override
    CdsUpdate doParse(XdsResourceType.Args args, Message unpackedMessage, Set<String> retainedResources, boolean isResourceV3) throws ClientXdsClient.ResourceInvalidException {
        if (!(unpackedMessage instanceof Cluster)) {
            throw new ClientXdsClient.ResourceInvalidException("Invalid message type: " + unpackedMessage.getClass());
        }
        ImmutableSet certProviderInstances = null;
        if (args.bootstrapInfo != null && args.bootstrapInfo.certProviders() != null) {
            certProviderInstances = args.bootstrapInfo.certProviders().keySet();
        }
        return XdsClusterResource.processCluster((Cluster)unpackedMessage, retainedResources, (Set<String>)certProviderInstances, args.serverInfo, args.loadBalancerRegistry);
    }

    @VisibleForTesting
    static CdsUpdate processCluster(Cluster cluster, Set<String> retainedEdsResources, Set<String> certProviderInstances, Bootstrapper.ServerInfo serverInfo, LoadBalancerRegistry loadBalancerRegistry) throws ClientXdsClient.ResourceInvalidException {
        XdsResourceType.StructOrError<CdsUpdate.Builder> structOrError;
        switch (cluster.getClusterDiscoveryTypeCase()) {
            case TYPE: {
                structOrError = XdsClusterResource.parseNonAggregateCluster(cluster, retainedEdsResources, certProviderInstances, serverInfo);
                break;
            }
            case CLUSTER_TYPE: {
                structOrError = XdsClusterResource.parseAggregateCluster(cluster);
                break;
            }
            default: {
                throw new ClientXdsClient.ResourceInvalidException("Cluster " + cluster.getName() + ": unspecified cluster discovery type");
            }
        }
        if (structOrError.getErrorDetail() != null) {
            throw new ClientXdsClient.ResourceInvalidException(structOrError.getErrorDetail());
        }
        CdsUpdate.Builder updateBuilder = structOrError.getStruct();
        ImmutableMap<String, ?> lbPolicyConfig = LoadBalancerConfigFactory.newConfig(cluster, enableLeastRequest, enableCustomLbConfig);
        ServiceConfigUtil.LbConfig lbConfig = ServiceConfigUtil.unwrapLoadBalancingConfig(lbPolicyConfig);
        NameResolver.ConfigOrError configOrError = loadBalancerRegistry.getProvider(lbConfig.getPolicyName()).parseLoadBalancingPolicyConfig(lbConfig.getRawConfigValue());
        if (configOrError.getError() != null) {
            throw new ClientXdsClient.ResourceInvalidException(structOrError.getErrorDetail());
        }
        updateBuilder.lbPolicyConfig(lbPolicyConfig);
        return updateBuilder.build();
    }

    private static XdsResourceType.StructOrError<CdsUpdate.Builder> parseAggregateCluster(Cluster cluster) {
        ClusterConfig clusterConfig;
        String clusterName = cluster.getName();
        Cluster.CustomClusterType customType = cluster.getClusterType();
        String typeName = customType.getName();
        if (!typeName.equals("envoy.clusters.aggregate")) {
            return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": unsupported custom cluster type: " + typeName);
        }
        try {
            clusterConfig = XdsClusterResource.unpackCompatibleType(customType.getTypedConfig(), ClusterConfig.class, "type.googleapis.com/envoy.extensions.clusters.aggregate.v3.ClusterConfig", "type.googleapis.com/envoy.config.cluster.aggregate.v2alpha.ClusterConfig");
        }
        catch (InvalidProtocolBufferException e) {
            return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": malformed ClusterConfig: " + (Object)((Object)e));
        }
        return XdsResourceType.StructOrError.fromStruct(CdsUpdate.forAggregate(clusterName, (List<String>)clusterConfig.getClustersList()));
    }

    private static XdsResourceType.StructOrError<CdsUpdate.Builder> parseNonAggregateCluster(Cluster cluster, Set<String> edsResources, Set<String> certProviderInstances, Bootstrapper.ServerInfo serverInfo) {
        Cluster.DiscoveryType type;
        String clusterName = cluster.getName();
        Bootstrapper.ServerInfo lrsServerInfo = null;
        Long maxConcurrentRequests = null;
        EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = null;
        EnvoyServerProtoData.OutlierDetection outlierDetection = null;
        if (cluster.hasLrsServer()) {
            if (!cluster.getLrsServer().hasSelf()) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": only support LRS for the same management server");
            }
            lrsServerInfo = serverInfo;
        }
        if (cluster.hasCircuitBreakers()) {
            List<CircuitBreakers.Thresholds> thresholds = cluster.getCircuitBreakers().getThresholdsList();
            for (CircuitBreakers.Thresholds threshold : thresholds) {
                if (threshold.getPriority() != RoutingPriority.DEFAULT || !threshold.hasMaxRequests()) continue;
                maxConcurrentRequests = threshold.getMaxRequests().getValue();
            }
        }
        if (cluster.getTransportSocketMatchesCount() > 0) {
            return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": transport-socket-matches not supported.");
        }
        if (cluster.hasTransportSocket()) {
            if (!"envoy.transport_sockets.tls".equals(cluster.getTransportSocket().getName())) {
                return XdsResourceType.StructOrError.fromError("transport-socket with name " + cluster.getTransportSocket().getName() + " not supported.");
            }
            try {
                upstreamTlsContext = EnvoyServerProtoData.UpstreamTlsContext.fromEnvoyProtoUpstreamTlsContext(XdsClusterResource.validateUpstreamTlsContext(XdsClusterResource.unpackCompatibleType(cluster.getTransportSocket().getTypedConfig(), UpstreamTlsContext.class, TYPE_URL_UPSTREAM_TLS_CONTEXT, TYPE_URL_UPSTREAM_TLS_CONTEXT_V2), certProviderInstances));
            }
            catch (InvalidProtocolBufferException | ClientXdsClient.ResourceInvalidException e) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": malformed UpstreamTlsContext: " + e);
            }
        }
        if (cluster.hasOutlierDetection() && enableOutlierDetection) {
            try {
                outlierDetection = EnvoyServerProtoData.OutlierDetection.fromEnvoyOutlierDetection(XdsClusterResource.validateOutlierDetection(cluster.getOutlierDetection()));
            }
            catch (ClientXdsClient.ResourceInvalidException e) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": malformed outlier_detection: " + e);
            }
        }
        if ((type = cluster.getType()) == Cluster.DiscoveryType.EDS) {
            String edsServiceName = null;
            Cluster.EdsClusterConfig edsClusterConfig = cluster.getEdsClusterConfig();
            if (!edsClusterConfig.getEdsConfig().hasAds() && !edsClusterConfig.getEdsConfig().hasSelf()) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": field eds_cluster_config must be set to indicate to use EDS over ADS or self ConfigSource");
            }
            if (!edsClusterConfig.getServiceName().isEmpty()) {
                edsServiceName = edsClusterConfig.getServiceName();
                edsResources.add(edsServiceName);
            } else {
                edsResources.add(clusterName);
            }
            return XdsResourceType.StructOrError.fromStruct(CdsUpdate.forEds(clusterName, edsServiceName, lrsServerInfo, maxConcurrentRequests, upstreamTlsContext, outlierDetection));
        }
        if (type.equals((Object)Cluster.DiscoveryType.LOGICAL_DNS)) {
            if (!cluster.hasLoadAssignment()) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have a single host");
            }
            ClusterLoadAssignment assignment = cluster.getLoadAssignment();
            if (assignment.getEndpointsCount() != 1 || assignment.getEndpoints(0).getLbEndpointsCount() != 1) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have a single locality_lb_endpoint and a single lb_endpoint");
            }
            LbEndpoint lbEndpoint = assignment.getEndpoints(0).getLbEndpoints(0);
            if (!(lbEndpoint.hasEndpoint() && lbEndpoint.getEndpoint().hasAddress() && lbEndpoint.getEndpoint().getAddress().hasSocketAddress())) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": LOGICAL_DNS clusters must have an endpoint with address and socket_address");
            }
            SocketAddress socketAddress = lbEndpoint.getEndpoint().getAddress().getSocketAddress();
            if (!socketAddress.getResolverName().isEmpty()) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": LOGICAL DNS clusters must NOT have a custom resolver name set");
            }
            if (socketAddress.getPortSpecifierCase() != SocketAddress.PortSpecifierCase.PORT_VALUE) {
                return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": LOGICAL DNS clusters socket_address must have port_value");
            }
            String dnsHostName = String.format(Locale.US, "%s:%d", socketAddress.getAddress(), socketAddress.getPortValue());
            return XdsResourceType.StructOrError.fromStruct(CdsUpdate.forLogicalDns(clusterName, dnsHostName, lrsServerInfo, maxConcurrentRequests, upstreamTlsContext));
        }
        return XdsResourceType.StructOrError.fromError("Cluster " + clusterName + ": unsupported built-in discovery type: " + (Object)((Object)type));
    }

    static OutlierDetection validateOutlierDetection(OutlierDetection outlierDetection) throws ClientXdsClient.ResourceInvalidException {
        if (outlierDetection.hasInterval()) {
            if (!Durations.isValid((Duration)outlierDetection.getInterval())) {
                throw new ClientXdsClient.ResourceInvalidException("outlier_detection interval is not a valid Duration");
            }
            if (XdsClusterResource.hasNegativeValues(outlierDetection.getInterval())) {
                throw new ClientXdsClient.ResourceInvalidException("outlier_detection interval has a negative value");
            }
        }
        if (outlierDetection.hasBaseEjectionTime()) {
            if (!Durations.isValid((Duration)outlierDetection.getBaseEjectionTime())) {
                throw new ClientXdsClient.ResourceInvalidException("outlier_detection base_ejection_time is not a valid Duration");
            }
            if (XdsClusterResource.hasNegativeValues(outlierDetection.getBaseEjectionTime())) {
                throw new ClientXdsClient.ResourceInvalidException("outlier_detection base_ejection_time has a negative value");
            }
        }
        if (outlierDetection.hasMaxEjectionTime()) {
            if (!Durations.isValid((Duration)outlierDetection.getMaxEjectionTime())) {
                throw new ClientXdsClient.ResourceInvalidException("outlier_detection max_ejection_time is not a valid Duration");
            }
            if (XdsClusterResource.hasNegativeValues(outlierDetection.getMaxEjectionTime())) {
                throw new ClientXdsClient.ResourceInvalidException("outlier_detection max_ejection_time has a negative value");
            }
        }
        if (outlierDetection.hasMaxEjectionPercent() && outlierDetection.getMaxEjectionPercent().getValue() > 100) {
            throw new ClientXdsClient.ResourceInvalidException("outlier_detection max_ejection_percent is > 100");
        }
        if (outlierDetection.hasEnforcingSuccessRate() && outlierDetection.getEnforcingSuccessRate().getValue() > 100) {
            throw new ClientXdsClient.ResourceInvalidException("outlier_detection enforcing_success_rate is > 100");
        }
        if (outlierDetection.hasFailurePercentageThreshold() && outlierDetection.getFailurePercentageThreshold().getValue() > 100) {
            throw new ClientXdsClient.ResourceInvalidException("outlier_detection failure_percentage_threshold is > 100");
        }
        if (outlierDetection.hasEnforcingFailurePercentage() && outlierDetection.getEnforcingFailurePercentage().getValue() > 100) {
            throw new ClientXdsClient.ResourceInvalidException("outlier_detection enforcing_failure_percentage is > 100");
        }
        return outlierDetection;
    }

    static boolean hasNegativeValues(Duration duration) {
        return duration.getSeconds() < 0L || duration.getNanos() < 0;
    }

    @VisibleForTesting
    static UpstreamTlsContext validateUpstreamTlsContext(UpstreamTlsContext upstreamTlsContext, Set<String> certProviderInstances) throws ClientXdsClient.ResourceInvalidException {
        if (!upstreamTlsContext.hasCommonTlsContext()) {
            throw new ClientXdsClient.ResourceInvalidException("common-tls-context is required in upstream-tls-context");
        }
        XdsClusterResource.validateCommonTlsContext(upstreamTlsContext.getCommonTlsContext(), certProviderInstances, false);
        return upstreamTlsContext;
    }

    @VisibleForTesting
    static void validateCommonTlsContext(CommonTlsContext commonTlsContext, Set<String> certProviderInstances, boolean server) throws ClientXdsClient.ResourceInvalidException {
        String rootCaInstanceName;
        if (commonTlsContext.hasCustomHandshaker()) {
            throw new ClientXdsClient.ResourceInvalidException("common-tls-context with custom_handshaker is not supported");
        }
        if (commonTlsContext.hasTlsParams()) {
            throw new ClientXdsClient.ResourceInvalidException("common-tls-context with tls_params is not supported");
        }
        if (commonTlsContext.hasValidationContextSdsSecretConfig()) {
            throw new ClientXdsClient.ResourceInvalidException("common-tls-context with validation_context_sds_secret_config is not supported");
        }
        if (commonTlsContext.hasValidationContextCertificateProvider()) {
            throw new ClientXdsClient.ResourceInvalidException("common-tls-context with validation_context_certificate_provider is not supported");
        }
        if (commonTlsContext.hasValidationContextCertificateProviderInstance()) {
            throw new ClientXdsClient.ResourceInvalidException("common-tls-context with validation_context_certificate_provider_instance is not supported");
        }
        String certInstanceName = XdsClusterResource.getIdentityCertInstanceName(commonTlsContext);
        if (certInstanceName == null) {
            if (server) {
                throw new ClientXdsClient.ResourceInvalidException("tls_certificate_provider_instance is required in downstream-tls-context");
            }
            if (commonTlsContext.getTlsCertificatesCount() > 0) {
                throw new ClientXdsClient.ResourceInvalidException("tls_certificate_provider_instance is unset");
            }
            if (commonTlsContext.getTlsCertificateSdsSecretConfigsCount() > 0) {
                throw new ClientXdsClient.ResourceInvalidException("tls_certificate_provider_instance is unset");
            }
            if (commonTlsContext.hasTlsCertificateCertificateProvider()) {
                throw new ClientXdsClient.ResourceInvalidException("tls_certificate_provider_instance is unset");
            }
        } else if (certProviderInstances == null || !certProviderInstances.contains(certInstanceName)) {
            throw new ClientXdsClient.ResourceInvalidException("CertificateProvider instance name '" + certInstanceName + "' not defined in the bootstrap file.");
        }
        if ((rootCaInstanceName = XdsClusterResource.getRootCertInstanceName(commonTlsContext)) == null) {
            if (!server) {
                throw new ClientXdsClient.ResourceInvalidException("ca_certificate_provider_instance is required in upstream-tls-context");
            }
        } else {
            if (certProviderInstances == null || !certProviderInstances.contains(rootCaInstanceName)) {
                throw new ClientXdsClient.ResourceInvalidException("ca_certificate_provider_instance name '" + rootCaInstanceName + "' not defined in the bootstrap file.");
            }
            CertificateValidationContext certificateValidationContext = null;
            if (commonTlsContext.hasValidationContext()) {
                certificateValidationContext = commonTlsContext.getValidationContext();
            } else if (commonTlsContext.hasCombinedValidationContext() && commonTlsContext.getCombinedValidationContext().hasDefaultValidationContext()) {
                certificateValidationContext = commonTlsContext.getCombinedValidationContext().getDefaultValidationContext();
            }
            if (certificateValidationContext != null) {
                if (certificateValidationContext.getMatchSubjectAltNamesCount() > 0 && server) {
                    throw new ClientXdsClient.ResourceInvalidException("match_subject_alt_names only allowed in upstream_tls_context");
                }
                if (certificateValidationContext.getVerifyCertificateSpkiCount() > 0) {
                    throw new ClientXdsClient.ResourceInvalidException("verify_certificate_spki in default_validation_context is not supported");
                }
                if (certificateValidationContext.getVerifyCertificateHashCount() > 0) {
                    throw new ClientXdsClient.ResourceInvalidException("verify_certificate_hash in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasRequireSignedCertificateTimestamp()) {
                    throw new ClientXdsClient.ResourceInvalidException("require_signed_certificate_timestamp in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasCrl()) {
                    throw new ClientXdsClient.ResourceInvalidException("crl in default_validation_context is not supported");
                }
                if (certificateValidationContext.hasCustomValidatorConfig()) {
                    throw new ClientXdsClient.ResourceInvalidException("custom_validator_config in default_validation_context is not supported");
                }
            }
        }
    }

    private static String getIdentityCertInstanceName(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasTlsCertificateProviderInstance()) {
            return commonTlsContext.getTlsCertificateProviderInstance().getInstanceName();
        }
        if (commonTlsContext.hasTlsCertificateCertificateProviderInstance()) {
            return commonTlsContext.getTlsCertificateCertificateProviderInstance().getInstanceName();
        }
        return null;
    }

    private static String getRootCertInstanceName(CommonTlsContext commonTlsContext) {
        if (commonTlsContext.hasValidationContext()) {
            if (commonTlsContext.getValidationContext().hasCaCertificateProviderInstance()) {
                return commonTlsContext.getValidationContext().getCaCertificateProviderInstance().getInstanceName();
            }
        } else if (commonTlsContext.hasCombinedValidationContext()) {
            CommonTlsContext.CombinedCertificateValidationContext combinedCertificateValidationContext = commonTlsContext.getCombinedValidationContext();
            if (combinedCertificateValidationContext.hasDefaultValidationContext() && combinedCertificateValidationContext.getDefaultValidationContext().hasCaCertificateProviderInstance()) {
                return combinedCertificateValidationContext.getDefaultValidationContext().getCaCertificateProviderInstance().getInstanceName();
            }
            if (combinedCertificateValidationContext.hasValidationContextCertificateProviderInstance()) {
                return combinedCertificateValidationContext.getValidationContextCertificateProviderInstance().getInstanceName();
            }
        }
        return null;
    }

    @AutoValue
    static abstract class CdsUpdate
    implements XdsClient.ResourceUpdate {
        CdsUpdate() {
        }

        abstract String clusterName();

        abstract ClusterType clusterType();

        abstract ImmutableMap<String, ?> lbPolicyConfig();

        abstract long minRingSize();

        abstract long maxRingSize();

        abstract int choiceCount();

        @Nullable
        abstract String edsServiceName();

        @Nullable
        abstract String dnsHostName();

        @Nullable
        abstract Bootstrapper.ServerInfo lrsServerInfo();

        @Nullable
        abstract Long maxConcurrentRequests();

        @Nullable
        abstract EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext();

        @Nullable
        abstract ImmutableList<String> prioritizedClusterNames();

        @Nullable
        abstract EnvoyServerProtoData.OutlierDetection outlierDetection();

        static Builder forAggregate(String clusterName, List<String> prioritizedClusterNames) {
            Preconditions.checkNotNull(prioritizedClusterNames, (Object)"prioritizedClusterNames");
            return new AutoValue_XdsClusterResource_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.AGGREGATE).minRingSize(0L).maxRingSize(0L).choiceCount(0).prioritizedClusterNames((List<String>)ImmutableList.copyOf(prioritizedClusterNames));
        }

        static Builder forEds(String clusterName, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, @Nullable EnvoyServerProtoData.OutlierDetection outlierDetection) {
            return new AutoValue_XdsClusterResource_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.EDS).minRingSize(0L).maxRingSize(0L).choiceCount(0).edsServiceName(edsServiceName).lrsServerInfo(lrsServerInfo).maxConcurrentRequests(maxConcurrentRequests).upstreamTlsContext(upstreamTlsContext).outlierDetection(outlierDetection);
        }

        static Builder forLogicalDns(String clusterName, String dnsHostName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
            return new AutoValue_XdsClusterResource_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.LOGICAL_DNS).minRingSize(0L).maxRingSize(0L).choiceCount(0).dnsHostName(dnsHostName).lrsServerInfo(lrsServerInfo).maxConcurrentRequests(maxConcurrentRequests).upstreamTlsContext(upstreamTlsContext);
        }

        public final String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName()).add("clusterType", (Object)this.clusterType()).add("lbPolicyConfig", this.lbPolicyConfig()).add("minRingSize", this.minRingSize()).add("maxRingSize", this.maxRingSize()).add("choiceCount", this.choiceCount()).add("edsServiceName", (Object)this.edsServiceName()).add("dnsHostName", (Object)this.dnsHostName()).add("lrsServerInfo", (Object)this.lrsServerInfo()).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests()).add("prioritizedClusterNames", this.prioritizedClusterNames()).toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            protected abstract Builder clusterName(String var1);

            protected abstract Builder clusterType(ClusterType var1);

            protected abstract Builder lbPolicyConfig(ImmutableMap<String, ?> var1);

            Builder roundRobinLbPolicy() {
                return this.lbPolicyConfig(ImmutableMap.of((Object)"round_robin", (Object)ImmutableMap.of()));
            }

            Builder ringHashLbPolicy(Long minRingSize, Long maxRingSize) {
                return this.lbPolicyConfig(ImmutableMap.of((Object)"ring_hash_experimental", (Object)ImmutableMap.of((Object)"minRingSize", (Object)minRingSize.doubleValue(), (Object)"maxRingSize", (Object)maxRingSize.doubleValue())));
            }

            Builder leastRequestLbPolicy(Integer choiceCount) {
                return this.lbPolicyConfig(ImmutableMap.of((Object)"least_request_experimental", (Object)ImmutableMap.of((Object)"choiceCount", (Object)choiceCount.doubleValue())));
            }

            protected abstract Builder choiceCount(int var1);

            protected abstract Builder minRingSize(long var1);

            protected abstract Builder maxRingSize(long var1);

            protected abstract Builder edsServiceName(String var1);

            protected abstract Builder dnsHostName(String var1);

            protected abstract Builder lrsServerInfo(Bootstrapper.ServerInfo var1);

            protected abstract Builder maxConcurrentRequests(Long var1);

            protected abstract Builder upstreamTlsContext(EnvoyServerProtoData.UpstreamTlsContext var1);

            protected abstract Builder prioritizedClusterNames(List<String> var1);

            protected abstract Builder outlierDetection(EnvoyServerProtoData.OutlierDetection var1);

            abstract CdsUpdate build();
        }

        static enum LbPolicy {
            ROUND_ROBIN,
            RING_HASH,
            LEAST_REQUEST;

        }

        static enum ClusterType {
            EDS,
            LOGICAL_DNS,
            AGGREGATE;

        }
    }
}

