/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="not-contain")
@ApplicableTo(value={PropertyKind.STRING, PropertyKind.SET_OF_STRING, PropertyKind.LIST_OF_STRING, PropertyKind.MAP_STRING_STRING})
@Target(value={ElementType.FIELD})
public @interface NotContain {
    public static final String DEFAULT_MESSAGE = "The property must not contain %s.";

    public String message() default "The property must not contain %s.";

    public String[] value() default {};

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Object> {
        private String message = "The property must not contain %s.";
        private String[] value = new String[0];

        @Override
        public void validate(Object object, ValidationContext context) {
            List<String> values = Arrays.asList(this.value);
            String logFriendlyValues = String.join((CharSequence)", ", values).replaceFirst(",(?!.*,)", " and");
            if (object != null) {
                if (object instanceof String) {
                    String s = (String)object;
                    if (values.stream().anyMatch(s::contains)) {
                        context.error(this.message, logFriendlyValues);
                    }
                } else if (object instanceof Collection) {
                    if (this.containsAny((Collection)object, values)) {
                        context.error(this.message, logFriendlyValues);
                    }
                } else if (object instanceof Map && this.containsAny(((Map)object).keySet(), values)) {
                    context.error(this.message, logFriendlyValues);
                }
            }
        }

        private boolean containsAny(Collection<String> c1, Collection<String> c2) {
            return c1.stream().anyMatch(c2::contains);
        }

        public String getMessage() {
            return this.message;
        }

        public String[] getValue() {
            return this.value;
        }
    }
}

