/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service.aws;

import com.hierynomus.asn1.ASN1InputStream;
import com.hierynomus.asn1.encodingrules.ASN1Decoder;
import com.hierynomus.asn1.encodingrules.der.DERDecoder;
import com.hierynomus.asn1.types.ASN1Object;
import com.hierynomus.asn1.types.ASN1Tag;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.string.ASN1BitString;
import com.xebialabs.license.ASN1Utils;
import com.xebialabs.license.LicenseVerificationException;
import com.xebialabs.license.service.aws.SignatureVerifier$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\u0012%\u0001>B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u000f\"A\u0001\u000b\u0001BK\u0002\u0013\u0005a\t\u0003\u0005R\u0001\tE\t\u0015!\u0003H\u0011!\u0011\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u0011a\u0003!Q3A\u0005\u0002\u0019C\u0001\"\u0017\u0001\u0003\u0012\u0003\u0006Ia\u0012\u0005\u00065\u0002!\ta\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\u0006S\u0002!IA\u001b\u0005\u0006o\u0002!\t\u0001\u001f\u0005\u0006{\u0002!\tA \u0005\n\u0003\u001f\u0001\u0011\u0011!C\u0001\u0003#A\u0011\"a\u0007\u0001#\u0003%\t!!\b\t\u0013\u0005M\u0002!%A\u0005\u0002\u0005u\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u001c\u0011%\tY\u0004AI\u0001\n\u0003\ti\u0002C\u0005\u0002>\u0001\t\t\u0011\"\u0011\u0002@!A\u0011q\n\u0001\u0002\u0002\u0013\u00051\u000bC\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0013\u0011\r\u0005\n\u0003_\u0002\u0011\u0011!C\u0001\u0003cB\u0011\"a\u001f\u0001\u0003\u0003%\t%! \t\u0013\u0005\u0005\u0005!!A\u0005B\u0005\r\u0005\"CAC\u0001\u0005\u0005I\u0011IAD\u0011%\tI\tAA\u0001\n\u0003\nYiB\u0005\u0002\u0010\u0012\n\t\u0011#\u0001\u0002\u0012\u001aA1\u0005JA\u0001\u0012\u0003\t\u0019\n\u0003\u0004[;\u0011\u0005\u00111\u0016\u0005\n\u0003\u000bk\u0012\u0011!C#\u0003\u000fC\u0011\"!,\u001e\u0003\u0003%\t)a,\t\u0013\u0005eV$!A\u0005\u0002\u0006m\u0006\"CAg;\u0005\u0005I\u0011BAh\u0005E\u0019\u0016n\u001a8biV\u0014XMV3sS\u001aLWM\u001d\u0006\u0003K\u0019\n1!Y<t\u0015\t9\u0003&A\u0004tKJ4\u0018nY3\u000b\u0005%R\u0013a\u00027jG\u0016t7/\u001a\u0006\u0003W1\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u00197sA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\u0004\"!M\u001c\n\u0005a\u0012$a\u0002)s_\u0012,8\r\u001e\t\u0003u\ts!a\u000f!\u000f\u0005qzT\"A\u001f\u000b\u0005yr\u0013A\u0002\u001fs_>$h(C\u00014\u0013\t\t%'A\u0004qC\u000e\\\u0017mZ3\n\u0005\r#%\u0001D*fe&\fG.\u001b>bE2,'BA!3\u0003-\u0001(o\u001c3vGR\u001cu\u000eZ3\u0016\u0003\u001d\u0003\"\u0001\u0013'\u000f\u0005%S\u0005C\u0001\u001f3\u0013\tY%'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&3\u00031\u0001(o\u001c3vGR\u001cu\u000eZ3!\u0003\u0015qwN\\2f\u0003\u0019qwN\\2fA\u0005\u0001\u0002/\u001e2mS\u000e\\U-\u001f,feNLwN\\\u000b\u0002)B\u0011\u0011'V\u0005\u0003-J\u00121!\u00138u\u0003E\u0001XO\u00197jG.+\u0017PV3sg&|g\u000eI\u0001\naV\u0014G.[2LKf\f!\u0002];cY&\u001c7*Z=!\u0003\u0019a\u0014N\\5u}Q)ALX0aCB\u0011Q\fA\u0007\u0002I!)Q)\u0003a\u0001\u000f\")\u0001+\u0003a\u0001\u000f\")!+\u0003a\u0001)\")\u0001,\u0003a\u0001\u000f\u00061a/\u001a:jMf$\"\u0001Z4\u0011\u0005E*\u0017B\u000143\u0005\u0011)f.\u001b;\t\u000b!T\u0001\u0019A$\u0002\u0013MLwM\\1ukJ,\u0017!\u00038foNKwM\\3s+\u0005Y\u0007C\u00017v\u001b\u0005i'B\u00018p\u0003\u001d\u0019\u0018n\u001a8feNT!\u0001]9\u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\t\u00118/\u0001\u0007c_Vt7-_2bgRdWMC\u0001u\u0003\ry'oZ\u0005\u0003m6\u0014\u0011\u0002U*T'&<g.\u001a:\u0002\u001b)<HoQ8na>tWM\u001c;t)\tIH\u0010E\u00032u\u001e;u)\u0003\u0002|e\t1A+\u001e9mKNBQ\u0001\u001b\u0007A\u0002\u001d\u000bQB]3bIB+(\r\\5d\u0017\u0016LX#A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!\u0001o[2t\u0015\r\tI!]\u0001\u0005CNt\u0017'\u0003\u0003\u0002\u000e\u0005\r!\u0001\u0004*T\u0003B+(\r\\5d\u0017\u0016L\u0018\u0001B2paf$\u0012\u0002XA\n\u0003+\t9\"!\u0007\t\u000f\u0015s\u0001\u0013!a\u0001\u000f\"9\u0001K\u0004I\u0001\u0002\u00049\u0005b\u0002*\u000f!\u0003\u0005\r\u0001\u0016\u0005\b1:\u0001\n\u00111\u0001H\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\b+\u0007\u001d\u000b\tc\u000b\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012!C;oG\",7m[3e\u0015\r\tiCM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0019\u0003O\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002:)\u001aA+!\t\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005!A.\u00198h\u0015\t\tY%\u0001\u0003kCZ\f\u0017bA'\u0002F\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA+\u00037\u00022!MA,\u0013\r\tIF\r\u0002\u0004\u0003:L\b\u0002CA/+\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0007\u0005\u0004\u0002f\u0005-\u0014QK\u0007\u0003\u0003OR1!!\u001b3\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\n9G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA:\u0003s\u00022!MA;\u0013\r\t9H\r\u0002\b\u0005>|G.Z1o\u0011%\tifFA\u0001\u0002\u0004\t)&\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA!\u0003\u007fB\u0001\"!\u0018\u0019\u0003\u0003\u0005\r\u0001V\u0001\tQ\u0006\u001c\bnQ8eKR\tA+\u0001\u0005u_N#(/\u001b8h)\t\t\t%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003g\ni\tC\u0005\u0002^m\t\t\u00111\u0001\u0002V\u0005\t2+[4oCR,(/\u001a,fe&4\u0017.\u001a:\u0011\u0005uk2#B\u000f\u0002\u0016\u0006\u0005\u0006#CAL\u0003;;u\tV$]\u001b\t\tIJC\u0002\u0002\u001cJ\nqA];oi&lW-\u0003\u0003\u0002 \u0006e%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!\u00111UAU\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0013AA5p\u0013\r\u0019\u0015Q\u0015\u000b\u0003\u0003#\u000bQ!\u00199qYf$\u0012\u0002XAY\u0003g\u000b),a.\t\u000b\u0015\u0003\u0003\u0019A$\t\u000bA\u0003\u0003\u0019A$\t\u000bI\u0003\u0003\u0019\u0001+\t\u000ba\u0003\u0003\u0019A$\u0002\u000fUt\u0017\r\u001d9msR!\u0011QXAe!\u0015\t\u0014qXAb\u0013\r\t\tM\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fE\n)mR$U\u000f&\u0019\u0011q\u0019\u001a\u0003\rQ+\b\u000f\\35\u0011!\tY-IA\u0001\u0002\u0004a\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u001b\t\u0005\u0003\u0007\n\u0019.\u0003\u0003\u0002V\u0006\u0015#AB(cU\u0016\u001cG\u000f")
public class SignatureVerifier
implements Product,
Serializable {
    private final String productCode;
    private final String nonce;
    private final int publicKeyVersion;
    private final String publicKey;

    public static Option<Tuple4<String, String, Object, String>> unapply(SignatureVerifier x$0) {
        return SignatureVerifier$.MODULE$.unapply(x$0);
    }

    public static SignatureVerifier apply(String productCode, String nonce, int publicKeyVersion, String publicKey) {
        return SignatureVerifier$.MODULE$.apply(productCode, nonce, publicKeyVersion, publicKey);
    }

    public static Function1<Tuple4<String, String, Object, String>, SignatureVerifier> tupled() {
        return SignatureVerifier$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<Object, Function1<String, SignatureVerifier>>>> curried() {
        return SignatureVerifier$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String productCode() {
        return this.productCode;
    }

    public String nonce() {
        return this.nonce;
    }

    public int publicKeyVersion() {
        return this.publicKeyVersion;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public void verify(String signature) {
        PSSSigner signer = this.newSigner();
        Tuple3<String, String, String> tuple3 = this.jwtComponents(signature);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String header = (String)tuple3._1();
        String payload = (String)tuple3._2();
        String payloadSignature = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)header, (Object)payload, (Object)payloadSignature);
        String header2 = (String)tuple32._1();
        String payload2 = (String)tuple32._2();
        String payloadSignature2 = (String)tuple32._3();
        byte[] bytes = (header2 + "." + payload2).getBytes(StandardCharsets.UTF_8);
        signer.update(bytes, 0, bytes.length);
        byte[] decodedSignatureBytes = Base64.getUrlDecoder().decode(payloadSignature2.getBytes(StandardCharsets.UTF_8));
        if (!signer.verifySignature(decodedSignatureBytes)) {
            throw new LicenseVerificationException("Failed to verify the RegisterUsage signature from AWS (product c\u02c0ode: " + this.productCode() + ")");
        }
    }

    private PSSSigner newSigner() {
        PSSSigner signer = new PSSSigner((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA256Digest(), 32, -68);
        RSAPublicKey key = this.readPublicKey();
        signer.init(false, (CipherParameters)new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent()));
        return signer;
    }

    public Tuple3<String, String, String> jwtComponents(String signature) {
        String[] parts = signature.split("\\.");
        return new Tuple3((Object)parts[0], (Object)parts[1], (Object)parts[2]);
    }

    public RSAPublicKey readPublicKey() {
        String beginMarker = "-----BEGIN";
        String endMarker = "-----END";
        return (RSAPublicKey)ResourceManagement$.MODULE$.using((Closeable)new BufferedReader(new StringReader(this.publicKey())), (Function1 & Serializable)reader -> {
            Iterator lines = CollectionConverters$.MODULE$.IteratorHasAsScala(reader.lines().iterator()).asScala().filterNot((Function1 & Serializable)l -> BoxesRunTime.boxToBoolean((boolean)SignatureVerifier.$anonfun$readPublicKey$2(beginMarker, endMarker, l))).map((Function1 & Serializable)x$2 -> x$2.trim());
            ASN1InputStream derParser = new ASN1InputStream((ASN1Decoder)new DERDecoder(), Base64.getDecoder().decode(lines.mkString()));
            ASN1Object root = derParser.readObject();
            if (root.getTag().equals((Object)ASN1Tag.SEQUENCE)) {
                Option option = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)((ASN1Sequence)root)).asScala().collectFirst((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends ASN1Object<?>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof ASN1BitString) {
                            ASN1BitString aSN1BitString = (ASN1BitString)A1;
                            return (B1)ASN1Utils.constructBytes(aSN1BitString.getValue());
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(ASN1Object<?> x1) {
                        ASN1Object<?> aSN1Object = x1;
                        return aSN1Object instanceof ASN1BitString;
                    }
                });
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException("Could not find public key data in " + this.publicKey());
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                byte[] bytes = (byte[])some.value();
                RSAPublicKey pk = RSAPublicKey.getInstance((Object)bytes);
                return pk;
            }
            throw new IllegalStateException("Could not decode the ASN.1 public key data, got " + root);
        });
    }

    public SignatureVerifier copy(String productCode, String nonce, int publicKeyVersion, String publicKey) {
        return new SignatureVerifier(productCode, nonce, publicKeyVersion, publicKey);
    }

    public String copy$default$1() {
        return this.productCode();
    }

    public String copy$default$2() {
        return this.nonce();
    }

    public int copy$default$3() {
        return this.publicKeyVersion();
    }

    public String copy$default$4() {
        return this.publicKey();
    }

    public String productPrefix() {
        return "SignatureVerifier";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.productCode();
            }
            case 1: {
                return this.nonce();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.publicKeyVersion());
            }
            case 3: {
                return this.publicKey();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SignatureVerifier;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "productCode";
            }
            case 1: {
                return "nonce";
            }
            case 2: {
                return "publicKeyVersion";
            }
            case 3: {
                return "publicKey";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.productCode()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.nonce()));
        n = Statics.mix((int)n, (int)this.publicKeyVersion());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.publicKey()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SignatureVerifier)) return false;
        boolean bl = true;
        if (!bl) return false;
        SignatureVerifier signatureVerifier = (SignatureVerifier)x$1;
        if (this.publicKeyVersion() != signatureVerifier.publicKeyVersion()) return false;
        String string = this.productCode();
        String string2 = signatureVerifier.productCode();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.nonce();
        String string4 = signatureVerifier.nonce();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.publicKey();
        String string6 = signatureVerifier.publicKey();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        if (!signatureVerifier.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$readPublicKey$2(String beginMarker$1, String endMarker$1, String l) {
        return l.startsWith(beginMarker$1) || l.startsWith(endMarker$1);
    }

    public SignatureVerifier(String productCode, String nonce, int publicKeyVersion, String publicKey) {
        this.productCode = productCode;
        this.nonce = nonce;
        this.publicKeyVersion = publicKeyVersion;
        this.publicKey = publicKey;
        Product.$init$((Product)this);
    }
}

