/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.Version;
import org.python.core.BytecodeLoader;
import org.python.core.CompileMode;
import org.python.core.Options;
import org.python.core.PrePy;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyList;
import org.python.core.PyNullImporter;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.util.InteractiveConsole;
import org.python.util.OptionScanner;
import org.python.util.PythonInterpreter;

public class jython {
    public static final Logger logger;
    public static final String CONSOLE_LOG_FORMAT = "%3$s %4$s %5$s%n";
    private static final String PYTHON_CONSOLE_CLASS = "org.python.util.JLineConsole";
    private static final String COPYRIGHT = "Type \"help\", \"copyright\", \"credits\" or \"license\" for more information.";
    static final String usageHeader = "usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\n";
    static final String usageBody;

    static Status usage(Status status) {
        boolean fullHelp = status == Status.OK;
        PrintStream f = fullHelp ? System.out : System.err;
        f.printf(usageHeader, new Object[0]);
        if (fullHelp) {
            f.printf(usageBody, new Object[0]);
        } else {
            f.println("Try 'jython -h' for more information.");
        }
        return status;
    }

    private static void configureSimpleFormatter(String format) throws SecurityException {
        String CLASS_KEY = "java.util.logging.config.class";
        String className = System.getProperty("java.util.logging.config.class");
        if (className == null) {
            String FILE_KEY = "java.util.logging.config.file";
            String fileName = System.getProperty("java.util.logging.config.file");
            if (fileName == null) {
                String FORMAT_KEY = "java.util.logging.SimpleFormatter.format";
                String currentFormat = System.getProperty("java.util.logging.SimpleFormatter.format");
                if (currentFormat == null) {
                    System.setProperty("java.util.logging.SimpleFormatter.format", format);
                }
            }
        }
    }

    private static void setConsoleHandler(Logger logger) throws SecurityException {
        logger.setUseParentHandlers(false);
        ConsoleHandler handler2 = new ConsoleHandler();
        handler2.setLevel(Level.ALL);
        logger.addHandler(handler2);
    }

    public static int runJar(String filename) {
        try (ZipFile zip = new ZipFile(filename);){
            ZipEntry runit = zip.getEntry("__run__.py");
            if (runit == null) {
                throw Py.ValueError("can't find '__run__.py' in '" + filename + "'");
            }
            int beginIndex = filename.lastIndexOf(File.separator);
            if (beginIndex >= 0) {
                filename = filename.substring(beginIndex + 1);
            }
            PyStringMap locals = Py.newStringMap();
            locals.__setitem__("__name__", (PyObject)Py.fileSystemEncode(filename));
            locals.__setitem__("zipfile", Py.java2py(zip));
            InputStream file = zip.getInputStream(runit);
            PyCode code2 = Py.compile(file, "__run__", CompileMode.exec);
            Py.runCode(code2, locals, locals);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
        return Status.OK.ordinal();
    }

    @Deprecated
    public static void run(String[] args) {
        jython.main(args);
    }

    private static void exit(Status status) {
        System.exit(status.ordinal());
    }

    private static void addWarnOptionsFromEnv(PyList opts) {
        String envVar = jython.getenv("PYTHONWARNINGS", "");
        for (String opt : envVar.split(",")) {
            if ((opt = opt.trim()).length() <= 0) continue;
            opts.add(Py.fileSystemEncode(opt));
        }
    }

    private static Status runModule(String moduleName, boolean set_argv0) {
        PyObject runpy2 = imp.importName("runpy", true);
        PyObject runmodule = runpy2.__findattr__("_run_module_as_main");
        runmodule.__call__(Py.fileSystemEncode(moduleName), (PyObject)Py.newBoolean(set_argv0));
        return Status.OK;
    }

    private static Status runMainFromImporter(PyString archive) {
        PyObject importer2 = imp.getImporter(archive);
        if (!(importer2 instanceof PyNullImporter)) {
            Py.getSystemState().path.insert(0, archive);
            return jython.runModule("__main__", false);
        }
        return Status.NOT_RUN;
    }

    private static Status runSimpleFile(InputStream fp, String filename, PythonInterpreter interp) {
        String __file__ = "__file__";
        PyObject globals = interp.globals;
        PyObject previousFilename = globals.__finditem__("__file__");
        if (previousFilename == null) {
            globals.__setitem__("__file__", (PyObject)Py.fileSystemEncode(filename));
        }
        if (filename.endsWith("$py.class")) {
            String name = filename.substring(0, filename.length() - 6);
            try {
                byte[] codeBytes = imp.readCode(filename, fp, false, -1L);
                File file = new File(filename);
                PyCode code2 = BytecodeLoader.makeCode(name, codeBytes, file.getParent());
                interp.exec(code2);
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
        } else {
            interp.execfile(fp, filename);
        }
        if (previousFilename == null) {
            globals.__delitem__("__file__");
        }
        return Status.OK;
    }

    private static Status runStream(InputStream fp, String filename, InteractiveConsole interp) {
        String string2 = filename = filename != null ? filename : "???";
        if (PrePy.isInteractive(fp, filename)) {
            interp.interact(null, new PyFile(fp));
        } else {
            jython.runSimpleFile(fp, filename, interp);
        }
        return Status.OK;
    }

    private static Status runFile(String filename, InteractiveConsole interp) {
        Status status;
        File file = new File(filename);
        FileInputStream is = new FileInputStream(file);
        try {
            String parent = file.getAbsoluteFile().getParent();
            interp.getSystemState().path.insert(0, Py.fileSystemEncode(parent));
            status = jython.runStream(is, filename, interp);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                jython.printError("can't open file '%s': %s", filename, fnfe);
                return Status.NO_FILE;
            }
            catch (IOException ioe) {
                jython.printError("error closing '%s': %s", filename, ioe);
                return Status.ERROR;
            }
        }
        ((InputStream)is).close();
        return status;
    }

    private static void runStartupFile(InteractiveConsole interp) {
        String filename = PySystemState.registry.getProperty("python.startup", null);
        if (filename != null) {
            try (FileInputStream fp = new FileInputStream(filename);){
                jython.runSimpleFile(fp, filename, interp);
            }
            catch (FileNotFoundException fnfe) {
                jython.printError("Could not open startup file '%s'", filename);
            }
            catch (IOException ioe) {
                jython.printError("error closing '%s': %s", filename, ioe);
            }
        }
    }

    public static void main(String[] args) {
        boolean haveScript;
        CommandLineOptions opts = CommandLineOptions.parse(args);
        switch (opts.action) {
            case VERSION: {
                System.err.printf("Jython %s\n", Version.PY_VERSION);
                jython.exit(Status.OK);
            }
            case HELP: {
                jython.exit(jython.usage(Status.OK));
            }
            case ERROR: {
                System.err.println(opts.message);
                jython.exit(jython.usage(Status.ERROR));
            }
        }
        PrePy.increaseLoggingLevel(opts.verbosity);
        Properties preProperties = PrePy.getSystemProperties();
        jython.addDefaultsFromEnvironment(preProperties);
        boolean haveDash = "-".equals(opts.filename);
        if (haveDash) {
            opts.filename = null;
        }
        boolean stdinIsInteractive = PrePy.isInteractive(System.in, null);
        boolean bl = haveScript = opts.command != null || opts.filename != null || opts.module != null;
        if ((Options.inspect || !haveScript) && PrePy.haveConsole()) {
            jython.addDefault(preProperties, "python.console", PYTHON_CONSOLE_CLASS);
        }
        PySystemState.initialize(preProperties, opts.properties);
        PySystemState sys = Py.getSystemState();
        jython.addFSEncoded(opts.warnoptions, sys.warnoptions);
        jython.addWarnOptionsFromEnv(sys.warnoptions);
        if (!sys.warnoptions.isEmpty()) {
            imp.load("warnings");
        }
        InteractiveConsole interp = new InteractiveConsole();
        if (opts.verbosity > 0 || !haveScript && stdinIsInteractive) {
            System.err.println(InteractiveConsole.getDefaultBanner());
            if (Options.importSite) {
                System.err.println(COPYRIGHT);
            }
        }
        jython.addFSEncoded(opts.argv, sys.argv);
        Status sts = Status.NOT_RUN;
        try {
            if (opts.command != null) {
                sys.argv.set(0, Py.newString("-c"));
                sys.path.insert(0, Py.EmptyString);
                interp.exec(opts.command);
                sts = Status.OK;
            } else if (opts.module != null) {
                sys.argv.set(0, Py.newString("-m"));
                sts = jython.runModule(opts.module, true);
            } else if (opts.filename != null) {
                PyString pyFileName = Py.fileSystemEncode(opts.filename);
                sys.argv.set(0, pyFileName);
                if (opts.jar) {
                    sys.path.insert(0, pyFileName);
                    jython.runJar(opts.filename);
                    sts = Status.OK;
                } else {
                    sts = jython.runMainFromImporter(pyFileName);
                    if (sts == Status.NOT_RUN) {
                        sts = jython.runFile(opts.filename, interp);
                        haveScript = sts != Status.NO_FILE;
                    }
                }
            } else {
                if (haveDash) {
                    sys.argv.set(0, Py.newString('-'));
                }
                sys.path.insert(0, Py.EmptyString);
                if (stdinIsInteractive) {
                    Options.inspect = false;
                    jython.runStartupFile(interp);
                }
                sts = jython.runStream(System.in, "<stdin>", interp);
            }
        }
        catch (PyException pye) {
            Py.printException(pye);
            sts = Status.ERROR;
        }
        if (!Options.inspect) {
            boolean bl2 = Options.inspect = Py.getenv("PYTHONINSPECT", "").length() > 0;
        }
        if (Options.inspect && stdinIsInteractive && haveScript) {
            try {
                Options.inspect = false;
                sts = jython.runStream(System.in, "<stdin>", interp);
            }
            catch (PyException pye) {
                Py.printException(pye);
                sts = Status.ERROR;
            }
        }
        if (sts != Status.OK) {
            interp.cleanup();
            jython.exit(sts);
        }
    }

    private static boolean addDefault(Properties registry, String key, String value) {
        if (value == null || registry.containsKey(key)) {
            return false;
        }
        registry.setProperty(key, value);
        return true;
    }

    private static void addDefaultsFromEnvironment(Properties registry) {
        jython.addDefault(registry, "python.path", jython.getenv("JYTHONPATH"));
        jython.addDefault(registry, "python.startup", jython.getenv("JYTHONSTARTUP"));
        jython.addDefault(registry, "python.inspect", jython.getenv("PYTHONINSPECT"));
        String pythonIoEncoding = jython.getenv("PYTHONIOENCODING");
        if (pythonIoEncoding != null) {
            String[] spec = pythonIoEncoding.split(":", 2);
            jython.addDefault(registry, "python.io.encoding", spec[0]);
            if (spec.length > 1) {
                jython.addDefault(registry, "python.io.errors", spec[1]);
            }
        }
    }

    private static String getenv(String name) {
        return jython.getenv(name, null);
    }

    private static String getenv(String name, String defaultValue) {
        if (!Options.ignore_environment) {
            try {
                String value = System.getenv(name);
                return value != null && value.length() > 0 ? value : defaultValue;
            }
            catch (SecurityException e) {
                Options.ignore_environment = true;
            }
        }
        return defaultValue;
    }

    private static void optionNotSupported(char option) {
        jython.printError("Option -%c is not supported", Character.valueOf(option));
    }

    private static void printError(String format, Object ... args) {
        System.err.println(String.format("jython: " + format, args));
    }

    private static void addFSEncoded(Iterable<String> source, PyList destination) {
        for (String s : source) {
            destination.add(Py.fileSystemEncode(s));
        }
    }

    static {
        SecurityException exception = null;
        try {
            jython.configureSimpleFormatter(CONSOLE_LOG_FORMAT);
        }
        catch (SecurityException se) {
            exception = se;
        }
        logger = Logger.getLogger("org.python");
        if (exception == null) {
            try {
                jython.setConsoleHandler(logger);
            }
            catch (SecurityException se) {
                exception = se;
            }
        }
        if (exception != null) {
            logger.log(Level.WARNING, "Unable to format console messages: {0}", exception.getMessage());
        }
        usageBody = "Options and arguments:\n-B       : don't write bytecode files on import\n-c cmd   : program passed in as string (terminates option list)\n-Dprop=v : Set the property `prop' to value `v'\n-E       : ignore environment variables (such as JYTHONPATH)\n-h       : print this help message and exit (also --help)\n-i       : inspect interactively after running script; forces a prompt even\n           if stdin does not appear to be a terminal; also PYTHONINSPECT=x\n-jar jar : program read from __run__.py in jar file. Deprecated: instead,\n           name the archive as the file argument (runs __main__.py).\n-m mod   : run library module as a script (terminates option list)\n-Q arg   : division options: -Qold (default), -Qwarn, -Qwarnall, -Qnew\n-s       : don't add user site directory to sys.path;\n-S       : don't imply 'import site' on initialization\n-u       : unbuffered binary stdout and stderr\n-v       : verbose (emit more \"org.python\" log messages)\n           can be supplied multiple times to increase verbosity\n-V       : print the Python version number and exit (also --version)\n-W arg   : warning control (arg is action:message:category:module:lineno)\n-3       : warn about Python 3.x incompatibilities that 2to3 cannot trivially fix\nfile     : program read from script file\n-        : program read from stdin (default; interactive mode if a tty)\narg ...  : arguments passed to program in sys.argv[1:]\n\nOther environment variables:\nJYTHONSTARTUP: file executed on interactive startup (no default)\nJYTHONPATH   : '" + File.pathSeparator + "'-separated list of directories prefixed to the default module\n               search path.  The result is sys.path.\nPYTHONIOENCODING: Encoding[:errors] used for stdin/stdout/stderr.";
    }

    static class CommandLineOptions {
        Action action = Action.RUN;
        String message = "";
        String command;
        String filename;
        String module;
        boolean help = false;
        boolean version = false;
        boolean jar = false;
        int verbosity = 0;
        Properties properties = new Properties();
        List<String> argv = new LinkedList<String>();
        List<String> warnoptions = new LinkedList<String>();
        static final String PROGRAM_OPTS = "3bBc:dEhim:OQ:RsStuUvVW:x?XJD:";
        static final char JAR_OPTION = '\u2615';
        static final OptionScanner.LongSpec[] PROGRAM_LONG_OPTS = new OptionScanner.LongSpec[]{new OptionScanner.LongSpec("--", '\uffff'), new OptionScanner.LongSpec("--help", 'h'), new OptionScanner.LongSpec("--version", 'V'), new OptionScanner.LongSpec("-jar", '\u2615', true)};

        CommandLineOptions() {
        }

        static CommandLineOptions parse(String[] args) {
            CommandLineOptions opts = new CommandLineOptions();
            opts._parse(args);
            return opts;
        }

        private void _parse(String[] args) {
            OptionScanner scanner2 = new OptionScanner(args, PROGRAM_OPTS, PROGRAM_LONG_OPTS);
            this._parse(scanner2, args);
            if (this.action == Action.RUN) {
                while (scanner2.countRemainingArguments() > 0) {
                    this.argv.add(scanner2.getWholeArgument());
                }
            }
        }

        private void _parse(OptionScanner scanner2, String[] args) {
            char c;
            block41: while (this.action == Action.RUN && (c = scanner2.getOption()) != '\uffff') {
                switch (c) {
                    case 'c': {
                        this.command = scanner2.getOptionArgument() + "\n";
                        return;
                    }
                    case 'm': {
                        this.module = scanner2.getOptionArgument();
                        return;
                    }
                    case '\u2615': {
                        this.jar = true;
                        this.filename = scanner2.getOptionArgument();
                        return;
                    }
                    case '\ufffd': {
                        this.filename = scanner2.getWholeArgument();
                        return;
                    }
                    case 'b': 
                    case 'd': {
                        jython.optionNotSupported(c);
                        continue block41;
                    }
                    case '3': {
                        Options.py3k_warning = true;
                        if (Options.division_warning != 0) continue block41;
                        Options.division_warning = 1;
                        continue block41;
                    }
                    case 'Q': {
                        switch (scanner2.getOptionArgument()) {
                            case "old": {
                                Options.division_warning = 0;
                                continue block41;
                            }
                            case "warn": {
                                Options.division_warning = 1;
                                continue block41;
                            }
                            case "warnall": {
                                Options.division_warning = 2;
                                continue block41;
                            }
                            case "new": {
                                Options.Qnew = true;
                            }
                        }
                        this.error("-Q option should be `-Qold', `-Qwarn', `-Qwarnall', or `-Qnew' only", new Object[0]);
                        continue block41;
                    }
                    case 'i': {
                        Options.interactive = true;
                        Options.inspect = true;
                        continue block41;
                    }
                    case 'O': {
                        ++Options.optimize;
                        continue block41;
                    }
                    case 'B': {
                        Options.dont_write_bytecode = true;
                        continue block41;
                    }
                    case 's': {
                        Options.no_user_site = true;
                        continue block41;
                    }
                    case 'S': {
                        Options.no_site = true;
                        Options.importSite = false;
                        continue block41;
                    }
                    case 'E': {
                        Options.ignore_environment = true;
                        continue block41;
                    }
                    case 't': {
                        jython.optionNotSupported(c);
                        continue block41;
                    }
                    case 'u': {
                        Options.unbuffered = true;
                        continue block41;
                    }
                    case 'v': {
                        ++this.verbosity;
                        continue block41;
                    }
                    case 'x': {
                        jython.optionNotSupported(c);
                        continue block41;
                    }
                    case 'U': {
                        jython.optionNotSupported(c);
                        continue block41;
                    }
                    case 'W': {
                        this.warnoptions.add(scanner2.getOptionArgument());
                        continue block41;
                    }
                    case 'R': {
                        jython.optionNotSupported(c);
                        continue block41;
                    }
                    case 'D': {
                        try {
                            this.optionD(scanner2);
                        }
                        catch (SecurityException securityException) {}
                        continue block41;
                    }
                    case '?': 
                    case 'h': {
                        this.action = Action.HELP;
                        continue block41;
                    }
                    case 'V': {
                        this.action = Action.VERSION;
                        continue block41;
                    }
                    case 'J': {
                        this.error("-J is only valid when using the Jython launcher. In a complex command, put the -J options early.", new Object[0]);
                        continue block41;
                    }
                    case '\ufffe': {
                        this.error(scanner2.getMessage(), new Object[0]);
                        continue block41;
                    }
                }
                this.error("parser did not recognise option -%c \\u%04x", Character.valueOf(c), Character.valueOf(c));
            }
        }

        private void optionD(OptionScanner scanner2) throws SecurityException {
            String[] kv = scanner2.getOptionArgument().split("=", 2);
            String prop = kv[0].trim();
            if (kv.length > 1) {
                this.properties.put(prop, kv[1]);
            } else {
                this.properties.put(prop, "");
            }
        }

        private void error(String message2, Object ... args) {
            this.message = args.length == 0 ? message2 : String.format(message2, args);
            this.action = Action.ERROR;
        }

        static enum Action {
            RUN,
            ERROR,
            HELP,
            VERSION;

        }
    }

    private static enum Status {
        OK,
        ERROR,
        NOT_RUN,
        NO_FILE;

    }
}

