/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class LocalFileSample {
    public static void main(String[] args) throws IOException {
        String source = "C:\\softwares\\terraform-files\\json";
        String dest = "C:\\softwares\\terraform-files\\out-from-java-lf";
        LocalFile srcFile = LocalFile.from((File)new File(source));
        LocalFile destFile = LocalFile.from((File)new File(dest));
        srcFile.copyTo((OverthereFile)destFile);
        LocalFile temp = LocalFile.from((File)Files.createTempDirectory("terraform-stitch", new FileAttribute[0]).toFile());
        OverthereFile tempDest = OverthereUtils.getUniqueFolder((OverthereFile)temp, (String)"artifact");
        System.out.println("the tempDest -- " + tempDest.getPath());
        srcFile.copyTo(tempDest);
        LocalFileSample.zipFolder(Paths.get(tempDest.getPath(), new String[0]).toFile(), tempDest.getPath() + "final.zip");
    }

    public static void pack(String sourceDirPath, String zipFilePath) throws IOException {
        Path p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            });
        }
    }

    public static void pack(final Path folder, Path zipFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath.toFile());
             final ZipOutputStream zos = new ZipOutputStream(fos);){
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    zos.putNextEntry(new ZipEntry(folder.relativize(file).toString()));
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    zos.putNextEntry(new ZipEntry(folder.relativize(dir).toString() + "/"));
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void zipFolder(File sourceDirPath, String zipFilePath) throws IOException {
        Path p = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            LocalFileSample.processFolder(sourceDirPath, zipOutputStream, sourceDirPath.getPath().length() + 1);
        }
    }

    private static void processFolder(File folder, ZipOutputStream zipOutputStream, int prefixLength) throws IOException {
        for (File file : folder.listFiles()) {
            if (file.isFile()) {
                ZipEntry zipEntry = new ZipEntry(file.getPath().substring(prefixLength));
                zipOutputStream.putNextEntry(zipEntry);
                try (FileInputStream inputStream = new FileInputStream(file);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                }
                zipOutputStream.closeEntry();
                continue;
            }
            if (!file.isDirectory()) continue;
            LocalFileSample.processFolder(file, zipOutputStream, prefixLength);
        }
    }
}

