/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.index;

import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.GitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.ExecutionLogger;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.GitSourceBranch;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.GitSourceBranch$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.GitSourceScannerService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.DefaultRepositoryCrawler;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler$StitchRepositoryLoadException$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.StitchDefinitionsWithContent;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.adapter.FolderSourceEntryAdapter$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.GitSourceInfo;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.StitchScanResult;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.StitchSourceInfo;
import com.xebialabs.deployit.plugin.stitch.service.engine.util.ResourceManagement$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import org.eclipse.jgit.api.Git;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.LazyList;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001\u0002\u0005\n\u0001iA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)\u0011\b\u0001C\u0001u!)a\b\u0001C\u0005\u007f!)A\u000f\u0001C\u0005k\")Q\u0010\u0001C\u0001}\"1Q\u0010\u0001C!\u0003\u0017\u0011a\u0004R3gCVdGoR5u'>,(oY3TG\u0006tg.\u001a:TKJ4\u0018nY3\u000b\u0005)Y\u0011!B5oI\u0016D(B\u0001\u0007\u000e\u0003\u0019)gnZ5oK*\u0011abD\u0001\bg\u0016\u0014h/[2f\u0015\t\u0001\u0012#\u0001\u0004ti&$8\r\u001b\u0006\u0003%M\ta\u0001\u001d7vO&t'B\u0001\u000b\u0016\u0003!!W\r\u001d7ps&$(B\u0001\f\u0018\u0003%AXMY5bY\u0006\u00147OC\u0001\u0019\u0003\r\u0019w.\\\u0002\u0001'\u0011\u00011$I\u0013\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u00113%D\u0001\n\u0013\t!\u0013BA\fHSR\u001cv.\u001e:dKN\u001b\u0017M\u001c8feN+'O^5dKB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0006g24GG\u001b\u0006\u0002U\u0005AqM]5{u2,G-\u0003\u0002-O\t9Aj\\4hS:<\u0017!\u0005:fa>\u001c\u0018\u000e^8ss\u000e\u0013\u0018m\u001e7feB\u0011qFM\u0007\u0002a)\u0011\u0011'C\u0001\bGJ\fw\u000f\\3s\u0013\t\u0019\u0004G\u0001\rEK\u001a\fW\u000f\u001c;SKB|7/\u001b;pef\u001c%/Y<mKJ\fQbZ5u\u001fB\u001c8+\u001a:wS\u000e,\u0007C\u0001\u001c8\u001b\u0005i\u0011B\u0001\u001d\u000e\u000559\u0015\u000e^(qgN+'O^5dK\u00061A(\u001b8jiz\"2a\u000f\u001f>!\t\u0011\u0003\u0001C\u0003.\u0007\u0001\u0007a\u0006C\u00035\u0007\u0001\u0007Q'\u0001\nde\u0006<HnR5u%\u0016\u0004xn]5u_JLHC\u0001!V)\t\t\u0005\u000bE\u0002C\u00156s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019K\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\tIU$A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%\u0001\u0003'bufd\u0015n\u001d;\u000b\u0005%k\u0002CA\u0018O\u0013\ty\u0005G\u0001\u000fTi&$8\r\u001b#fM&t\u0017\u000e^5p]N<\u0016\u000e\u001e5D_:$XM\u001c;\t\u000bE#\u00019\u0001*\u0002\u001f\u0015DXmY;uS>tGj\\4hKJ\u0004\"AI*\n\u0005QK!aD#yK\u000e,H/[8o\u0019><w-\u001a:\t\u000bY#\u0001\u0019A,\u0002\u0013I,7o\\;sG\u0016\u001c\b#\u0002\u000fY5\u001ad\u0017BA-\u001e\u0005\u0019!V\u000f\u001d7fgA\u00111\fZ\u0007\u00029*\u0011QLX\u0001\u0004CBL'BA0a\u0003\u0011Qw-\u001b;\u000b\u0005\u0005\u0014\u0017aB3dY&\u00048/\u001a\u0006\u0002G\u0006\u0019qN]4\n\u0005\u0015d&aA$jiB\u0011qM[\u0007\u0002Q*\u0011\u0011.C\u0001\u0004IR|\u0017BA6i\u000559\u0015\u000e^*pkJ\u001cW-\u00138g_B\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0003S>T\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002t]\n!a)\u001b7f\u0003I\u0019Gn\u001c8f\u000f&$(+\u001a9pg&$xN]=\u0015\u0005YDHCA,x\u0011\u0015\tV\u0001q\u0001S\u0011\u0015IX\u00011\u0001{\u0003\u0019\u0019x.\u001e:dKB\u0011!e_\u0005\u0003y&\u0011qbR5u'>,(oY3Ce\u0006t7\r[\u0001\u0005g\u000e\fg\u000eF\u0002\u0000\u0003\u0013!B!!\u0001\u0002\bA\u0019q-a\u0001\n\u0007\u0005\u0015\u0001N\u0001\tTi&$8\r[*dC:\u0014Vm];mi\")\u0011K\u0002a\u0002%\")\u0011P\u0002a\u0001uR!\u0011QBA\t)\u0011\t\t!a\u0004\t\u000bE;\u00019\u0001*\t\re<\u0001\u0019AA\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\t!aY5\u000b\u0007\u0005uq\"A\u0003n_\u0012,G.\u0003\u0003\u0002\"\u0005]!!C$jiN{WO]2fQ\r\u0001\u0011Q\u0005\t\u0005\u0003O\tI$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003_\t\t$A\u0004gC\u000e$xN]=\u000b\t\u0005M\u0012QG\u0001\u0006E\u0016\fgn\u001d\u0006\u0004\u0003o\u0011\u0017aD:qe&twM\u001a:b[\u0016<xN]6\n\t\u0005m\u0012\u0011\u0006\u0002\n\u0003V$xn^5sK\u0012D3\u0001AA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#\u0002BA#\u0003k\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tI%a\u0011\u0003\u0013\r{W\u000e]8oK:$\b")
public class DefaultGitSourceScannerService
implements GitSourceScannerService,
Logging {
    private final DefaultRepositoryCrawler repositoryCrawler;
    private final GitOpsService gitOpsService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultGitSourceScannerService defaultGitSourceScannerService = this;
        synchronized (defaultGitSourceScannerService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private LazyList<StitchDefinitionsWithContent> crawlGitRepository(Tuple3<Git, GitSourceInfo, File> resources, ExecutionLogger executionLogger) {
        Tuple3<Git, GitSourceInfo, File> tuple3 = resources;
        if (tuple3 != null) {
            File folder = (File)tuple3._3();
            if (tuple3._1() != null && folder != null) {
                File file = folder;
                this.debug((Function0<Object>)(Function0 & Serializable)() -> "Indexing local git repository: " + file);
                executionLogger.log("Started indexing local git source [" + file + "]");
                LazyList<StitchDefinitionsWithContent> crawlResult = this.repositoryCrawler.crawl(FolderSourceEntryAdapter$.MODULE$.apply(file.toPath()), executionLogger);
                executionLogger.log("Indexing finished successfully");
                return crawlResult;
            }
        }
        throw new MatchError(tuple3);
    }

    private Tuple3<Git, GitSourceInfo, File> cloneGitRepository(GitSourceBranch source, ExecutionLogger executionLogger) {
        Tuple3<Git, File, String> tuple3;
        Option<String> option = source.branchName();
        if (option instanceof Some) {
            Some some = (Some)option;
            String branch = (String)some.value();
            v0 = this.gitOpsService.cloneGitRepositoryBranch(source.gitSource(), branch);
        } else {
            v0 = tuple3 = this.gitOpsService.cloneGitRepository(source.gitSource());
        }
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Git git = (Git)tuple3._1();
        File localRepoFolder = (File)tuple3._2();
        String branch = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)git, (Object)localRepoFolder, (Object)branch);
        Git git2 = (Git)tuple32._1();
        File localRepoFolder2 = (File)tuple32._2();
        String branch2 = (String)tuple32._3();
        executionLogger.log("Cloning git source into a local folder [" + localRepoFolder2 + "]...");
        if (git2.getRepository() != null && git2.getRepository().findRef(branch2) != null) {
            GitSourceInfo stitchGitSourceInfo = this.gitOpsService.getGitSourceInfo(branch2, localRepoFolder2);
            executionLogger.log("Git commit [" + stitchGitSourceInfo.commitId() + "] committed by [" + stitchGitSourceInfo.commitAuthor() + "]");
            executionLogger.log("Fetching finished successfully");
            return new Tuple3((Object)git2, (Object)stitchGitSourceInfo, (Object)localRepoFolder2);
        }
        throw RepositoryCrawler$StitchRepositoryLoadException$.MODULE$.apply("Branch [" + branch2 + "] not present for source " + source.gitSource().getId());
    }

    @Override
    public StitchScanResult scan(GitSourceBranch source, ExecutionLogger executionLogger) {
        Tuple2 streamWithResource = ResourceManagement$.MODULE$.autoCloseAfterStream(this.cloneGitRepository(source, executionLogger), (Function1 & Serializable)resources -> {
            this.gitOpsService.cleanup(resources);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)resources -> this.crawlGitRepository((Tuple3<Git, GitSourceInfo, File>)resources, executionLogger));
        Tuple2 tuple2 = streamWithResource;
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            LazyList stream = (LazyList)tuple2._2();
            if (tuple3 != null) {
                GitSourceInfo stitchGitSourceInfo = (GitSourceInfo)tuple3._2();
                return new StitchScanResult((LazyList<StitchDefinitionsWithContent>)stream, (Option<StitchSourceInfo>)Option$.MODULE$.apply((Object)stitchGitSourceInfo));
            }
        }
        throw new MatchError(tuple2);
    }

    @Override
    public StitchScanResult scan(GitSource source, ExecutionLogger executionLogger) {
        return this.scan(new GitSourceBranch(source, GitSourceBranch$.MODULE$.apply$default$2()), executionLogger);
    }

    public DefaultGitSourceScannerService(DefaultRepositoryCrawler repositoryCrawler, GitOpsService gitOpsService) {
        this.repositoryCrawler = repositoryCrawler;
        this.gitOpsService = gitOpsService;
        Logging.$init$((Logging)this);
    }
}

