/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.xebialabs.deployit.core.rest.api.InvalidContentException;
import com.xebialabs.deployit.core.rest.api.LineNotFoundException;
import com.xebialabs.deployit.plugin.service.FormatSupportProvider;
import com.xebialabs.deployit.plugin.service.json.JsonSnippetService;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.InputStream;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Path(value="/patch/snippets")
@Component
@Autowired
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\u0004\b\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006I\u0001!\t!\n\u0005\u0006S\u0001!\tA\u000b\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\ty\u0002\u0001C\u0005\u0003C\u0011qb\u00158jaB,GOU3t_V\u00148-\u001a\u0006\u0003\u0011%\t1!\u00199j\u0015\tQ1\"\u0001\u0003sKN$(B\u0001\u0007\u000e\u0003\u0011\u0019wN]3\u000b\u00059y\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005A\t\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0012aA2p[\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u0006)bm\u001c:nCR\u001cV\u000f\u001d9peR\u0004&o\u001c<jI\u0016\u0014\bCA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u001d\u0019XM\u001d<jG\u0016T!!I\u0007\u0002\rAdWoZ5o\u0013\t\u0019cDA\u000bG_Jl\u0017\r^*vaB|'\u000f\u001e)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\t1\u0003\u0006\u0005\u0002(\u00015\tq\u0001C\u0003\u001c\u0005\u0001\u0007A$\u0001\u0006hKR\u001cf.\u001b9qKR$BaK\"\\KB\u0011A\u0006\u0011\b\u0003[ur!AL\u001e\u000f\u0005=RdB\u0001\u0019:\u001d\t\t\u0004H\u0004\u00023o9\u00111GN\u0007\u0002i)\u0011QgE\u0001\u0007yI|w\u000e\u001e \n\u0003II!\u0001E\t\n\u00059y\u0011BA\u0011\u000e\u0013\ty\u0002%\u0003\u0002==\u0005!!n]8o\u0013\tqt(\u0001\nKg>t7K\\5qa\u0016$8+\u001a:wS\u000e,'B\u0001\u001f\u001f\u0013\t\t%IA\u0004T]&\u0004\b/\u001a;\u000b\u0005yz\u0004\"\u0002#\u0004\u0001\u0004)\u0015AD2p]R,g\u000e\u001e+za\u0016,\u0005\u0010\u001e\t\u0003\r*s!a\u0012%\u0011\u0005M:\u0012BA%\u0018\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%;\u0002\u0006B\"O1f\u0003\"a\u0014,\u000e\u0003AS!!\u0015*\u0002\u0005I\u001c(BA*U\u0003\t98OC\u0001V\u0003\u001dQ\u0017m[1si\u0006L!a\u0016)\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017!\u0002<bYV,\u0017%\u0001.\u0002\u0017\r|g\u000e^3oiRK\b/\u001a\u0005\u00069\u000e\u0001\r!X\u0001\u0005Y&tW\r\u0005\u0002\u0017=&\u0011ql\u0006\u0002\u0004\u0013:$\b\u0006B.b1\u0012\u0004\"a\u00142\n\u0005\r\u0004&AC)vKJL\b+\u0019:b[\u0006\nA\fC\u0003g\u0007\u0001\u0007q-A\u0004d_:$XM\u001c;\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017AA5p\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0015\u0005\u0007AD6\u000f\u0005\u0002Pc&\u0011!\u000f\u0015\u0002\t!J|G-^2fg2\nA/I\u0001v\u0003A\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80UN|g\u000e\u000b\u0003\u0004obS\bCA(y\u0013\tI\bK\u0001\u0003QCRD\u0017%A>\u0002\u001bm\u001cwN\u001c;f]R$\u0016\u0010]3~Q\t\u0019Q\u0010\u0005\u0002P}&\u0011q\u0010\u0015\u0002\u0005!>\u001bF+A\u0006hKR\u0004vn]5uS>tGcB/\u0002\u0006\u0005%\u0011\u0011\u0003\u0005\u0006\t\u0012\u0001\r!\u0012\u0015\u0006\u0003\u000bq\u0005,\u0017\u0005\u0007\u0003\u0017!\u0001\u0019A#\u0002\tA\fG\u000f\u001b\u0015\u0007\u0003\u0013\t\u0007,a\u0004\"\u0005\u0005-\u0001\"\u00024\u0005\u0001\u00049\u0007&\u0002\u0003q1\u0006UA&\u0001;)\u000b\u00119\b,!\u0007\"\u0005\u0005m\u0011A\u00057j]\u0016|3pY8oi\u0016tG\u000fV=qKvD#\u0001B?\u0002!!\fg\u000e\u001a7f\u000bb\u001cW\r\u001d;j_:\u001cX\u0003BA\u0012\u0003S!B!!\n\u0002<A!\u0011qEA\u0015\u0019\u0001!q!a\u000b\u0006\u0005\u0004\tiCA\u0001U#\u0011\ty#!\u000e\u0011\u0007Y\t\t$C\u0002\u00024]\u0011qAT8uQ&tw\rE\u0002\u0017\u0003oI1!!\u000f\u0018\u0005\r\te.\u001f\u0005\t\u0003{)A\u00111\u0001\u0002@\u0005)!\r\\8dWB)a#!\u0011\u0002&%\u0019\u00111I\f\u0003\u0011q\u0012\u0017P\\1nKzBS\u0001\u00019Y\u0003\u000fb\u0013\u0001\u001e\u0015\u0004\u0001\u0005-\u0003\u0003BA'\u0003Gj!!a\u0014\u000b\t\u0005E\u00131K\u0001\u000bC:tw\u000e^1uS>t'\u0002BA+\u0003/\nqAZ1di>\u0014\u0018P\u0003\u0003\u0002Z\u0005m\u0013!\u00022fC:\u001c(\u0002BA/\u0003?\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003C\n1a\u001c:h\u0013\u0011\t)'a\u0014\u0003\u0013\u0005+Ho\\<je\u0016$\u0007f\u0001\u0001\u0002jA!\u00111NA9\u001b\t\tiG\u0003\u0003\u0002p\u0005m\u0013AC:uKJ,w\u000e^=qK&!\u00111OA7\u0005%\u0019u.\u001c9p]\u0016tG\u000fK\u0003\u0001ob\u000b9(\t\u0002\u0002z\u0005yq\u0006]1uG\"|3O\\5qa\u0016$8\u000f")
public class SnippetResource {
    private final FormatSupportProvider formatSupportProvider;

    @POST
    @Path(value="{contentType}")
    @Produces(value={"application/json"})
    public JsonSnippetService.Snippet getSnippet(@PathParam(value="contentType") String contentTypeExt, @QueryParam(value="line") int line, InputStream content) {
        return (JsonSnippetService.Snippet)this.handleExceptions((Function0 & Serializable)() -> $this.formatSupportProvider.getExtensionSupport(contentTypeExt).getSnippet(content, line));
    }

    @POST
    @Path(value="line/{contentType}")
    @Produces(value={"application/json"})
    public int getPosition(@PathParam(value="contentType") String contentTypeExt, @QueryParam(value="path") String path, InputStream content) {
        return BoxesRunTime.unboxToInt(this.handleExceptions((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.formatSupportProvider.getExtensionSupport(contentTypeExt).getPathLine(content, path)));
    }

    private <T> T handleExceptions(Function0<T> block) {
        Object object;
        try {
            object = block.apply();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LineNotFoundException();
        }
        catch (JsonParseException j) {
            throw new InvalidContentException(j);
        }
        return (T)object;
    }

    public SnippetResource(FormatSupportProvider formatSupportProvider) {
        this.formatSupportProvider = formatSupportProvider;
    }
}

