/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCDataSourceUtils;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class DatabaseStorageConfiguration
implements StoreConfiguration {
    private String messageTableName = ActiveMQDefaultConfiguration.getDefaultMessageTableName();
    private String bindingsTableName = ActiveMQDefaultConfiguration.getDefaultBindingsTableName();
    private String largeMessagesTableName = ActiveMQDefaultConfiguration.getDefaultLargeMessagesTableName();
    private String pageStoreTableName = ActiveMQDefaultConfiguration.getDefaultPageStoreTableName();
    private String nodeManagerStoreTableName = ActiveMQDefaultConfiguration.getDefaultNodeManagerStoreTableName();
    private String jdbcConnectionUrl = ActiveMQDefaultConfiguration.getDefaultDatabaseUrl();
    private String jdbcUser;
    private String jdbcPassword;
    private String jdbcDriverClassName = ActiveMQDefaultConfiguration.getDefaultDriverClassName();
    private DataSource dataSource;
    private String dataSourceClassName = ActiveMQDefaultConfiguration.getDefaultDataSourceClassName();
    private Map<String, Object> dataSourceProperties = new HashMap<String, Object>();
    private JDBCConnectionProvider connectionProvider;
    private SQLProvider.Factory sqlProviderFactory;
    private int jdbcNetworkTimeout = ActiveMQDefaultConfiguration.getDefaultJdbcNetworkTimeout();
    private long jdbcLockRenewPeriodMillis = ActiveMQDefaultConfiguration.getDefaultJdbcLockRenewPeriodMillis();
    private long jdbcLockExpirationMillis = ActiveMQDefaultConfiguration.getDefaultJdbcLockExpirationMillis();
    private long jdbcLockAcquisitionTimeoutMillis = ActiveMQDefaultConfiguration.getDefaultJdbcLockAcquisitionTimeoutMillis();
    private long jdbcJournalSyncPeriodMillis = ActiveMQDefaultConfiguration.getDefaultJdbcJournalSyncPeriodMillis();
    private long jdbcAllowedTimeDiff = ActiveMQDefaultConfiguration.getDefaultJdbcAllowedTimeDiffMillis();

    @Override
    public StoreConfiguration.StoreType getStoreType() {
        return StoreConfiguration.StoreType.DATABASE;
    }

    public String getMessageTableName() {
        return this.messageTableName;
    }

    public void setMessageTableName(String messageTableName) {
        this.messageTableName = messageTableName;
    }

    public String getBindingsTableName() {
        return this.bindingsTableName;
    }

    public void setBindingsTableName(String bindingsTableName) {
        this.bindingsTableName = bindingsTableName;
    }

    public String getLargeMessageTableName() {
        return this.largeMessagesTableName;
    }

    public void setLargeMessageTableName(String largeMessagesTableName) {
        this.largeMessagesTableName = largeMessagesTableName;
    }

    public String getPageStoreTableName() {
        return this.pageStoreTableName;
    }

    public void setNodeManagerStoreTableName(String nodeManagerStoreTableName) {
        this.nodeManagerStoreTableName = nodeManagerStoreTableName;
    }

    public String getNodeManagerStoreTableName() {
        return this.nodeManagerStoreTableName;
    }

    public void setPageStoreTableName(String pageStoreTableName) {
        this.pageStoreTableName = pageStoreTableName;
    }

    public void setJdbcConnectionUrl(String jdbcConnectionUrl) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
    }

    public String getJdbcConnectionUrl() {
        return this.jdbcConnectionUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setJdbcDriverClassName(String jdbcDriverClassName) {
        this.jdbcDriverClassName = jdbcDriverClassName;
    }

    public String getJdbcDriverClassName() {
        return this.jdbcDriverClassName;
    }

    public long getJdbcAllowedTimeDiff() {
        return this.jdbcAllowedTimeDiff;
    }

    private DataSource getDataSource() {
        if (this.dataSource == null) {
            if (ActiveMQDefaultConfiguration.getDefaultDataSourceClassName().equals(this.dataSourceClassName)) {
                if (!this.dataSourceProperties.containsKey("driverClassName")) {
                    this.addDataSourceProperty("driverClassName", this.jdbcDriverClassName);
                }
                if (!this.dataSourceProperties.containsKey("url")) {
                    this.addDataSourceProperty("url", this.jdbcConnectionUrl);
                }
                if (!this.dataSourceProperties.containsKey("username") && this.jdbcUser != null) {
                    this.addDataSourceProperty("username", this.jdbcUser);
                }
                if (!this.dataSourceProperties.containsKey("password") && this.jdbcPassword != null) {
                    this.addDataSourceProperty("password", this.jdbcPassword);
                }
                if (!this.dataSourceProperties.containsKey("maxTotal")) {
                    this.addDataSourceProperty("maxTotal", "-1");
                }
                if (!this.dataSourceProperties.containsKey("poolPreparedStatements")) {
                    this.addDataSourceProperty("poolPreparedStatements", "true");
                }
            }
            this.dataSource = JDBCDataSourceUtils.getDataSource((String)this.dataSourceClassName, this.dataSourceProperties);
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JDBCConnectionProvider getConnectionProvider() {
        if (this.connectionProvider == null) {
            this.connectionProvider = this.dataSourceClassName == ActiveMQDefaultConfiguration.getDefaultDataSourceClassName() ? new JDBCConnectionProvider(this.getDataSource()) : new JDBCConnectionProvider(this.getDataSource(), this.getJdbcUser(), this.getJdbcPassword());
        }
        return this.connectionProvider;
    }

    public DatabaseStorageConfiguration setConnectionProviderNetworkTimeout(Executor executor, int ms) {
        this.getConnectionProvider().setNetworkTimeout(executor, ms);
        return this;
    }

    public DatabaseStorageConfiguration clearConnectionProviderNetworkTimeout() {
        if (this.connectionProvider != null) {
            this.connectionProvider.setNetworkTimeout(null, -1);
        }
        return this;
    }

    public void addDataSourceProperty(String key, String value) {
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            this.dataSourceProperties.put(key, Boolean.parseBoolean(value.toLowerCase()));
        } else {
            try {
                int i = Integer.parseInt(value);
                this.dataSourceProperties.put(key, i);
            }
            catch (NumberFormatException nfe) {
                this.dataSourceProperties.put(key, value);
            }
        }
    }

    public String getDataSourceProperty(String key) {
        return (String)this.dataSourceProperties.get(key);
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    public SQLProvider.Factory getSqlProviderFactory() {
        return this.sqlProviderFactory;
    }

    public void setSqlProvider(SQLProvider.Factory sqlProviderFactory) {
        this.sqlProviderFactory = sqlProviderFactory;
    }

    public int getJdbcNetworkTimeout() {
        return this.jdbcNetworkTimeout;
    }

    public void setJdbcNetworkTimeout(int jdbcNetworkTimeout) {
        this.jdbcNetworkTimeout = jdbcNetworkTimeout;
    }

    public long getJdbcLockRenewPeriodMillis() {
        return this.jdbcLockRenewPeriodMillis;
    }

    public void setJdbcLockRenewPeriodMillis(long jdbcLockRenewPeriodMillis) {
        this.jdbcLockRenewPeriodMillis = jdbcLockRenewPeriodMillis;
    }

    public long getJdbcLockExpirationMillis() {
        return this.jdbcLockExpirationMillis;
    }

    public void setJdbcLockExpirationMillis(long jdbcLockExpirationMillis) {
        this.jdbcLockExpirationMillis = jdbcLockExpirationMillis;
    }

    public long getJdbcLockAcquisitionTimeoutMillis() {
        return this.jdbcLockAcquisitionTimeoutMillis;
    }

    public void setJdbcLockAcquisitionTimeoutMillis(long jdbcLockAcquisitionTimeoutMillis) {
        this.jdbcLockAcquisitionTimeoutMillis = jdbcLockAcquisitionTimeoutMillis;
    }

    public long getJdbcJournalSyncPeriodMillis() {
        return this.jdbcJournalSyncPeriodMillis;
    }

    public void setJdbcJournalSyncPeriodMillis(long jdbcJournalSyncPeriodMillis) {
        this.jdbcJournalSyncPeriodMillis = jdbcJournalSyncPeriodMillis;
    }

    public void setJdbcAllowedTimeDiff(long jdbcAllowedTimeDiff) {
        this.jdbcAllowedTimeDiff = jdbcAllowedTimeDiff;
    }
}

