/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.ServiceAccountPrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.client.KubernetesClient;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.client.KubernetesClientImpl;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.model.TokenReview;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesLoginModule
extends PropertiesLoader
implements AuditLoginModule {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesLoginModule.class);
    public static final String K8S_ROLE_FILE_PROP_NAME = "org.apache.activemq.jaas.kubernetes.role";
    private CallbackHandler handler;
    private Subject subject;
    private TokenReview tokenReview = new TokenReview();
    private boolean ignoreTokenReviewRoles = false;
    private Map<String, Set<String>> roles;
    private final Set<Principal> principals = new HashSet<Principal>();
    private final KubernetesClient client;

    public KubernetesLoginModule(KubernetesClient client) {
        this.client = client;
    }

    public KubernetesLoginModule() {
        this(new KubernetesClientImpl());
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.handler = callbackHandler;
        this.subject = subject;
        this.debug = KubernetesLoginModule.booleanOption("debug", options);
        if (this.debug) {
            logger.debug("Initialized debug");
        }
        if (options.containsKey(K8S_ROLE_FILE_PROP_NAME)) {
            this.roles = this.load(K8S_ROLE_FILE_PROP_NAME, null, options).invertedPropertiesValuesMap();
            if (this.debug) {
                logger.debug("loaded roles: {}", this.roles);
            }
        } else {
            this.roles = Map.of();
        }
        this.ignoreTokenReviewRoles = KubernetesLoginModule.booleanOption("ignoreTokenReviewRoles", options);
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        char[] token = ((PasswordCallback)callbacks[0]).getPassword();
        if (token.length == 0) {
            throw new FailedLoginException("Bearer token is empty");
        }
        this.tokenReview = this.client.getTokenReview(new String(token));
        if (this.debug) {
            logger.debug("login {}", (Object)this.tokenReview);
        }
        return this.tokenReview.isAuthenticated();
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = false;
        result = this.tokenReview.isAuthenticated();
        Set<UserPrincipal> authenticatedUsers = this.subject.getPrincipals(UserPrincipal.class);
        if (result) {
            Set<String> matchedRoles;
            ServiceAccountPrincipal userPrincipal = new ServiceAccountPrincipal(this.tokenReview.getUsername());
            this.principals.add(userPrincipal);
            authenticatedUsers.add(userPrincipal);
            if (!this.ignoreTokenReviewRoles) {
                for (String role : this.tokenReview.getUser().getGroups()) {
                    this.principals.add(new RolePrincipal(role));
                }
            }
            if ((matchedRoles = this.roles.get(userPrincipal.getName())) != null) {
                for (String entry : matchedRoles) {
                    this.principals.add(new RolePrincipal(entry));
                }
            }
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            logger.debug("commit, result: {}, principals: {}", (Object)result, this.principals);
        }
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        this.registerFailureForAudit(this.tokenReview.getUsername());
        this.clear();
        if (this.debug) {
            logger.debug("abort");
        }
        return true;
    }

    @Override
    public void registerFailureForAudit(String name) {
        Subject subject = new Subject();
        subject.getPrincipals().add(new ServiceAccountPrincipal(name));
        AuditLogger.setCurrentCaller((Subject)subject);
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        if (this.debug) {
            logger.debug("logout");
        }
        return true;
    }

    private void clear() {
        this.tokenReview = new TokenReview();
    }
}

