/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import ai.digital.configuration.central.deploy.db.DatabaseProperties;
import ai.digital.configuration.central.deploy.db.MainDatabase;
import ai.digital.configuration.central.deploy.db.ReportingProperties;
import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.artifact.resolution.InternalArtifactResolver$;
import com.xebialabs.deployit.core.config.JpaUtils$;
import com.xebialabs.deployit.core.config.SqlConfiguration$;
import com.xebialabs.deployit.core.metrics.XldDbMetricsTrackerFactory;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.xebialabs.deployit.core.sql.config.DatabaseDriverConfiguration$;
import com.xebialabs.deployit.core.sql.spring.DeployJdbcTemplate;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepositoryFactory$;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.Function0;
import scala.None$;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Configuration
@EnableTransactionManagement
@EnableConfigurationProperties
@Import(value={MainDatabase.class, ReportingProperties.class, XldDbMetricsTrackerFactory.class})
@ScalaSignature(bytes="\u0006\u0005\rMc\u0001B\u0016-\u0001]BQA\u0012\u0001\u0005\u0002\u001dC\u0011B\u0013\u0001A\u0002\u0003\u0007I\u0011A&\t\u0013q\u0003\u0001\u0019!a\u0001\n\u0003i\u0006\"C2\u0001\u0001\u0004\u0005\t\u0015)\u0003M\u0011%)\b\u00011AA\u0002\u0013\u0005a\u000fC\u0005{\u0001\u0001\u0007\t\u0019!C\u0001w\"IQ\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001e\u0005\u000b\u007f\u0002\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0001bCA\b\u0001\u0001\u0007\t\u0019!C\u0001\u0003#A1\"!\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0004!Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011AA\u000e\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\t\u0017\u0005-\u0002\u00011A\u0001B\u0003&\u0011Q\u0004\u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019\u0004C\u0006\u0002L\u0001\u0001\r\u00111A\u0005\u0002\u00055\u0003bCA)\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kA1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00024!Y\u00111\r\u0001A\u0002\u0003\u0007I\u0011AA3\u0011-\tI\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u000e\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u00111\u0015\u0001\u0005\u0002\u0005M\u0004bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003\u0003\u0004A\u0011AAb\u0011\u001d\t\t\u000e\u0001C\u0001\u0003\u0007Dq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002j\u0002!\t!a;\t\u000f\t\u0005\u0001\u0001\"\u0001\u0003\u0004!9!1\u0005\u0001\u0005\u0002\t\u0015\u0002b\u0002B\u001c\u0001\u0011\u0005!\u0011\b\u0005\b\u0005\u0017\u0002A\u0011\u0001B\u001d\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#BqA!\u0019\u0001\t\u0003\u0011\u0019\u0007C\u0004\u0003x\u0001!\tA!\u001f\t\u000f\t}\u0005\u0001\"\u0001\u0003\"\"9!1\u0017\u0001\u0005\u0002\t\u0005\u0006b\u0002B\\\u0001\u0011%!\u0011X\u0004\b\u0007\u0007a\u0003\u0012AB\u0003\r\u0019YC\u0006#\u0001\u0004\b!1aI\nC\u0001\u0007\u0013Aqaa\u0003'\t\u0003\u0019i\u0001C\u0004\u0004.\u0019\"Iaa\f\t\u000f\r}b\u0005\"\u0001\u0004B\t\u00012+\u001d7D_:4\u0017nZ;sCRLwN\u001c\u0006\u0003[9\naaY8oM&<'BA\u00181\u0003\u0011\u0019wN]3\u000b\u0005E\u0012\u0014\u0001\u00033fa2|\u00170\u001b;\u000b\u0005M\"\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005)\u0014aA2p[\u000e\u00011c\u0001\u00019}A\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\u0004\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u000bMdg\r\u000e6\u000b\u0003\r\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003\u000b\u0002\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0011B\u0011\u0011\nA\u0007\u0002Y\u0005aQ.Y5o\t\u0006$\u0018MY1tKV\tA\n\u0005\u0002N56\taJ\u0003\u0002P!\u0006\u0011AM\u0019\u0006\u0003#J\u000ba\u0001Z3qY>L(BA*U\u0003\u001d\u0019WM\u001c;sC2T!!\u0016,\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0015\t9\u0006,A\u0004eS\u001eLG/\u00197\u000b\u0003e\u000b!!Y5\n\u0005ms%\u0001D'bS:$\u0015\r^1cCN,\u0017\u0001E7bS:$\u0015\r^1cCN,w\fJ3r)\tq\u0016\r\u0005\u0002:?&\u0011\u0001M\u000f\u0002\u0005+:LG\u000fC\u0004c\u0007\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0013'A\u0007nC&tG)\u0019;bE\u0006\u001cX\r\t\u0015\u0005\t\u0015\u001cH\u000f\u0005\u0002gc6\tqM\u0003\u0002iS\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005)\\\u0017a\u00024bGR|'/\u001f\u0006\u0003Y6\fQAY3b]NT!A\\8\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001]\u0001\u0004_J<\u0017B\u0001:h\u0005%\tU\u000f^8xSJ,G-\u0001\u0005sKF,\u0018N]3e3\u0005\t\u0011a\u0005:fa>\u0014H/\u001b8h!J|\u0007/\u001a:uS\u0016\u001cX#A<\u0011\u00055C\u0018BA=O\u0005M\u0011V\r]8si&tw\r\u0015:pa\u0016\u0014H/[3t\u0003]\u0011X\r]8si&tw\r\u0015:pa\u0016\u0014H/[3t?\u0012*\u0017\u000f\u0006\u0002_y\"9!MBA\u0001\u0002\u00049\u0018\u0001\u0006:fa>\u0014H/\u001b8h!J|\u0007/\u001a:uS\u0016\u001c\b\u0005\u000b\u0003\bKN$\u0018A\u0007=mI\u0012\u0013W*\u001a;sS\u000e\u001cHK]1dW\u0016\u0014h)Y2u_JLXCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005]\u00059Q.\u001a;sS\u000e\u001c\u0018\u0002BA\u0007\u0003\u000f\u0011!\u0004\u00177e\t\nlU\r\u001e:jGN$&/Y2lKJ4\u0015m\u0019;pef\fa\u0004\u001f7e\t\nlU\r\u001e:jGN$&/Y2lKJ4\u0015m\u0019;pef|F%Z9\u0015\u0007y\u000b\u0019\u0002\u0003\u0005c\u0013\u0005\u0005\t\u0019AA\u0002\u0003mAH\u000e\u001a#c\u001b\u0016$(/[2t)J\f7m[3s\r\u0006\u001cGo\u001c:zA!\u0012!\"Z\u0001\u0014g\u0016\u0014h/\u001a:MCVt7\r[(qi&|gn]\u000b\u0003\u0003;\u0001B!a\b\u0002\"5\t\u0001'C\u0002\u0002$A\u00121cU3sm\u0016\u0014H*Y;oG\"|\u0005\u000f^5p]N\fqc]3sm\u0016\u0014H*Y;oG\"|\u0005\u000f^5p]N|F%Z9\u0015\u0007y\u000bI\u0003\u0003\u0005c\u0019\u0005\u0005\t\u0019AA\u000f\u0003Q\u0019XM\u001d<fe2\u000bWO\\2i\u001fB$\u0018n\u001c8tA!*Q\"Z:\u00020e\t\u0001!A\fdQ\u0006tw-\u001a'pO6\u000b7\u000f^3s\r&dWM\\1nKV\u0011\u0011Q\u0007\t\u0005\u0003o\t)E\u0004\u0003\u0002:\u0005\u0005\u0003cAA\u001eu5\u0011\u0011Q\b\u0006\u0004\u0003\u007f1\u0014A\u0002\u001fs_>$h(C\u0002\u0002Di\na\u0001\u0015:fI\u00164\u0017\u0002BA$\u0003\u0013\u0012aa\u0015;sS:<'bAA\"u\u0005Y2\r[1oO\u0016dunZ'bgR,'OR5mK:\fW.Z0%KF$2AXA(\u0011!\u0011w\"!AA\u0002\u0005U\u0012\u0001G2iC:<W\rT8h\u001b\u0006\u001cH/\u001a:GS2,g.Y7fA!:\u0001#!\u0016\u0002\\\u0005u\u0003c\u00014\u0002X%\u0019\u0011\u0011L4\u0003\u000bY\u000bG.^3\u0002\u000bY\fG.^3\"\u0005\u0005}\u0013!\u0016\u0013|I\u0016\u0004Hn\\=/S:$XM\u001d8bY:\"'ML2iC:<W\r\\8h]5\f7\u000f^3s]\u0019LG.\u001a8b[\u0016TDMY\u0018dQ\u0006tw-\u001a7pO>\"'ML2iC:<W\r\\8h[5\f7\u000f^3s]e\fW\u000e\\?\u00025\rD\u0017M\\4f\u0019><'+\u001a9peRLgn\u001a$jY\u0016t\u0017-\\3\u0002=\rD\u0017M\\4f\u0019><'+\u001a9peRLgn\u001a$jY\u0016t\u0017-\\3`I\u0015\fHc\u00010\u0002h!A!MEA\u0001\u0002\u0004\t)$A\u000edQ\u0006tw-\u001a'pOJ+\u0007o\u001c:uS:<g)\u001b7f]\u0006lW\r\t\u0015\b'\u0005U\u00131LA7C\t\ty'A.%w\u0012,\u0007\u000f\\8z]%tG/\u001a:oC2tCM\u0019\u0018dQ\u0006tw-\u001a7pO:\u0012X\r]8si&twM\f4jY\u0016t\u0017-\\3;I\n|3\r[1oO\u0016dwnZ\u0018eE:\u001a\u0007.\u00198hK2|w-\f:fa>\u0014H/\u001b8h]e\fW\u000e\\?\u0002\u001d5\f\u0017N\u001c#bi\u0006\u001cv.\u001e:dKV\u0011\u0011Q\u000f\t\u0005\u0003o\n\t)\u0004\u0002\u0002z)!\u00111PA?\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0003\u007f\nQA[1wCbLA!a!\u0002z\tQA)\u0019;b'>,(oY3)\u000fQ\t9)!&\u0002\u0018B!\u0011\u0011RAI\u001b\t\tYIC\u0002i\u0003\u001bS1!a$n\u0003\u001d\u0019wN\u001c;fqRLA!a%\u0002\f\n!!)Z1o\u00035!Wm\u001d;s_flU\r\u001e5pI\u0006\u0012\u0011\u0011T\u0001\u0006G2|7/\u001a\u0015\u0004)\u0005u\u0005\u0003BAE\u0003?KA!!)\u0002\f\n9\u0001K]5nCJL\u0018a\u0005:fa>\u0014H/\u001b8h\t\u0006$\u0018mU8ve\u000e,\u0007fB\u000b\u0002\b\u0006U\u0015qS\u0001\u0017S:\u001cHO];nK:$X\r\u001a#bi\u0006\u001cv.\u001e:dKR!\u00111VA_!\u0011\ti+!/\u000e\u0005\u0005=&\u0002BAY\u0003g\u000bAA\u001b3cG*!\u0011\u0011BA[\u0015\r\t9\fN\u0001\u0006iF$WM^\u0005\u0005\u0003w\u000byK\u0001\fJ]N$(/^7f]R,G\rR1uCN{WO]2f\u0011\u001d\tyL\u0006a\u0001\u0003k\n!\u0002Z1uCN{WO]2f\u0003)i\u0017-\u001b8TG\",W.Y\u000b\u0003\u0003\u000b\u0004B!a2\u0002L6\u0011\u0011\u0011\u001a\u0006\u0004\u0003wr\u0013\u0002BAg\u0003\u0013\u0014!bU2iK6\f\u0017J\u001c4pQ\r9\u0012qQ\u0001\u0010e\u0016\u0004xN\u001d;j]\u001e\u001c6\r[3nC\"\u001a\u0001$a\"\u0002!5\f\u0017N\u001c&eE\u000e$V-\u001c9mCR,WCAAm!\u0011\tY.!9\u000e\u0005\u0005u'bA\u0018\u0002`*\u0019\u0011\u0011W7\n\t\u0005\r\u0018Q\u001c\u0002\r\u0015\u0012\u00147\rV3na2\fG/\u001a\u0015\u00043\u0005u\u0005fA\r\u0002\b\u0006!RM\u001c;jifl\u0015M\\1hKJ4\u0015m\u0019;pef$\"!!<\u0011\t\u0005=\u0018\u0011`\u0007\u0003\u0003cTA!a=\u0002v\u0006\u0019!\u000e]1\u000b\u0007\u0005]X.A\u0002pe6LA!a?\u0002r\n\u0001\u0013IY:ue\u0006\u001cG/\u00128uSRLX*\u00198bO\u0016\u0014h)Y2u_JL()Z1oQ\rQ\u0012Q\u0014\u0015\u00045\u0005\u001d\u0015\u0001E4fi*\u0003\u0018\r\u0015:pa\u0016\u0014H/[3t)\u0019\u0011)A!\u0006\u0003\u001aA9!q\u0001B\t\u0003kATB\u0001B\u0005\u0015\u0011\u0011YA!\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005\u001f\tAA[1wC&!!1\u0003B\u0005\u0005\ri\u0015\r\u001d\u0005\b\u0005/Y\u0002\u0019AA\u001b\u0003=!'/\u001b<fe\u000ec\u0017m]:OC6,\u0007b\u0002B\u000e7\u0001\u0007!QD\u0001\u0003K6\u0004B!a<\u0003 %!!\u0011EAy\u0005\u0019bunY1m\u0007>tG/Y5oKJ,e\u000e^5us6\u000bg.Y4fe\u001a\u000b7\r^8ss\n+\u0017M\\\u0001\u0015Kb\u001cW\r\u001d;j_:$&/\u00198tY\u0006$\u0018n\u001c8\u0016\u0005\t\u001d\u0002\u0003\u0002B\u0015\u0005ci!Aa\u000b\u000b\u0007!\u0014iCC\u0002\u000305\f1\u0001Z1p\u0013\u0011\u0011\u0019Da\u000b\u0003YA+'o]5ti\u0016t7-Z#yG\u0016\u0004H/[8o)J\fgn\u001d7bi&|g\u000eU8tiB\u0013xnY3tg>\u0014\bf\u0001\u000f\u0002\b\u00061R.Y5o)J\fgn]1di&|g.T1oC\u001e,'/\u0006\u0002\u0003<A!!Q\bB\"\u001b\t\u0011yDC\u0002\u0003B5\f1\u0002\u001e:b]N\f7\r^5p]&!!Q\tB \u0005i\u0001F.\u0019;g_JlGK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\ri\u0012q\u0011\u0015\u0004;\u0005u\u0015a\u0007:fa>\u0014H/\u001b8h)J\fgn]1di&|g.T1oC\u001e,'\u000fK\u0002\u001f\u0003\u000f\u000ba#\u0019:uS\u001a\f7\r\u001e*fa>\u001c\u0018\u000e^8ssJ{w\u000e^\u000b\u0003\u0005'\u0002BA!\u0016\u0003\\5\u0011!q\u000b\u0006\u0005\u00053\u0012i!\u0001\u0002j_&!!Q\fB,\u0005\u00111\u0015\u000e\\3)\u0007}\t9)\u0001\tbeRLg-Y2u%\u0016\u001cx\u000e\u001c<feV\u0011!Q\r\b\u0005\u0005O\u0012\t(\u0004\u0002\u0003j)!!1\u000eB7\u0003)\u0011Xm]8mkRLwN\u001c\u0006\u0004\u0005_\u0002\u0014\u0001C1si&4\u0017m\u0019;\n\t\tM$\u0011N\u0001\u0019\u0013:$XM\u001d8bY\u0006\u0013H/\u001b4bGR\u0014Vm]8mm\u0016\u0014\bf\u0001\u0011\u0002\b\u0006\u0011\u0012M\u001d;jM\u0006\u001cGOU3q_NLGo\u001c:z)\u0011\u0011YH!$\u0011\t\tu$\u0011R\u0007\u0003\u0005\u007fRAA!!\u0003\u0004\u0006I\u0011M\u001d;jM\u0006\u001cGo\u001d\u0006\u0005\u0003w\u0012)IC\u0002\u0003\bB\n!B]3q_NLGo\u001c:z\u0013\u0011\u0011YIa \u0003-\u0005\u0013H/\u001b4bGR$\u0015\r^1SKB|7/\u001b;pefDqAa$\"\u0001\u0004\u0011\t*\u0001\nbaBd\u0017nY1uS>t7i\u001c8uKb$\b\u0003\u0002BJ\u0005+k!!!$\n\t\t]\u0015Q\u0012\u0002\u0013\u0003B\u0004H.[2bi&|gnQ8oi\u0016DH\u000f\u000b\u0002\"K\"\u001a\u0011%!()\u0007\u0005\n9)\u0001\fj]&$\u0018.\u00197ju\u0016l\u0015-\u001b8ECR\f'-Y:f)\u0005q\u0006f\u0001\u0012\u0003&B!!q\u0015BX\u001b\t\u0011IKC\u0002i\u0005WS!A!,\u0002\u000f)\f7.\u0019:uC&!!\u0011\u0017BU\u00055\u0001vn\u001d;D_:\u001cHO];di\u0006Y\u0012N\\5uS\u0006d\u0017N_3SKB|'\u000f^5oO\u0012\u000bG/\u00192bg\u0016D3a\tBS\u0003=)\b\u000fZ1uK2K\u0017/^5cCN,Gc\u00020\u0003<\n}&\u0011\u0019\u0005\b\u0005{#\u0003\u0019AA\u001b\u0003\u0019\u00198\r[3nC\"9\u0011q\u0018\u0013A\u0002\u0005U\u0004b\u0002BbI\u0001\u0007!QY\u0001\bI&\fG.Z2u!\u0011\t9Ma2\n\t\t%\u0017\u0011\u001a\u0002\u000b'FdG)[1mK\u000e$\bf\u0002\u0001\u0003N\u0006m#1\u001b\t\u0005\u0003\u0013\u0013y-\u0003\u0003\u0003R\u0006-%AB%na>\u0014H\u000f\f\u0004\u0003V\n]'\u0011\\\u0012\u0002\u0019\u000e\nqo\t\u0002\u0002\u0004!\u001a\u0001A!8\u0011\t\t}'1^\u0007\u0003\u0005CTAAa9\u0003f\u0006Q\u0001O]8qKJ$\u0018.Z:\u000b\t\u0005=%q\u001d\u0006\u0004\u0005Sl\u0017\u0001\u00022p_RLAA!<\u0003b\niRI\\1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0013x\u000e]3si&,7\u000fK\u0002\u0001\u0005c\u0004BAa=\u0003x6\u0011!Q\u001f\u0006\u0004Q\n}\u0012\u0002\u0002B}\u0005k\u00141$\u00128bE2,GK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3nK:$\bf\u0001\u0001\u0003~B!\u0011\u0011\u0012B\u0000\u0013\u0011\u0019\t!a#\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003A\u0019\u0016\u000f\\\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002JMM\u0011a\u0005\u000f\u000b\u0003\u0007\u000b\t\u0001\u0003[5lCJLG)\u0019;b'>,(oY3\u0015\u0011\r=1qDB\u0014\u0007W\u0001Ba!\u0005\u0004\u001c5\u001111\u0003\u0006\u0005\u0007+\u00199\"\u0001\u0004iS.\f'/\u001b\u0006\u0004\u00073!\u0014A\u0002>bqb,'/\u0003\u0003\u0004\u001e\rM!\u0001\u0005%jW\u0006\u0014\u0018\u000eR1uCN{WO]2f\u0011\u0019i\u0003\u00061\u0001\u0004\"A\u0019Qja\t\n\u0007\r\u0015bJ\u0001\nECR\f'-Y:f!J|\u0007/\u001a:uS\u0016\u001c\bbBB\u0015Q\u0001\u0007\u0011QG\u0001\u0005]\u0006lW\r\u0003\u0004\u0000Q\u0001\u0007\u00111A\u0001\rQ&\\\u0017M]5D_:4\u0017n\u001a\u000b\t\u0007c\u00199d!\u000f\u0004>A!1\u0011CB\u001a\u0013\u0011\u0019)da\u0005\u0003\u0019!K7.\u0019:j\u0007>tg-[4\t\r5J\u0003\u0019AB\u0011\u0011\u001d\u0019Y$\u000ba\u0001\u0003k\t\u0001\u0002]8pY:\u000bW.\u001a\u0005\u0007\u007f&\u0002\r!a\u0001\u0002!1L\u0017/^5cCN,7i\u001c8uKb$HCBA\u001b\u0007\u0007\u001a)\u0005C\u0004\u0003D*\u0002\rA!2\t\u000f\r\u001d#\u00061\u0001\u0004J\u0005\u00191m\u001c8\u0011\t\r-3qJ\u0007\u0003\u0007\u001bRA!a\u001f\u0003\u000e%!1\u0011KB'\u0005)\u0019uN\u001c8fGRLwN\u001c")
public class SqlConfiguration
implements Logging {
    @Autowired(required=true)
    private MainDatabase mainDatabase;
    @Autowired(required=true)
    private ReportingProperties reportingProperties;
    @Autowired
    private XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory;
    @Autowired(required=false)
    private ServerLaunchOptions serverLaunchOptions;
    @Value(value="${deploy.internal.db.changelog.master.filename:db/changelog/db.changelog-master.yaml}")
    private String changeLogMasterFilename;
    @Value(value="${deploy.internal.db.changelog.reporting.filename:db/changelog/db.changelog-reporting.yaml}")
    private String changeLogReportingFilename;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String liquibaseContext(SqlDialect dialect, Connection con) {
        return SqlConfiguration$.MODULE$.liquibaseContext(dialect, con);
    }

    public static HikariDataSource hikariDataSource(DatabaseProperties config, String name, XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory) {
        return SqlConfiguration$.MODULE$.hikariDataSource(config, name, xldDbMetricsTrackerFactory);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfiguration sqlConfiguration = this;
        synchronized (sqlConfiguration) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public MainDatabase mainDatabase() {
        return this.mainDatabase;
    }

    public void mainDatabase_$eq(MainDatabase x$1) {
        this.mainDatabase = x$1;
    }

    public ReportingProperties reportingProperties() {
        return this.reportingProperties;
    }

    public void reportingProperties_$eq(ReportingProperties x$1) {
        this.reportingProperties = x$1;
    }

    public XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory() {
        return this.xldDbMetricsTrackerFactory;
    }

    public void xldDbMetricsTrackerFactory_$eq(XldDbMetricsTrackerFactory x$1) {
        this.xldDbMetricsTrackerFactory = x$1;
    }

    public ServerLaunchOptions serverLaunchOptions() {
        return this.serverLaunchOptions;
    }

    public void serverLaunchOptions_$eq(ServerLaunchOptions x$1) {
        this.serverLaunchOptions = x$1;
    }

    public String changeLogMasterFilename() {
        return this.changeLogMasterFilename;
    }

    public void changeLogMasterFilename_$eq(String x$1) {
        this.changeLogMasterFilename = x$1;
    }

    public String changeLogReportingFilename() {
        return this.changeLogReportingFilename;
    }

    public void changeLogReportingFilename_$eq(String x$1) {
        this.changeLogReportingFilename = x$1;
    }

    @Primary
    @Bean(destroyMethod="close")
    public DataSource mainDataSource() {
        DatabaseDriverConfiguration$.MODULE$.mainDatabaseDriverClassName_$eq(this.mainDatabase().database().dbDriverClassname());
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.mainDatabase().database(), "MainPool", this.xldDbMetricsTrackerFactory()));
    }

    @Bean(destroyMethod="close")
    public DataSource reportingDataSource() {
        DatabaseProperties database = this.reportingProperties().database().hasConfigured() ? this.reportingProperties().database() : this.mainDatabase().database();
        DatabaseDriverConfiguration$.MODULE$.reportingDatabaseDriverClassName_$eq(database.dbDriverClassname());
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(database, "ReportingPool", this.xldDbMetricsTrackerFactory()));
    }

    private InstrumentedDataSource instrumentedDataSource(DataSource dataSource) {
        return new InstrumentedDataSource(dataSource, MetricRegistry.getInstance());
    }

    @Bean
    public SchemaInfo mainSchema() {
        SqlDialect dialect = SqlDialect$.MODULE$.initializeDialect(this.mainDataSource());
        this.logger().info((Function0 & Serializable)() -> "Detected SQL dialect for main: " + dialect + ".");
        return new SchemaInfo(dialect, Option$.MODULE$.apply((Object)this.mainDatabase().database().dbSchemaName()).orElse((Function0 & Serializable)() -> None$.MODULE$));
    }

    @Bean
    public SchemaInfo reportingSchema() {
        SqlDialect dialect = SqlDialect$.MODULE$.initializeDialect(this.reportingDataSource());
        this.logger().info((Function0 & Serializable)() -> "Detected SQL dialect for reporting: " + dialect + ".");
        return new SchemaInfo(dialect, Option$.MODULE$.apply((Object)this.reportingProperties().database().dbSchemaName()).orElse((Function0 & Serializable)() -> None$.MODULE$));
    }

    @Bean
    @Primary
    public JdbcTemplate mainJdbcTemplate() {
        return new DeployJdbcTemplate(this.mainDataSource(), true);
    }

    @Bean
    @Primary
    public AbstractEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.mainDataSource());
        em.setJpaPropertyMap(this.getJpaProperties(this.mainDatabase().database().dbDriverClassname(), em));
        em.setPackagesToScan(new String[]{"com.xebialabs.deployit"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        return em;
    }

    public Map<String, Object> getJpaProperties(String driverClassName, LocalContainerEntityManagerFactoryBean em) {
        Map properties = em.getJpaPropertyMap();
        Object object = driverClassName.contains(JpaUtils$.MODULE$.DERBY_JDBC_DRIVER_CLASS_PATTERN()) ? BoxedUnit.UNIT : (driverClassName.contains(JpaUtils$.MODULE$.DB2_JDBC_DRIVER_CLASS_PATTER()) ? properties.put(JpaUtils$.MODULE$.HIBERNATE_DIALECT_KEY(), JpaUtils$.MODULE$.DB2_DIALECT_CLASS()) : BoxedUnit.UNIT);
        return properties;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor exceptionTranslation() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Primary
    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        return new JpaTransactionManager(this.entityManagerFactory().getObject());
    }

    @Bean
    public PlatformTransactionManager reportingTransactionManager() {
        return new DataSourceTransactionManager(this.reportingDataSource());
    }

    @Bean
    public File artifactRepositoryRoot() {
        return new File(this.mainDatabase().artifacts().root());
    }

    @Bean
    public InternalArtifactResolver$ artifactResolver() {
        return InternalArtifactResolver$.MODULE$.getInstance();
    }

    @Bean
    @Primary
    @Autowired
    public ArtifactDataRepository artifactRepository(ApplicationContext applicationContext) {
        String configuredArtifactDataRepoName = this.mainDatabase().artifacts().type() + ArtifactDataRepository.class.getSimpleName();
        Map repos = applicationContext.getBeansOfType(ArtifactDataRepository.class);
        return ArtifactDataRepositoryFactory$.MODULE$.createArtifactDataRepository(configuredArtifactDataRepoName, repos, this.mainDatabase().artifacts().allowMove());
    }

    @PostConstruct
    public void initializeMainDatabase() {
        this.updateLiquibase(this.changeLogMasterFilename(), this.mainDataSource(), this.mainSchema().sqlDialect());
    }

    @PostConstruct
    public void initializeReportingDatabase() {
        this.updateLiquibase(this.changeLogReportingFilename(), this.reportingDataSource(), this.reportingSchema().sqlDialect());
    }

    private void updateLiquibase(String schema, DataSource dataSource, SqlDialect dialect) {
        try (Connection connection = dataSource.getConnection();){
            String context = SqlConfiguration$.MODULE$.liquibaseContext(dialect, connection);
            this.logger().info((Function0 & Serializable)() -> "Detected liquibase context: " + context);
            Liquibase liquibase = new Liquibase(schema, (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)new JdbcConnection(connection));
            if (this.serverLaunchOptions() != null && this.serverLaunchOptions().isReleaseDbLocks()) {
                this.logger().info((Function0 & Serializable)() -> "Releasing liquibase  database locks");
                liquibase.forceReleaseLocks();
            }
            liquibase.update(context, schema);
        }
    }

    public SqlConfiguration() {
        Logging.$init$((Logging)this);
    }
}

