/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.api.rest.v2.impl;

import ai.digital.deploy.permissions.api.rest.dto.EditRolePermissionsRequest;
import ai.digital.deploy.permissions.api.rest.dto.GetReferencedPermissionsForPrincipalDto;
import ai.digital.deploy.permissions.api.rest.dto.GetReferencedPermissionsForRoleIdDto;
import ai.digital.deploy.permissions.api.rest.dto.GetReferencedPermissionsForRoleIdsDto;
import ai.digital.deploy.permissions.api.rest.dto.GetReferencedPermissionsForRoleNameDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithReferencedPermissionsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleWithReferencedPermissionsConverter$;
import ai.digital.deploy.permissions.exception.RoleNameNotFoundException;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.rest.dto.validation.IsUuid;
import ai.digital.deploy.permissions.service.ReferencedPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Validated
@RestController
@RequestMapping(value={"/v2/permissions/reference"})
@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001\u0002\u0006\f\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006U\u0001!\ta\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006q\u0002!\t!\u001f\u0005\u0007q\u0002!\t!!\f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003\u001f\u0003A\u0011AAI\u0005\u001d*\u0005\u0010^3oI\u0016$'+\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:\u001c8i\u001c8ue>dG.\u001a:\u000b\u00051i\u0011\u0001B5na2T!AD\b\u0002\u0005Y\u0014$B\u0001\t\u0012\u0003\u0011\u0011Xm\u001d;\u000b\u0005I\u0019\u0012aA1qS*\u0011A#F\u0001\fa\u0016\u0014X.[:tS>t7O\u0003\u0002\u0017/\u00051A-\u001a9m_fT!\u0001G\r\u0002\u000f\u0011Lw-\u001b;bY*\t!$\u0001\u0002bS\u000e\u00011C\u0001\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u0006Y\"/\u001a4fe\u0016t7-\u001a3QKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016\u0004\"!\n\u0015\u000e\u0003\u0019R!aJ\n\u0002\u000fM,'O^5dK&\u0011\u0011F\n\u0002\u001c%\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\tac\u0006\u0005\u0002.\u00015\t1\u0002C\u0003$\u0005\u0001\u0007A%A\bfI&$\b+\u001a:nSN\u001c\u0018n\u001c8t)\u0011\tt\u0007X0\u0011\u0005I*T\"A\u001a\u000b\u0005Qz\u0011a\u00013u_&\u0011ag\r\u0002!%>dWmV5uQJ+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8og\u0012#x\u000eC\u00039\u0007\u0001\u0007\u0011(A\u0006sK\u001a,'/\u001a8dK&#\u0007C\u0001\u001eB\u001d\tYt\b\u0005\u0002=?5\tQH\u0003\u0002?7\u00051AH]8pizJ!\u0001Q\u0010\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001~A#aN#\u0011\u0005\u0019\u000bV\"A$\u000b\u0005!K\u0015AC1o]>$\u0018\r^5p]*\u0011!jS\u0001\u0005E&tGM\u0003\u0002M\u001b\u0006\u0019q/\u001a2\u000b\u00059{\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003A\u000b1a\u001c:h\u0013\t\u0011vI\u0001\u0007QCRDg+\u0019:jC\ndW\r\u000b\u00028)B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'B\u0001\u001bZ\u0015\t\u00012#\u0003\u0002\\-\n1\u0011j]+vS\u0012DQ!X\u0002A\u0002e\n\u0001B]8mK:\u000bW.\u001a\u0015\u00039\u0016CQ\u0001Y\u0002A\u0002\u0005\f!$\u001a3jiJ{G.\u001a)fe6L7o]5p]N\u0014V-];fgR\u0004\"A\r2\n\u0005\r\u001c$AG#eSR\u0014v\u000e\\3QKJl\u0017n]:j_:\u001c(+Z9vKN$\bFA0f!\t1e-\u0003\u0002h\u000f\nY!+Z9vKN$(i\u001c3zQ\ty\u0016\u000e\u0005\u0002k]6\t1N\u0003\u0002XY*\tQ.A\u0004kC.\f'\u000f^1\n\u0005=\\'!\u0002,bY&$\u0007\u0006B\u0002riV\u0004\"A\u0012:\n\u0005M<%\u0001\u0004)bi\u000eDW*\u00199qS:<\u0017!\u0002<bYV,G&\u0001<\"\u0003]\f\u0011dL>sK\u001a,'/\u001a8dK&#WpL>s_2,g*Y7f{\u0006!r-\u001a;SK\u001a,'/\u001a8dKN4uN\u001d*pY\u0016$2A_A\u0006!\u0015Y\u0018\u0011AA\u0003\u001b\u0005a(BA?\u007f\u0003\u0011)H/\u001b7\u000b\u0003}\fAA[1wC&\u0019\u00111\u0001?\u0003\u0007M+G\u000fE\u0002|\u0003\u000fI1!!\u0003}\u0005\u0011)V+\u0013#\t\rQ\"\u0001\u0019AA\u0007!\r\u0011\u0014qB\u0005\u0004\u0003#\u0019$\u0001J$fiJ+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8og\u001a{'OU8mK&#G\t^8)\u0007\u0005-\u0011\u000e\u000b\u0006\u0005\u0003/!\u0018QDA\u0012\u0003K\u00012ARA\r\u0013\r\tYb\u0012\u0002\u000b\u000f\u0016$X*\u00199qS:<GFAA\u0010C\t\t\t#A\u00030e\u001647/\u0001\u0004qCJ\fWn\u001d\u0017\u0005\u0003O\tY#\t\u0002\u0002*\u00051!o\u001c7f\u0013\u0012\f\u0013\u0001\u0006\u000b\u0004u\u0006=\u0002B\u0002\u001b\u0006\u0001\u0004\t\t\u0004E\u00023\u0003gI1!!\u000e4\u0005\u0015:U\r\u001e*fM\u0016\u0014XM\\2fIB+'/\\5tg&|gn\u001d$peJ{G.Z%eg\u0012#x\u000eK\u0002\u00020%D#\"BA\fi\u0006m\u00121EA\u001fY\t\ty\u0002\f\u0003\u0002@\u0005-\u0012EAA!\u0003\u001d\u0011x\u000e\\3JIN\f\u0001dZ3u%\u00164WM]3oG\u0016\u001chi\u001c:S_2,g*Y7f)\rQ\u0018q\t\u0005\u0007i\u0019\u0001\r!!\u0013\u0011\u0007I\nY%C\u0002\u0002NM\u0012aeR3u%\u00164WM]3oG\u0016$\u0007+\u001a:nSN\u001c\u0018n\u001c8t\r>\u0014(k\u001c7f\u001d\u0006lW\r\u0012;pQ\r\t9%\u001b\u0015\u000b\r\u0005]A/a\u0015\u0002$\u0005UCFAA\u0010Y\u0011\t9&a\u000b\"\u0003u\u000b\u0011dZ3u%\u00164WM]3oG\u0016\u001chi\u001c:Qe&t7-\u001b9bYR\u0019!0!\u0018\t\rQ:\u0001\u0019AA0!\r\u0011\u0014\u0011M\u0005\u0004\u0003G\u001a$aJ$fiJ+g-\u001a:f]\u000e,G\rU3s[&\u001c8/[8og\u001a{'\u000f\u0015:j]\u000eL\u0007/\u00197Ei>D3!!\u0018jQ)9\u0011q\u0003;\u0002j\u0005\r\u00121\u000e\u0017\u0003\u0003?aC!!\u001c\u0002,\u0005\u0012\u0011qN\u0001\u000eaJLgnY5qC2t\u0015-\\3\u0002%\u0011,G.\u001a;f\r>\u0014(+\u001a4fe\u0016t7-\u001a\u000b\u0005\u0003k\nY\bE\u0002\u001f\u0003oJ1!!\u001f \u0005\u0011)f.\u001b;\t\u000baB\u0001\u0019A\u001d)\u0007\u0005mT\tK\u0002\u0002|QCc\u0001CABi\u0006%\u0005c\u0001$\u0002\u0006&\u0019\u0011qQ$\u0003\u001b\u0011+G.\u001a;f\u001b\u0006\u0004\b/\u001b8hY\t\tY)\t\u0002\u0002\u000e\u0006qqf\u001f:fM\u0016\u0014XM\\2f\u0013\u0012l\u0018!\u00033fY\u0016$X-\u00117m)\t\t)\b\u000b\u0004\n\u0003\u0007#\u0018Q\u0013\u0017\u0003\u0003/\u000b#!!'\u0002\t=\nG\u000e\u001c\u0015\u0007\u0001\u0005uE/a)\u0011\u0007\u0019\u000by*C\u0002\u0002\"\u001e\u0013aBU3rk\u0016\u001cH/T1qa&tw\r\f\u0002\u0002&\u0006\u0012\u0011qU\u0001\u001a_Y\u0014t\u0006]3s[&\u001c8/[8og>\u0012XMZ3sK:\u001cW\rK\u0002\u0001\u0003W\u00032ARAW\u0013\r\tyk\u0012\u0002\u000f%\u0016\u001cHoQ8oiJ|G\u000e\\3sQ\r\u0001\u00111\u0017\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0001*!/\u000b\u0005]k\u0015\u0002BA_\u0003o\u0013\u0011BV1mS\u0012\fG/\u001a3")
public class ExtendedReferencedPermissionsController {
    private final ReferencedPermissionService referencedPermissionService;

    @PatchMapping(value={"/{referenceId}/{roleName}"})
    public RoleWithReferencedPermissionsDto editPermissions(@IsUuid @PathVariable String referenceId, @PathVariable String roleName, @Valid @RequestBody EditRolePermissionsRequest editRolePermissionsRequest) {
        Right right;
        Tuple2 tuple2;
        UUID uuid = UUID.fromString(referenceId);
        Either either = this.referencedPermissionService.edit(uuid, roleName, CollectionConverters$.MODULE$.ListHasAsScala(editRolePermissionsRequest.addedPermissions()).asScala().toList(), CollectionConverters$.MODULE$.ListHasAsScala(editRolePermissionsRequest.removedPermissions()).asScala().toList());
        if (either instanceof Left) {
            Left left = (Left)either;
            RoleNameNotFoundServiceException exception = (RoleNameNotFoundServiceException)left.value();
            throw new RoleNameNotFoundException(exception.name());
        }
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            Role role = (Role)tuple2._1();
            List permissions = (List)tuple2._2();
            return new RoleWithReferencedPermissionsDto(RoleConverter$.MODULE$.roleToDto(role), uuid, RoleWithReferencedPermissionsConverter$.MODULE$.permissionToDto(permissions));
        }
        throw new MatchError((Object)either);
    }

    @GetMapping(value={"/refs"}, params={"roleId", "permissions"})
    public java.util.Set<UUID> getReferencesForRole(@Valid GetReferencedPermissionsForRoleIdDto dto) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.referencedPermissionService.getReferencesForRole(UUID.fromString(dto.roleId()), CollectionConverters$.MODULE$.ListHasAsScala(dto.permissions()).asScala().toList())).asJava();
    }

    @GetMapping(value={"/refs"}, params={"roleIds", "permissions"})
    public java.util.Set<UUID> getReferencesForRole(@Valid GetReferencedPermissionsForRoleIdsDto dto) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.referencedPermissionService.getReferencesForRoles(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dto.roleIds()).asScala().map((Function1 & Serializable)x$1 -> UUID.fromString(x$1))).toList(), CollectionConverters$.MODULE$.ListHasAsScala(dto.permissions()).asScala().toList())).asJava();
    }

    @GetMapping(value={"/refs"}, params={"roleName", "permissions"})
    public java.util.Set<UUID> getReferencesForRoleName(@Valid GetReferencedPermissionsForRoleNameDto dto) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.referencedPermissionService.getReferencesForRoleName(dto.roleName(), CollectionConverters$.MODULE$.ListHasAsScala(dto.permissions()).asScala().toList())).asJava();
    }

    @GetMapping(value={"/refs"}, params={"principalName", "permissions"})
    public java.util.Set<UUID> getReferencesForPrincipal(@Valid GetReferencedPermissionsForPrincipalDto dto) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)this.referencedPermissionService.getReferencesForPrincipalName(dto.principalName(), CollectionConverters$.MODULE$.ListHasAsScala(dto.permissions()).asScala().toList())).asJava();
    }

    @DeleteMapping(value={"/{referenceId}"})
    public void deleteForReference(@IsUuid @PathVariable String referenceId) {
        this.referencedPermissionService.removeForReference(UUID.fromString(referenceId));
    }

    @DeleteMapping(value={"/all"})
    public void deleteAll() {
        this.referencedPermissionService.removeAll();
    }

    public ExtendedReferencedPermissionsController(ReferencedPermissionService referencedPermissionService) {
        this.referencedPermissionService = referencedPermissionService;
    }
}

