/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.impl;

import com.xebialabs.deployit.core.rest.RuleResource;
import com.xebialabs.deployit.core.rest.StitchResource;
import com.xebialabs.deployit.core.rest.dto.NewRulesFileDTO;
import com.xebialabs.deployit.core.rest.dto.UpdateRulesFileDTO;
import com.xebialabs.deployit.core.rest.exception.CreateOrUpdateTypeException;
import com.xebialabs.deployit.core.rest.view.ExternalFilesView;
import com.xebialabs.deployit.core.rest.view.PageableView;
import com.xebialabs.deployit.core.rest.view.RuleListItemView;
import com.xebialabs.deployit.core.rest.view.RuleWithContentView;
import com.xebialabs.deployit.core.rest.view.RuleWithSourceContentView;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.SaveFileDto;
import com.xebialabs.deployit.engine.api.dto.SaveFileDto$;
import com.xebialabs.deployit.plugin.stitch.service.ChangeSetService;
import com.xebialabs.deployit.plugin.stitch.service.RuleFileValidationService;
import com.xebialabs.deployit.plugin.stitch.service.RuleGitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.RuleService;
import com.xebialabs.deployit.plugin.stitch.service.RulesFileService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.UUID;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001B\t\u0013\u0001}A\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005\"C&\u0001\u0001\u0004\u0005\r\u0011\"\u0001M\u0011%I\u0006\u00011AA\u0002\u0013\u0005!\fC\u0005d\u0001\u0001\u0007\t\u0011)Q\u0005\u001b\")\u0001\u000f\u0001C!c\"1\u0001\u000f\u0001C!\u0003sAq!!\u0019\u0001\t\u0003\n\u0019\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000!9\u00111\u0012\u0001\u0005B\u00055\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0002\u0011%VdWMU3t_V\u00148-Z%na2T!a\u0005\u000b\u0002\t%l\u0007\u000f\u001c\u0006\u0003+Y\tAA]3ti*\u0011q\u0003G\u0001\u0005G>\u0014XM\u0003\u0002\u001a5\u0005AA-\u001a9m_fLGO\u0003\u0002\u001c9\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002;\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\t\u0013\u0011\u0005\u0005\u0012S\"\u0001\u000b\n\u0005\r\"\"AD*uSR\u001c\u0007NU3t_V\u00148-\u001a\t\u0003C\u0015J!A\n\u000b\u0003\u0019I+H.\u001a*fg>,(oY3\u0002\u0017I,H.Z*feZL7-\u001a\t\u0003SAj\u0011A\u000b\u0006\u0003W1\nqa]3sm&\u001cWM\u0003\u0002.]\u000511\u000f^5uG\"T!a\f\r\u0002\rAdWoZ5o\u0013\t\t$FA\u0006Sk2,7+\u001a:wS\u000e,\u0017\u0001\u0005:vY\u0016\u001ch)\u001b7f'\u0016\u0014h/[2f!\tIC'\u0003\u00026U\t\u0001\"+\u001e7fg\u001aKG.Z*feZL7-Z\u0001\u0012eVdWmR5u\u001fB\u001c8+\u001a:wS\u000e,\u0007CA\u00159\u0013\tI$FA\tSk2,w)\u001b;PaN\u001cVM\u001d<jG\u0016\f\u0001c\u00195b]\u001e,7+\u001a;TKJ4\u0018nY3\u0011\u0005%b\u0014BA\u001f+\u0005A\u0019\u0005.\u00198hKN+GoU3sm&\u001cW-A\rsk2,g)\u001b7f-\u0006d\u0017\u000eZ1uS>t7+\u001a:wS\u000e,\u0007CA\u0015A\u0013\t\t%FA\rSk2,g)\u001b7f-\u0006d\u0017\u000eZ1uS>t7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0004E\r\u001eC\u0015J\u0013\t\u0003\u000b\u0002i\u0011A\u0005\u0005\u0006O\u0019\u0001\r\u0001\u000b\u0005\u0006e\u0019\u0001\ra\r\u0005\u0006m\u0019\u0001\ra\u000e\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006}\u0019\u0001\raP\u0001\te\u0016\u001c\bo\u001c8tKV\tQ\n\u0005\u0002O/6\tqJ\u0003\u0002Q#\u0006\u00191\u000f]5\u000b\u0005I\u001b\u0016\u0001\u0003:fgR,\u0017m]=\u000b\u0005Q+\u0016!\u00026c_N\u001c(\"\u0001,\u0002\u0007=\u0014x-\u0003\u0002Y\u001f\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006a!/Z:q_:\u001cXm\u0018\u0013fcR\u00111,\u0019\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0005+:LG\u000fC\u0004c\u0011\u0005\u0005\t\u0019A'\u0002\u0007a$\u0013'A\u0005sKN\u0004xN\\:fA!\u0012\u0011\"\u001a\t\u0003M:l\u0011a\u001a\u0006\u0003/!T!!\u001b6\u0002\u0005I\u001c(BA6m\u0003\t98OC\u0001n\u0003\u0015Q\u0017M^1y\u0013\tywMA\u0004D_:$X\r\u001f;\u0002\t1L7\u000f\u001e\u000b\ne\u0006%\u0011QDA\u0019\u0003k\u00012a]>\u007f\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002x=\u00051AH]8pizJ\u0011AX\u0005\u0003uv\u000bq\u0001]1dW\u0006<W-\u0003\u0002}{\n!A*[:u\u0015\tQX\fE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA#\u0001\u0003wS\u0016<\u0018\u0002BA\u0004\u0003\u0003\u0011\u0001CU;mK2K7\u000f^%uK64\u0016.Z<\t\u000f\u0005-!\u00021\u0001\u0002\u000e\u0005Ya.Y7fgB\f7-Z%e!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA!\u001e;jY*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!\u0001B+V\u0013\u0012Cq!a\b\u000b\u0001\u0004\t\t#A\u0006oC6,\u0007+\u0019;uKJt\u0007\u0003BA\u0012\u0003WqA!!\n\u0002(A\u0011Q/X\u0005\u0004\u0003Si\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002.\u0005=\"AB*ue&twMC\u0002\u0002*uCq!a\r\u000b\u0001\u0004\t\t#\u0001\u0005t_V\u00148-Z%e\u0011\u001d\t9D\u0003a\u0001\u0003C\t!B\u0019:b]\u000eDg*Y7f)%\u0011\u00181HA\u001f\u0003\u007f\t9\u0006C\u0004\u0002\f-\u0001\r!!\u0004\t\u000f\u0005}1\u00021\u0001\u0002\"!9\u0011\u0011I\u0006A\u0002\u0005\r\u0013!B8sI\u0016\u0014\b\u0003BA#\u0003'j!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0004IR|'\u0002BA'\u0003\u001f\n1!\u00199j\u0015\r\t\t\u0006G\u0001\u0007K:<\u0017N\\3\n\t\u0005U\u0013q\t\u0002\t\u001fJ$WM]5oO\"9\u0011\u0011L\u0006A\u0002\u0005m\u0013A\u00029bO&tw\r\u0005\u0003\u0002F\u0005u\u0013\u0002BA0\u0003\u000f\u0012a\u0001U1hS:<\u0017aB4fiJ+H.\u001a\u000b\u0005\u0003K\nY\u0007E\u0002\u0000\u0003OJA!!\u001b\u0002\u0002\t\u0019\"+\u001e7f/&$\bnQ8oi\u0016tGOV5fo\"9\u0011Q\u000e\u0007A\u0002\u00055\u0011AA5e\u0003Q9W\r\u001e*vY\u0016,\u0005\u0010^3s]\u0006dg)\u001b7fgR!\u00111OA>!\u0011\u001980!\u001e\u0011\u0007}\f9(\u0003\u0003\u0002z\u0005\u0005!!E#yi\u0016\u0014h.\u00197GS2,7OV5fo\"9\u0011QN\u0007A\u0002\u00055\u0011AD2sK\u0006$Xm\u0014:Va\u0012\fG/\u001a\u000b\u00047\u0006\u0005\u0005bBAB\u001d\u0001\u0007\u0011QQ\u0001\fg\u00064XMR5mK\u0012#x\u000e\u0005\u0003\u0002F\u0005\u001d\u0015\u0002BAE\u0003\u000f\u00121bU1wK\u001aKG.\u001a#u_\u0006!b/\u00197jI\u0006$XMT3x%VdWm\u001d$jY\u0016$2aWAH\u0011\u001d\t\tj\u0004a\u0001\u0003'\u000bqB\\3x%VdWm\u001d$jY\u0016$Ek\u0014\t\u0005\u0003+\u000bI*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\n\u000b\n\t\u0005m\u0015q\u0013\u0002\u0010\u001d\u0016<(+\u001e7fg\u001aKG.\u001a#U\u001f\u00069c/\u00197jI\u0006$X-\u00169eCR,'+\u001e7fg\u001aKG.Z!oIJ+G/\u001e:o\u0007>tG/\u001a8u)\u0011\t\t+a*\u0011\u0007}\f\u0019+\u0003\u0003\u0002&\u0006\u0005!!\u0007*vY\u0016<\u0016\u000e\u001e5T_V\u00148-Z\"p]R,g\u000e\u001e,jK^Dq!!+\u0011\u0001\u0004\tY+\u0001\nva\u0012\fG/\u001a*vY\u0016\u001ch)\u001b7f\tR{\u0005\u0003BAK\u0003[KA!a,\u0002\u0018\n\u0011R\u000b\u001d3bi\u0016\u0014V\u000f\\3t\r&dW\r\u0012+PQ\r\u0001\u00111\u0017\t\u0005\u0003k\u000b9-\u0004\u0002\u00028*!\u0011\u0011XA^\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003{\u000by,A\u0004gC\u000e$xN]=\u000b\t\u0005\u0005\u00171Y\u0001\u0006E\u0016\fgn\u001d\u0006\u0004\u0003\u000b,\u0016aD:qe&twM\u001a:b[\u0016<xN]6\n\t\u0005%\u0017q\u0017\u0002\n\u0003V$xn^5sK\u0012D3\u0001AAg!\u0011\ty-!6\u000e\u0005\u0005E'\u0002BAj\u0003\u0007\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t9.!5\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class RuleResourceImpl
extends StitchResource
implements RuleResource {
    private final RuleService ruleService;
    private final RuleGitOpsService ruleGitOpsService;
    private final ChangeSetService changeSetService;
    private final RuleFileValidationService ruleFileValidationService;
    @Context
    private HttpResponse response;

    public HttpResponse response() {
        return this.response;
    }

    public void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    @Override
    public List<RuleListItemView> list(UUID namespaceId, String namePattern, String sourceId, String branchName) {
        this.checkPermissions();
        return this.ruleGitOpsService.list((Option<UUID>)Option$.MODULE$.apply((Object)namespaceId), (Option<String>)Option$.MODULE$.apply((Object)namePattern), sourceId, branchName);
    }

    @Override
    public List<RuleListItemView> list(UUID namespaceId, String namePattern, Ordering order, Paging paging) {
        this.checkPermissions();
        PageableView<RuleListItemView> page = this.ruleService.list((Option<UUID>)Option$.MODULE$.apply((Object)namespaceId), (Option<String>)Option$.MODULE$.apply((Object)namePattern), paging, order);
        this.addPaginationHeaders(page, this.response());
        return page.items();
    }

    @Override
    public RuleWithContentView getRule(UUID id) {
        this.checkPermissions();
        return this.ruleService.findOne(id);
    }

    @Override
    public List<ExternalFilesView> getRuleExternalFiles(UUID id) {
        this.checkPermissions();
        return this.ruleService.getRuleExternalFilesList(id);
    }

    @Override
    public void createOrUpdate(SaveFileDto saveFileDto) {
        this.checkPermissions(saveFileDto.sourceId(), PlatformPermissions.EDIT_REPO);
        NewRulesFileDTO dto = new NewRulesFileDTO(saveFileDto.sourceId(), saveFileDto.directory(), saveFileDto.fileName(), saveFileDto.branch(), saveFileDto.stitchRule());
        String string = saveFileDto.type();
        String string2 = SaveFileDto$.MODULE$.CreateType();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.ruleFileValidationService.validateNewRuleFileContent(dto);
            this.ruleGitOpsService.save(saveFileDto);
            return;
        }
        String string4 = SaveFileDto$.MODULE$.UpdateType();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            this.ruleFileValidationService.validateUpdatedRuleFileContent(dto);
            this.ruleGitOpsService.save(saveFileDto);
            return;
        }
        throw new CreateOrUpdateTypeException("Type [" + saveFileDto.type() + "] is not allowed. Only types [" + SaveFileDto$.MODULE$.CreateType() + ", " + SaveFileDto$.MODULE$.UpdateType() + "] are allowed.");
    }

    @Override
    public void validateNewRulesFile(NewRulesFileDTO newRulesFileDTO) {
        this.checkPermissions();
        this.ruleFileValidationService.validateNewRuleFile(newRulesFileDTO);
    }

    @Override
    public RuleWithSourceContentView validateUpdateRulesFileAndReturnContent(UpdateRulesFileDTO updateRulesFileDTO) {
        this.checkPermissions();
        this.changeSetService.validateBranch(updateRulesFileDTO.sourceId(), updateRulesFileDTO.branch());
        return this.ruleGitOpsService.getRuleByFullNameAndBranch(updateRulesFileDTO.namespace(), updateRulesFileDTO.name(), updateRulesFileDTO.branch(), updateRulesFileDTO.sourceId());
    }

    public RuleResourceImpl(RuleService ruleService, RulesFileService rulesFileService, RuleGitOpsService ruleGitOpsService, ChangeSetService changeSetService, RuleFileValidationService ruleFileValidationService) {
        this.ruleService = ruleService;
        this.ruleGitOpsService = ruleGitOpsService;
        this.changeSetService = changeSetService;
        this.ruleFileValidationService = ruleFileValidationService;
    }
}

