/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client.compatible1X;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQCompatibleMessage;

public class ActiveMQTextCompatibleMessage
extends ActiveMQTextMessage {
    @Override
    public void setJMSReplyTo(Destination dest) throws JMSException {
        this.replyTo = ActiveMQCompatibleMessage.setCompatibleReplyTo(dest, this.message);
    }

    @Override
    public Destination getJMSReplyTo() throws JMSException {
        if (this.replyTo == null) {
            this.replyTo = ActiveMQCompatibleMessage.findCompatibleReplyTo(this.message);
        }
        return this.replyTo;
    }

    public ActiveMQTextCompatibleMessage(ClientSession session) {
        super(session);
    }

    public ActiveMQTextCompatibleMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public ActiveMQTextCompatibleMessage(TextMessage foreign, ClientSession session) throws JMSException {
        super(foreign, session);
    }

    @Override
    protected SimpleString checkPrefix(SimpleString address) {
        return ActiveMQCompatibleMessage.checkPrefix1X(address);
    }
}

