/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BlobLocatorInputStream;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientTypes;
import org.apache.derby.client.am.ClobLocatorInputStream;
import org.apache.derby.client.am.ClobLocatorReader;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.FloatingPoint;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;

public abstract class Cursor {
    protected Agent agent_;
    public static final int STRING = 0;
    public static final int VARIABLE_STRING = 2;
    public static final int VARIABLE_SHORT_STRING = 1;
    public static final int NULL_TERMINATED_STRING = 3;
    public static final int BYTES = 4;
    public static final int NULL_TERMINATED_BYTES = 7;
    static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public byte[] dataBuffer_;
    public ByteArrayOutputStream dataBufferStream_;
    public int position_;
    public int lastValidBytePosition_;
    public boolean hasLobs_;
    protected int currentRowPosition_;
    private int nextRowPosition_;
    protected int[] columnDataPosition_;
    protected int[] columnDataComputedLength_;
    private boolean allRowsReceivedFromServer_;
    long rowsRead_;
    int maxFieldSize_ = 0;
    protected ArrayList<int[]> columnDataPositionCache_ = new ArrayList();
    protected ArrayList<int[]> columnDataLengthCache_ = new ArrayList();
    protected ArrayList<boolean[]> columnDataIsNullCache_ = new ArrayList();
    ArrayList<Boolean> isUpdateDeleteHoleCache_ = new ArrayList();
    boolean isUpdateDeleteHole_;
    private boolean isRowUpdated_;
    static final Boolean ROW_IS_NULL = Boolean.TRUE;
    private static final Boolean ROW_IS_NOT_NULL = Boolean.FALSE;
    private Calendar recyclableCalendar_ = null;
    public int[] jdbcTypes_;
    public int columns_;
    public boolean[] nullable_;
    public Charset[] charset_;
    public boolean[] isNull_;
    public int[] fdocaLength_;
    public int[] ccsid_;
    private char[] charBuffer_;

    public Cursor(Agent agent) {
        this.agent_ = agent;
        this.isRowUpdated_ = false;
        this.dataBufferStream_ = new ByteArrayOutputStream();
    }

    public void setNumberOfColumns(int n) {
        this.columnDataPosition_ = new int[n];
        this.columnDataComputedLength_ = new int[n];
        this.columns_ = n;
        this.nullable_ = new boolean[n];
        this.charset_ = new Charset[n];
        this.ccsid_ = new int[n];
        this.isNull_ = new boolean[n];
        this.jdbcTypes_ = new int[n];
    }

    protected boolean stepNext(boolean bl) throws SqlException {
        this.clearLobData_();
        this.makeNextRowPositionCurrent();
        this.isUpdateDeleteHole_ = false;
        this.isRowUpdated_ = false;
        while (!this.dataBufferHasUnprocessedData()) {
            if (this.allRowsReceivedFromServer_) {
                return false;
            }
            this.getMoreData_();
        }
        boolean bl2 = this.calculateColumnOffsetsForRow_(0, bl);
        this.markNextRowPosition();
        return bl2;
    }

    public boolean next() throws SqlException {
        return this.stepNext(true);
    }

    public void setAllRowsReceivedFromServer(boolean bl) {
        this.allRowsReceivedFromServer_ = bl;
    }

    public final boolean allRowsReceivedFromServer() {
        return this.allRowsReceivedFromServer_;
    }

    final boolean currentRowPositionIsEqualToNextRowPosition() {
        return this.currentRowPosition_ == this.nextRowPosition_;
    }

    public final void resetDataBuffer() {
        this.position_ = 0;
        this.lastValidBytePosition_ = 0;
        this.currentRowPosition_ = 0;
        this.nextRowPosition_ = 0;
        this.setAllRowsReceivedFromServer(false);
        this.dataBufferStream_.reset();
    }

    final boolean dataBufferHasUnprocessedData() {
        return this.lastValidBytePosition_ - this.position_ > 0;
    }

    protected abstract boolean calculateColumnOffsetsForRow_(int var1, boolean var2) throws SqlException, DisconnectException;

    protected abstract void clearLobData_();

    protected abstract void getMoreData_() throws SqlException;

    public final void setIsUpdataDeleteHole(int n, boolean bl) {
        Boolean bl2;
        this.isUpdateDeleteHole_ = bl;
        Boolean bl3 = bl2 = this.isUpdateDeleteHole_ ? ROW_IS_NULL : ROW_IS_NOT_NULL;
        if (this.isUpdateDeleteHoleCache_.size() == n) {
            this.isUpdateDeleteHoleCache_.add(bl2);
        } else {
            this.isUpdateDeleteHoleCache_.set(n, bl2);
        }
    }

    public final void setIsRowUpdated(boolean bl) {
        this.isRowUpdated_ = bl;
    }

    public final boolean getIsRowUpdated() {
        return this.isRowUpdated_;
    }

    public final boolean getIsUpdateDeleteHole() {
        return this.isUpdateDeleteHole_;
    }

    protected final void markNextRowPosition() {
        this.nextRowPosition_ = this.position_;
    }

    protected final void makeNextRowPositionCurrent() {
        this.currentRowPosition_ = this.nextRowPosition_;
    }

    public final void incrementRowsReadEvent() {
        ++this.rowsRead_;
    }

    private boolean get_BOOLEAN(int n) {
        return SignedBinary.getByte(this.dataBuffer_, this.columnDataPosition_[n - 1]) != 0;
    }

    private final short get_SMALLINT(int n) {
        return SignedBinary.getShort(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    protected final int get_INTEGER(int n) {
        return SignedBinary.getInt(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final long get_BIGINT(int n) {
        return SignedBinary.getLong(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final float get_FLOAT(int n) {
        return FloatingPoint.getFloat(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final double get_DOUBLE(int n) {
        return FloatingPoint.getDouble(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final BigDecimal get_DECIMAL(int n) throws SqlException {
        return Decimal.getBigDecimal(this.dataBuffer_, this.columnDataPosition_[n - 1], this.getColumnPrecision(n - 1), this.getColumnScale(n - 1));
    }

    private double getDoubleFromDECIMAL(int n) throws SqlException {
        try {
            return Decimal.getDouble(this.dataBuffer_, this.columnDataPosition_[n - 1], this.getColumnPrecision(n - 1), this.getColumnScale(n - 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), illegalArgumentException, "double");
        }
    }

    private long getLongFromDECIMAL(int n, String string) throws SqlException {
        try {
            return Decimal.getLong(this.dataBuffer_, this.columnDataPosition_[n - 1], this.getColumnPrecision(n - 1), this.getColumnScale(n - 1));
        }
        catch (ArithmeticException arithmeticException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), arithmeticException, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22003"), illegalArgumentException, string);
        }
    }

    private String getVARCHAR(int n) throws SqlException {
        if (this.ccsid_[n - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[n - 1] + 2, this.columnDataComputedLength_[n - 1] - 2);
        }
        if (this.charset_[n - 1] == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.2"), new Object[0]);
        }
        String string = new String(this.dataBuffer_, this.columnDataPosition_[n - 1] + 2, this.columnDataComputedLength_[n - 1] - 2, this.charset_[n - 1]);
        return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
    }

    private String getCHAR(int n) throws SqlException {
        if (this.ccsid_[n - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[n - 1], this.columnDataComputedLength_[n - 1]);
        }
        if (this.charset_[n - 1] == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.2"), new Object[0]);
        }
        String string = new String(this.dataBuffer_, this.columnDataPosition_[n - 1], this.columnDataComputedLength_[n - 1], this.charset_[n - 1]);
        return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
    }

    private Date getDATE(int n, Calendar calendar) throws SqlException {
        return DateTime.dateBytesToDate(this.dataBuffer_, this.columnDataPosition_[n - 1], calendar, this.charset_[n - 1]);
    }

    private LocalDate getLocalDateFromDATE(int n) throws SqlException {
        return DateTime.dateBytesToLocalDate(this.dataBuffer_, this.columnDataPosition_[n - 1], this.charset_[n - 1]);
    }

    private Time getTIME(int n, Calendar calendar) throws SqlException {
        return DateTime.timeBytesToTime(this.dataBuffer_, this.columnDataPosition_[n - 1], calendar, this.charset_[n - 1]);
    }

    private LocalTime getLocalTimeFromTIME(int n) throws SqlException {
        return DateTime.timeBytesToLocalTime(this.dataBuffer_, this.columnDataPosition_[n - 1], this.charset_[n - 1]);
    }

    private final Timestamp getTIMESTAMP(int n, Calendar calendar) throws SqlException {
        return DateTime.timestampBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n - 1], calendar, this.charset_[n - 1], this.agent_.connection_.serverSupportsTimestampNanoseconds());
    }

    private final LocalDateTime getLocalDateTimeFromTIMESTAMP(int n) throws SqlException {
        return DateTime.timestampBytesToLocalDateTime(this.dataBuffer_, this.columnDataPosition_[n - 1], this.charset_[n - 1], this.agent_.connection_.serverSupportsTimestampNanoseconds());
    }

    private final Timestamp getTimestampFromDATE(int n, Calendar calendar) throws SqlException {
        return DateTime.dateBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n - 1], calendar, this.charset_[n - 1]);
    }

    private final Timestamp getTimestampFromTIME(int n, Calendar calendar) throws SqlException {
        return DateTime.timeBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n - 1], calendar, this.charset_[n - 1]);
    }

    private final Date getDateFromTIMESTAMP(int n, Calendar calendar) throws SqlException {
        return DateTime.timestampBytesToDate(this.dataBuffer_, this.columnDataPosition_[n - 1], calendar, this.charset_[n - 1]);
    }

    private final Time getTimeFromTIMESTAMP(int n, Calendar calendar) throws SqlException {
        return DateTime.timestampBytesToTime(this.dataBuffer_, this.columnDataPosition_[n - 1], calendar, this.charset_[n - 1]);
    }

    private String getStringFromDATE(int n) throws SqlException {
        return this.getDATE(n, this.getRecyclableCalendar()).toString();
    }

    private String getStringFromTIME(int n) throws SqlException {
        return this.getTIME(n, this.getRecyclableCalendar()).toString();
    }

    private String getStringFromTIMESTAMP(int n) throws SqlException {
        return this.getTIMESTAMP(n, this.getRecyclableCalendar()).toString();
    }

    private byte[] get_CHAR_FOR_BIT_DATA(int n) throws SqlException {
        int n2 = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[n - 1] : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[n - 1]);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n - 1], byArray, 0, n2);
        return byArray;
    }

    private byte[] get_VARCHAR_FOR_BIT_DATA(int n) throws SqlException {
        int n2 = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[n - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[n - 1] - 2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n - 1] + 2, byArray, 0, byArray.length);
        return byArray;
    }

    private Object get_UDT(int n) throws SqlException {
        int n2 = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[n - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[n - 1] - 2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n - 1] + 2, byArray, 0, byArray.length);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XN020.S"), exception, exception.getMessage());
        }
    }

    private Calendar getRecyclableCalendar() {
        if (this.recyclableCalendar_ == null) {
            this.recyclableCalendar_ = new GregorianCalendar();
        }
        return this.recyclableCalendar_;
    }

    CallableLocatorProcedures getLocatorProcedures() {
        return this.agent_.connection_.locatorProcedureCall();
    }

    protected abstract int locator(int var1);

    public abstract ClientBlob getBlobColumn_(int var1, Agent var2, boolean var3) throws SqlException;

    public abstract ClientClob getClobColumn_(int var1, Agent var2, boolean var3) throws SqlException;

    final boolean getBoolean(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return this.get_BOOLEAN(n);
            }
            case 5: {
                return this.agent_.crossConverters_.getBooleanFromShort(this.get_SMALLINT(n));
            }
            case 4: {
                return this.agent_.crossConverters_.getBooleanFromInt(this.get_INTEGER(n));
            }
            case -5: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.get_BIGINT(n));
            }
            case 7: {
                return this.agent_.crossConverters_.getBooleanFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getBooleanFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.getLongFromDECIMAL(n, "boolean"));
            }
            case 1: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("boolean", n);
    }

    final byte getByte(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getByteFromBoolean(this.get_BOOLEAN(n));
            }
            case 5: {
                return this.agent_.crossConverters_.getByteFromShort(this.get_SMALLINT(n));
            }
            case 4: {
                return this.agent_.crossConverters_.getByteFromInt(this.get_INTEGER(n));
            }
            case -5: {
                return this.agent_.crossConverters_.getByteFromLong(this.get_BIGINT(n));
            }
            case 7: {
                return this.agent_.crossConverters_.getByteFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getByteFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getByteFromLong(this.getLongFromDECIMAL(n, "byte"));
            }
            case 1: {
                return this.agent_.crossConverters_.getByteFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getByteFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("byte", n);
    }

    final short getShort(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getShortFromBoolean(this.get_BOOLEAN(n));
            }
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.agent_.crossConverters_.getShortFromInt(this.get_INTEGER(n));
            }
            case -5: {
                return this.agent_.crossConverters_.getShortFromLong(this.get_BIGINT(n));
            }
            case 7: {
                return this.agent_.crossConverters_.getShortFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getShortFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getShortFromLong(this.getLongFromDECIMAL(n, "short"));
            }
            case 1: {
                return this.agent_.crossConverters_.getShortFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getShortFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("short", n);
    }

    final int getInt(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getIntFromBoolean(this.get_BOOLEAN(n));
            }
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.agent_.crossConverters_.getIntFromLong(this.get_BIGINT(n));
            }
            case 7: {
                return this.agent_.crossConverters_.getIntFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getIntFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getIntFromLong(this.getLongFromDECIMAL(n, "int"));
            }
            case 1: {
                return this.agent_.crossConverters_.getIntFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getIntFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("int", n);
    }

    final long getLong(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getLongFromBoolean(this.get_BOOLEAN(n));
            }
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.get_BIGINT(n);
            }
            case 7: {
                return this.agent_.crossConverters_.getLongFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getLongFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.getLongFromDECIMAL(n, "long");
            }
            case 1: {
                return this.agent_.crossConverters_.getLongFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getLongFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("long", n);
    }

    final float getFloat(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getFloatFromBoolean(this.get_BOOLEAN(n));
            }
            case 7: {
                return this.get_FLOAT(n);
            }
            case 8: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.getDoubleFromDECIMAL(n));
            }
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.get_BIGINT(n);
            }
            case 1: {
                return this.agent_.crossConverters_.getFloatFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getFloatFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("float", n);
    }

    final double getDouble(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return this.agent_.crossConverters_.getDoubleFromBoolean(this.get_BOOLEAN(n));
            }
            case 7: {
                double d = this.get_FLOAT(n);
                return d;
            }
            case 8: {
                return this.get_DOUBLE(n);
            }
            case 3: {
                return this.getDoubleFromDECIMAL(n);
            }
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.get_BIGINT(n);
            }
            case 1: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("double", n);
    }

    final BigDecimal getBigDecimal(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return BigDecimal.valueOf(this.getLong(n));
            }
            case 3: {
                return this.get_DECIMAL(n);
            }
            case 7: {
                float f = this.get_FLOAT(n);
                return new BigDecimal(String.valueOf(f));
            }
            case 8: {
                return BigDecimal.valueOf(this.get_DOUBLE(n));
            }
            case 5: {
                return BigDecimal.valueOf(this.get_SMALLINT(n));
            }
            case 4: {
                return BigDecimal.valueOf(this.get_INTEGER(n));
            }
            case -5: {
                return BigDecimal.valueOf(this.get_BIGINT(n));
            }
            case 1: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("java.math.BigDecimal", n);
    }

    final Date getDate(int n, Calendar calendar) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 91: {
                return this.getDATE(n, calendar);
            }
            case 93: {
                return this.getDateFromTIMESTAMP(n, calendar);
            }
            case 1: {
                return this.agent_.crossConverters_.getDateFromString(this.getCHAR(n), calendar);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDateFromString(this.getVARCHAR(n), calendar);
            }
        }
        throw this.coercionError("java.sql.Date", n);
    }

    final LocalDate getLocalDate(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 91: {
                return this.getLocalDateFromDATE(n);
            }
            case 93: {
                return this.getLocalDateTimeFromTIMESTAMP(n).toLocalDate();
            }
            case 1: {
                return this.agent_.crossConverters_.getLocalDateFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getLocalDateFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("java.time.LocalDate", n);
    }

    final Time getTime(int n, Calendar calendar) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 92: {
                return this.getTIME(n, calendar);
            }
            case 93: {
                return this.getTimeFromTIMESTAMP(n, calendar);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimeFromString(this.getCHAR(n), calendar);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimeFromString(this.getVARCHAR(n), calendar);
            }
        }
        throw this.coercionError("java.sql.Time", n);
    }

    final LocalTime getLocalTime(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 92: {
                return this.getLocalTimeFromTIME(n);
            }
            case 93: {
                return this.getLocalDateTimeFromTIMESTAMP(n).toLocalTime();
            }
            case 1: {
                return this.agent_.crossConverters_.getLocalTimeFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getLocalTimeFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("java.time.LocalTime", n);
    }

    final Timestamp getTimestamp(int n, Calendar calendar) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 93: {
                return this.getTIMESTAMP(n, calendar);
            }
            case 91: {
                return this.getTimestampFromDATE(n, calendar);
            }
            case 92: {
                return this.getTimestampFromTIME(n, calendar);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getCHAR(n), calendar);
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getVARCHAR(n), calendar);
            }
        }
        throw this.coercionError("java.sql.Timestamp", n);
    }

    final LocalDateTime getLocalDateTime(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 93: {
                return this.getLocalDateTimeFromTIMESTAMP(n);
            }
            case 91: {
                return this.getLocalDateFromDATE(n).atStartOfDay();
            }
            case 92: {
                return this.getLocalTimeFromTIME(n).atDate(DateTimeValue.TIME_EPOCH);
            }
            case 1: {
                return this.agent_.crossConverters_.getLocalDateTimeFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getLocalDateTimeFromString(this.getVARCHAR(n));
            }
        }
        throw this.coercionError("java.time.LocalDateTime", n);
    }

    final String getString(int n) throws SqlException {
        try {
            switch (this.jdbcTypes_[n - 1]) {
                case 16: {
                    if (this.get_BOOLEAN(n)) {
                        return Boolean.TRUE.toString();
                    }
                    return Boolean.FALSE.toString();
                }
                case 1: {
                    return this.getCHAR(n);
                }
                case -1: 
                case 12: {
                    return this.getVARCHAR(n);
                }
                case 5: {
                    return String.valueOf(this.get_SMALLINT(n));
                }
                case 4: {
                    return String.valueOf(this.get_INTEGER(n));
                }
                case -5: {
                    return String.valueOf(this.get_BIGINT(n));
                }
                case 7: {
                    return String.valueOf(this.get_FLOAT(n));
                }
                case 8: {
                    return String.valueOf(this.get_DOUBLE(n));
                }
                case 3: {
                    return String.valueOf(this.get_DECIMAL(n));
                }
                case 91: {
                    return this.getStringFromDATE(n);
                }
                case 92: {
                    return this.getStringFromTIME(n);
                }
                case 93: {
                    return this.getStringFromTIMESTAMP(n);
                }
                case -2: {
                    String string = this.agent_.crossConverters_.getStringFromBytes(this.get_CHAR_FOR_BIT_DATA(n));
                    return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
                }
                case -4: 
                case -3: {
                    String string = this.agent_.crossConverters_.getStringFromBytes(this.get_VARCHAR_FOR_BIT_DATA(n));
                    return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
                }
                case 2000: {
                    Object object = this.get_UDT(n);
                    if (object == null) {
                        return null;
                    }
                    return object.toString();
                }
                case 2004: {
                    ClientBlob clientBlob = this.getBlobColumn_(n, this.agent_, false);
                    String string = this.agent_.crossConverters_.getStringFromBytes(clientBlob.getBytes(1L, (int)clientBlob.length()));
                    return string;
                }
                case 2005: {
                    ClientClob clientClob = this.getClobColumn_(n, this.agent_, false);
                    String string = clientClob.getSubString(1L, (int)clientClob.length());
                    return string;
                }
            }
            throw this.coercionError("String", n);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    final byte[] getBytes(int n) throws SqlException {
        try {
            switch (this.jdbcTypes_[n - 1]) {
                case -2: {
                    return this.get_CHAR_FOR_BIT_DATA(n);
                }
                case -4: 
                case -3: {
                    return this.get_VARCHAR_FOR_BIT_DATA(n);
                }
                case 2004: {
                    ClientBlob clientBlob = this.getBlobColumn_(n, this.agent_, false);
                    byte[] byArray = clientBlob.getBytes(1L, (int)clientBlob.length());
                    return byArray;
                }
            }
            throw this.coercionError("byte[]", n);
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    final InputStream getBinaryStream(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n));
            }
            case 2004: {
                ClientBlob clientBlob = this.getBlobColumn_(n, this.agent_, false);
                if (clientBlob.isLocator()) {
                    BlobLocatorInputStream blobLocatorInputStream = new BlobLocatorInputStream(this.agent_.connection_, clientBlob);
                    return new BufferedInputStream(blobLocatorInputStream);
                }
                return clientBlob.getBinaryStreamX();
            }
        }
        throw this.coercionError("java.io.InputStream", n);
    }

    final InputStream getAsciiStream(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2005: {
                ClientClob clientClob = this.getClobColumn_(n, this.agent_, false);
                if (clientClob.isLocator()) {
                    ClobLocatorInputStream clobLocatorInputStream = new ClobLocatorInputStream(this.agent_.connection_, clientClob);
                    return new BufferedInputStream(clobLocatorInputStream);
                }
                return clientClob.getAsciiStreamX();
            }
            case 1: {
                return new ByteArrayInputStream(this.getCHAR(n).getBytes(ISO_8859_1));
            }
            case -1: 
            case 12: {
                return new ByteArrayInputStream(this.getVARCHAR(n).getBytes(ISO_8859_1));
            }
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n));
            }
            case 2004: {
                return this.getBinaryStream(n);
            }
        }
        throw this.coercionError("java.io.InputStream", n);
    }

    final Reader getCharacterStream(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2005: {
                ClientClob clientClob = this.getClobColumn_(n, this.agent_, false);
                if (clientClob.isLocator()) {
                    ClobLocatorReader clobLocatorReader = new ClobLocatorReader(this.agent_.connection_, clientClob);
                    return new BufferedReader(clobLocatorReader);
                }
                return clientClob.getCharacterStreamX();
            }
            case 1: {
                return new StringReader(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return new StringReader(this.getVARCHAR(n));
            }
            case -2: {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n)), UTF_16BE);
            }
            case -4: 
            case -3: {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n)), UTF_16BE);
            }
            case 2004: {
                return new InputStreamReader(this.getBinaryStream(n), UTF_16BE);
            }
        }
        throw this.coercionError("java.io.Reader", n);
    }

    final Blob getBlob(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2004: {
                return this.getBlobColumn_(n, this.agent_, true);
            }
        }
        throw this.coercionError("java.sql.Blob", n);
    }

    final Clob getClob(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2005: {
                return this.getClobColumn_(n, this.agent_, true);
            }
        }
        throw this.coercionError("java.sql.Clob", n);
    }

    final Array getArray(int n) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "getArray(int)");
    }

    final Ref getRef(int n) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "getRef(int)");
    }

    final Object getObject(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 16: {
                return this.get_BOOLEAN(n);
            }
            case 5: {
                return (int)this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.get_BIGINT(n);
            }
            case 7: {
                return Float.valueOf(this.get_FLOAT(n));
            }
            case 8: {
                return this.get_DOUBLE(n);
            }
            case 3: {
                return this.get_DECIMAL(n);
            }
            case 91: {
                return this.getDATE(n, this.getRecyclableCalendar());
            }
            case 92: {
                return this.getTIME(n, this.getRecyclableCalendar());
            }
            case 93: {
                return this.getTIMESTAMP(n, this.getRecyclableCalendar());
            }
            case 1: {
                return this.getCHAR(n);
            }
            case -1: 
            case 12: {
                return this.getVARCHAR(n);
            }
            case -2: {
                return this.get_CHAR_FOR_BIT_DATA(n);
            }
            case -4: 
            case -3: {
                return this.get_VARCHAR_FOR_BIT_DATA(n);
            }
            case 2000: {
                return this.get_UDT(n);
            }
            case 2004: {
                return this.getBlobColumn_(n, this.agent_, true);
            }
            case 2005: {
                return this.getClobColumn_(n, this.agent_, true);
            }
        }
        throw this.coercionError("Object", n);
    }

    public final void allocateCharBuffer() {
        int n = 0;
        block3: for (int i = 0; i < this.columns_; ++i) {
            switch (this.jdbcTypes_[i]) {
                case -1: 
                case 1: 
                case 12: {
                    if (this.fdocaLength_[i] <= n) continue block3;
                    n = this.fdocaLength_[i];
                }
            }
        }
        this.charBuffer_ = new char[n];
    }

    private String getStringWithoutConvert(int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        for (int i = n; i < n3; i += 2) {
            this.charBuffer_[n4++] = (char)((this.dataBuffer_[i] & 0xFF) << 8 | this.dataBuffer_[i + 1] & 0xFF);
        }
        return new String(this.charBuffer_, 0, n4);
    }

    private ColumnTypeConversionException coercionError(String string, int n) {
        return new ColumnTypeConversionException(this.agent_.logWriter_, string, ClientTypes.getTypeString(this.jdbcTypes_[n - 1]));
    }

    public void nullDataForGC() {
        this.dataBuffer_ = null;
        this.dataBufferStream_ = null;
        this.columnDataPosition_ = null;
        this.columnDataComputedLength_ = null;
        this.columnDataPositionCache_ = null;
        this.columnDataLengthCache_ = null;
        this.columnDataIsNullCache_ = null;
        this.jdbcTypes_ = null;
        this.nullable_ = null;
        this.charset_ = null;
        this.ccsid_ = null;
        this.isUpdateDeleteHoleCache_ = null;
        this.isNull_ = null;
        this.fdocaLength_ = null;
        this.charBuffer_ = null;
    }

    private int getColumnPrecision(int n) {
        return this.fdocaLength_[n] >> 8 & 0xFF;
    }

    private int getColumnScale(int n) {
        return this.fdocaLength_[n] & 0xFF;
    }
}

