/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.NoScopeGiven$;
import org.apache.pekko.actor.Scope;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterScope$;
import org.apache.pekko.cluster.routing.ClusterRouterGroup;
import org.apache.pekko.cluster.routing.ClusterRouterGroupSettings$;
import org.apache.pekko.cluster.routing.ClusterRouterPool;
import org.apache.pekko.cluster.routing.ClusterRouterPoolSettings$;
import org.apache.pekko.remote.RemoteDeployer;
import org.apache.pekko.remote.routing.RemoteRouterConfig;
import org.apache.pekko.routing.Group;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.RouterConfig;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005m3Q!\u0002\u0004\u0001\u00119A\u0011\"\u0006\u0001\u0003\u0002\u0003\u0006IaF\u0011\t\u0013\u0015\u0002!\u0011!Q\u0001\n\u0019J\u0003\"B\u0016\u0001\t\u0003a\u0003\"B\u0019\u0001\t\u0003\u0012$aD\"mkN$XM\u001d#fa2|\u00170\u001a:\u000b\u0005\u001dA\u0011aB2mkN$XM\u001d\u0006\u0003\u0013)\tQ\u0001]3lW>T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0003%!\taA]3n_R,\u0017B\u0001\u000b\u0012\u00059\u0011V-\\8uK\u0012+\u0007\u000f\\8zKJ\f\u0011bX:fiRLgnZ:\u0004\u0001A\u0011\u0001D\b\b\u00033qi\u0011A\u0007\u0006\u00037!\tQ!Y2u_JL!!\b\u000e\u0002\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0005\u0003?\u0001\u0012\u0001bU3ui&twm\u001d\u0006\u0003;iI!AI\u0012\u0002\u0011M,G\u000f^5oONL!\u0001\n\u000e\u0003\u0011\u0011+\u0007\u000f\\8zKJ\f1a\u00189n!\tIr%\u0003\u0002)5\tiA)\u001f8b[&\u001c\u0017iY2fgNL!AK\u0012\u0002\u001b\u0011Lh.Y7jG\u0006\u001b7-Z:t\u0003\u0019a\u0014N\\5u}Q\u0019Qf\f\u0019\u0011\u00059\u0002Q\"\u0001\u0004\t\u000bU\u0019\u0001\u0019A\f\t\u000b\u0015\u001a\u0001\u0019\u0001\u0014\u0002\u0017A\f'o]3D_:4\u0017n\u001a\u000b\u0004gqJ\u0005c\u0001\u001b8s5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004PaRLwN\u001c\t\u00033iJ!a\u000f\u000e\u0003\r\u0011+\u0007\u000f\\8z\u0011\u0015iD\u00011\u0001?\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005}2eB\u0001!E!\t\tU'D\u0001C\u0015\t\u0019e#\u0001\u0004=e>|GOP\u0005\u0003\u000bV\na\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0019\u0019FO]5oO*\u0011Q)\u000e\u0005\u0006\u0015\u0012\u0001\raS\u0001\u0007G>tg-[4\u0011\u00051\u0013V\"A'\u000b\u0005)s%BA(Q\u0003!!\u0018\u0010]3tC\u001a,'\"A)\u0002\u0007\r|W.\u0003\u0002T\u001b\n11i\u001c8gS\u001eD#\u0001A+\u0011\u0005YKV\"A,\u000b\u0005aC\u0011AC1o]>$\u0018\r^5p]&\u0011!l\u0016\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public class ClusterDeployer
extends RemoteDeployer {
    public Option<Deploy> parseConfig(String path, Config config) {
        Config config2;
        if (config.hasPath("cluster.enabled") && config.getBoolean("cluster.enabled") && !config.hasPath("nr-of-instances")) {
            int maxTotalNrOfInstances = config.withFallback((ConfigMergeable)this.default()).getInt("cluster.max-total-nr-of-instances");
            config2 = ConfigFactory.parseString((String)new StringBuilder(16).append("nr-of-instances=").append(maxTotalNrOfInstances).toString()).withFallback((ConfigMergeable)config);
        } else {
            config2 = config;
        }
        Config config22 = config2;
        Option option = super.parseConfig(path, config22);
        if (option instanceof Some) {
            Some some = (Some)option;
            Deploy deploy = (Deploy)some.value();
            if (deploy.config().getBoolean("cluster.enabled")) {
                Scope scope = deploy.scope();
                NoScopeGiven$ noScopeGiven$ = NoScopeGiven$.MODULE$;
                if (scope == null ? noScopeGiven$ != null : !scope.equals(noScopeGiven$)) {
                    throw new ConfigurationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cluster deployment can't be combined with scope [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{deploy.scope()})));
                }
                if (deploy.routerConfig() instanceof RemoteRouterConfig) {
                    throw new ConfigurationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cluster deployment can't be combined with [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{deploy.routerConfig()})));
                }
                RouterConfig routerConfig = deploy.routerConfig();
                if (routerConfig instanceof Pool) {
                    Pool pool = (Pool)routerConfig;
                    ClusterRouterPool x$1 = new ClusterRouterPool(pool, ClusterRouterPoolSettings$.MODULE$.fromConfig(deploy.config()));
                    ClusterScope$ x$2 = ClusterScope$.MODULE$;
                    String x$3 = deploy.copy$default$1();
                    Config x$4 = deploy.copy$default$2();
                    String x$5 = deploy.copy$default$5();
                    String x$6 = deploy.copy$default$6();
                    return new Some((Object)deploy.copy(x$3, x$4, (RouterConfig)x$1, (Scope)x$2, x$5, x$6));
                }
                if (routerConfig instanceof Group) {
                    Group group = (Group)routerConfig;
                    ClusterRouterGroup x$7 = new ClusterRouterGroup(group, ClusterRouterGroupSettings$.MODULE$.fromConfig(deploy.config()));
                    ClusterScope$ x$8 = ClusterScope$.MODULE$;
                    String x$9 = deploy.copy$default$1();
                    Config x$10 = deploy.copy$default$2();
                    String x$11 = deploy.copy$default$5();
                    String x$12 = deploy.copy$default$6();
                    return new Some((Object)deploy.copy(x$9, x$10, (RouterConfig)x$7, (Scope)x$8, x$11, x$12));
                }
                throw new IllegalArgumentException(new StringBuilder(56).append("Cluster aware router can only wrap Pool or Group, got [").append(routerConfig.getClass().getName()).append("]").toString());
            }
            return some;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public ClusterDeployer(ActorSystem.Settings _settings, DynamicAccess _pm) {
        super(_settings, _pm);
    }
}

