/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DefaultDelta;
import com.xebialabs.deployit.deployment.planner.DefaultDeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.util.List;

public class DeltaSpecificationBuilder {
    private Operation operation = Operation.CREATE;
    private List<Delta> deltas = Lists.newArrayList();
    private DeployedApplication previousDeployedApplication;
    private DeployedApplication deployedApplication;
    private final boolean rollback;

    public DeltaSpecificationBuilder(boolean rollback) {
        this.rollback = rollback;
    }

    public DeltaSpecificationBuilder() {
        this(false);
    }

    public static DeltaSpecificationBuilder newSpecification() {
        return new DeltaSpecificationBuilder(false);
    }

    public static DeltaSpecificationBuilder newRollbackSpecification() {
        return new DeltaSpecificationBuilder(true);
    }

    public DeltaSpecificationBuilder create(Deployed d) {
        return this.with(Operation.CREATE, null, d);
    }

    public DeltaSpecificationBuilder modify(Deployed previous, Deployed d) {
        return this.with(Operation.MODIFY, previous, d);
    }

    public DeltaSpecificationBuilder destroy(Deployed d) {
        return this.with(Operation.DESTROY, d, null);
    }

    public DeltaSpecificationBuilder noOp(Deployed d) {
        return this.noOp(d, d);
    }

    public DeltaSpecificationBuilder noOp(Deployed previous, Deployed d) {
        return this.with(Operation.NOOP, previous, d);
    }

    private DeltaSpecificationBuilder with(Operation operation, Deployed previous, Deployed deployed) {
        this.deltas.add(new DefaultDelta(operation, previous, deployed));
        return this;
    }

    public DeltaSpecificationBuilder with(Delta delta) {
        this.deltas.add(delta);
        return this;
    }

    public DeltaSpecificationBuilder upgrade(DeployedApplication previous, DeployedApplication deployment) {
        this.previousDeployedApplication = previous;
        this.deployedApplication = deployment;
        this.operation = Operation.MODIFY;
        return this;
    }

    public DeltaSpecificationBuilder undeploy(DeployedApplication deployment) {
        this.previousDeployedApplication = deployment;
        this.deployedApplication = deployment;
        this.operation = Operation.DESTROY;
        return this;
    }

    public DeltaSpecificationBuilder initial(DeployedApplication deployment) {
        this.deployedApplication = deployment;
        this.operation = Operation.CREATE;
        return this;
    }

    public DeltaSpecification build() {
        return new DefaultDeltaSpecification(this.operation, this.previousDeployedApplication, this.deployedApplication, this.deltas, this.rollback);
    }
}

