/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.codec.base64;

import java.util.List;
import org.python.netty.buffer.ByteBuf;
import org.python.netty.channel.ChannelHandler;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.handler.codec.MessageToMessageEncoder;
import org.python.netty.handler.codec.base64.Base64;
import org.python.netty.handler.codec.base64.Base64Dialect;
import org.python.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        this.dialect = ObjectUtil.checkNotNull(dialect, "dialect");
        this.breakLines = breakLines;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg2, List<Object> out) throws Exception {
        out.add(Base64.encode(msg2, msg2.readerIndex(), msg2.readableBytes(), this.breakLines, this.dialect));
    }
}

