/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.backoff;

import java.util.function.Supplier;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.ExponentialRandomBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.backoff.Sleeper;
import org.springframework.retry.backoff.UniformRandomBackOffPolicy;

public class BackOffPolicyBuilder {
    private static final long DEFAULT_INITIAL_DELAY = 1000L;
    private Long delay = 1000L;
    private Long maxDelay;
    private Double multiplier;
    private Boolean random;
    private Sleeper sleeper;
    private Supplier<Long> delaySupplier;
    private Supplier<Long> maxDelaySupplier;
    private Supplier<Double> multiplierSupplier;
    private Supplier<Boolean> randomSupplier;

    private BackOffPolicyBuilder() {
    }

    public static BackOffPolicyBuilder newBuilder() {
        return new BackOffPolicyBuilder();
    }

    public static BackOffPolicy newDefaultPolicy() {
        return new BackOffPolicyBuilder().build();
    }

    public BackOffPolicyBuilder delay(long delay) {
        this.delay = delay;
        return this;
    }

    public BackOffPolicyBuilder maxDelay(long maxDelay) {
        this.maxDelay = maxDelay;
        return this;
    }

    public BackOffPolicyBuilder multiplier(double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public BackOffPolicyBuilder random(boolean random) {
        this.random = random;
        return this;
    }

    public BackOffPolicyBuilder sleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
        return this;
    }

    public BackOffPolicyBuilder delaySupplier(Supplier<Long> delaySupplier) {
        this.delaySupplier = delaySupplier;
        return this;
    }

    public BackOffPolicyBuilder maxDelaySupplier(Supplier<Long> maxDelaySupplier) {
        this.maxDelaySupplier = maxDelaySupplier;
        return this;
    }

    public BackOffPolicyBuilder multiplierSupplier(Supplier<Double> multiplierSupplier) {
        this.multiplierSupplier = multiplierSupplier;
        return this;
    }

    public BackOffPolicyBuilder randomSupplier(Supplier<Boolean> randomSupplier) {
        this.randomSupplier = randomSupplier;
        return this;
    }

    public BackOffPolicy build() {
        if (this.multiplier != null && this.multiplier > 0.0 || this.multiplierSupplier != null) {
            ExponentialBackOffPolicy policy = this.isRandom() ? new ExponentialRandomBackOffPolicy() : new ExponentialBackOffPolicy();
            if (this.delay != null) {
                policy.setInitialInterval(this.delay);
            }
            if (this.delaySupplier != null) {
                policy.initialIntervalSupplier(this.delaySupplier);
            }
            if (this.multiplier != null) {
                policy.setMultiplier(this.multiplier);
            }
            if (this.multiplierSupplier != null) {
                policy.multiplierSupplier(this.multiplierSupplier);
            }
            if (this.maxDelay != null && this.delay != null) {
                policy.setMaxInterval(this.maxDelay > this.delay ? this.maxDelay : 30000L);
            }
            if (this.maxDelaySupplier != null) {
                policy.maxIntervalSupplier(this.maxDelaySupplier);
            }
            if (this.sleeper != null) {
                policy.setSleeper(this.sleeper);
            }
            return policy;
        }
        if (this.maxDelay != null && this.delay != null && this.maxDelay > this.delay) {
            UniformRandomBackOffPolicy policy = new UniformRandomBackOffPolicy();
            if (this.delay != null) {
                policy.setMinBackOffPeriod(this.delay);
            }
            if (this.delaySupplier != null) {
                policy.minBackOffPeriodSupplier(this.delaySupplier);
            }
            if (this.maxDelay != null) {
                policy.setMaxBackOffPeriod(this.maxDelay);
            }
            if (this.maxDelaySupplier != null) {
                policy.maxBackOffPeriodSupplier(this.maxDelaySupplier);
            }
            if (this.sleeper != null) {
                policy.setSleeper(this.sleeper);
            }
            return policy;
        }
        FixedBackOffPolicy policy = new FixedBackOffPolicy();
        if (this.delaySupplier != null) {
            policy.backOffPeriodSupplier(this.delaySupplier);
        } else if (this.delay != null) {
            policy.setBackOffPeriod(this.delay);
        }
        if (this.sleeper != null) {
            policy.setSleeper(this.sleeper);
        }
        return policy;
    }

    private boolean isRandom() {
        return this.randomSupplier != null && Boolean.TRUE.equals(this.randomSupplier.get()) || Boolean.TRUE.equals(this.random);
    }
}

