/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault.authentication;

import java.util.function.Supplier;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.PcfAuthentication;
import org.springframework.vault.authentication.PcfAuthenticationOptions;
import org.springframework.vault.authentication.ResourceCredentialSupplier;
import org.springframework.web.client.RestOperations;

public class PcfClientAuthenticationProvider
extends SpringVaultClientAuthenticationProvider {
    public PcfClientAuthenticationProvider() {
        super(VaultEnvironmentProperties.AuthenticationMethod.PCF);
    }

    @Override
    public ClientAuthentication getClientAuthentication(VaultEnvironmentProperties vaultProperties, RestOperations vaultRestOperations, RestOperations externalRestOperations) {
        VaultEnvironmentProperties.PcfProperties pcfProperties = vaultProperties.getPcf();
        this.assertClassPresent("org.bouncycastle.crypto.signers.PSSSigner", this.missingClassForAuthMethod("BouncyCastle", "bcpkix-jdk15on", VaultEnvironmentProperties.AuthenticationMethod.PCF));
        Assert.hasText((String)pcfProperties.getRole(), (String)this.missingPropertyForAuthMethod("pcf.role", VaultEnvironmentProperties.AuthenticationMethod.PCF));
        PcfAuthenticationOptions.PcfAuthenticationOptionsBuilder builder = PcfAuthenticationOptions.builder().role(pcfProperties.getRole()).path(pcfProperties.getPcfPath());
        if (pcfProperties.getInstanceCertificate() != null) {
            builder.instanceCertificate((Supplier)new ResourceCredentialSupplier(pcfProperties.getInstanceCertificate()));
        } else {
            builder.instanceCertificate((Supplier)new ResourceCredentialSupplier(PcfClientAuthenticationProvider.resolveEnvVariable("CF_INSTANCE_CERT")));
        }
        if (pcfProperties.getInstanceKey() != null) {
            builder.instanceKey((Supplier)new ResourceCredentialSupplier(pcfProperties.getInstanceKey()));
        } else {
            builder.instanceKey((Supplier)new ResourceCredentialSupplier(PcfClientAuthenticationProvider.resolveEnvVariable("CF_INSTANCE_KEY")));
        }
        return new PcfAuthentication(builder.build(), vaultRestOperations);
    }

    private static String resolveEnvVariable(String name) {
        String value = System.getenv(name);
        if (ObjectUtils.isEmpty((Object)value)) {
            throw new IllegalStateException(String.format("Environment variable %s not set", name));
        }
        return value;
    }
}

