/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import org.springframework.security.web.webauthn.api.AuthenticatorResponse;
import org.springframework.security.web.webauthn.api.Bytes;

public final class AuthenticatorAssertionResponse
extends AuthenticatorResponse {
    private static final long serialVersionUID = 324976481675434298L;
    private final Bytes authenticatorData;
    private final Bytes signature;
    private final Bytes userHandle;
    private final Bytes attestationObject;

    private AuthenticatorAssertionResponse(Bytes clientDataJSON, Bytes authenticatorData, Bytes signature, Bytes userHandle, Bytes attestationObject) {
        super(clientDataJSON);
        this.authenticatorData = authenticatorData;
        this.signature = signature;
        this.userHandle = userHandle;
        this.attestationObject = attestationObject;
    }

    public Bytes getAuthenticatorData() {
        return this.authenticatorData;
    }

    public Bytes getSignature() {
        return this.signature;
    }

    public Bytes getUserHandle() {
        return this.userHandle;
    }

    public Bytes getAttestationObject() {
        return this.attestationObject;
    }

    public static AuthenticatorAssertionResponseBuilder builder() {
        return new AuthenticatorAssertionResponseBuilder();
    }

    public static final class AuthenticatorAssertionResponseBuilder {
        private Bytes authenticatorData;
        private Bytes signature;
        private Bytes userHandle;
        private Bytes attestationObject;
        private Bytes clientDataJSON;

        private AuthenticatorAssertionResponseBuilder() {
        }

        public AuthenticatorAssertionResponseBuilder authenticatorData(Bytes authenticatorData) {
            this.authenticatorData = authenticatorData;
            return this;
        }

        public AuthenticatorAssertionResponseBuilder signature(Bytes signature) {
            this.signature = signature;
            return this;
        }

        public AuthenticatorAssertionResponseBuilder userHandle(Bytes userHandle) {
            this.userHandle = userHandle;
            return this;
        }

        public AuthenticatorAssertionResponseBuilder attestationObject(Bytes attestationObject) {
            this.attestationObject = attestationObject;
            return this;
        }

        public AuthenticatorAssertionResponseBuilder clientDataJSON(Bytes clientDataJSON) {
            this.clientDataJSON = clientDataJSON;
            return this;
        }

        public AuthenticatorAssertionResponse build() {
            return new AuthenticatorAssertionResponse(this.clientDataJSON, this.authenticatorData, this.signature, this.userHandle, this.attestationObject);
        }
    }
}

