/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.TimerScheduler;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterRemoteWatcher$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.ActorWithLogClass;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.RemoteWatcher;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r%qA\u0002\"D\u0011\u0003\u00195J\u0002\u0004N\u0007\"\u00051I\u0014\u0005\u0006+\u0006!\ta\u0016\u0005\u00061\u0006!\t!\u0017\u0004\u0005a\u00061\u0015\u000f\u0003\u0006\u0002\n\u0011\u0011)\u001a!C\u0001\u0003\u0017A!\"a\u0005\u0005\u0005#\u0005\u000b\u0011BA\u0007\u0011)\t)\u0002\u0002BK\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003?!!\u0011#Q\u0001\n\u0005e\u0001BB+\u0005\t\u0003\t\t\u0003C\u0005\u0002,\u0011\t\t\u0011\"\u0001\u0002.!I\u00111\u0007\u0003\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003\u0017\"\u0011\u0013!C\u0001\u0003\u001bB\u0011\"!\u0015\u0005\u0003\u0003%\t%a\u0015\t\u0013\u0005\u0015D!!A\u0005\u0002\u0005\u001d\u0004\"CA8\t\u0005\u0005I\u0011AA9\u0011%\ti\bBA\u0001\n\u0003\ny\bC\u0005\u0002\u000e\u0012\t\t\u0011\"\u0001\u0002\u0010\"I\u0011\u0011\u0014\u0003\u0002\u0002\u0013\u0005\u00131\u0014\u0005\n\u0003?#\u0011\u0011!C!\u0003CC\u0011\"a)\u0005\u0003\u0003%\t%!*\t\u0013\u0005\u001dF!!A\u0005B\u0005%v!CAW\u0003\u0005\u0005\t\u0012BAX\r!\u0001\u0018!!A\t\n\u0005E\u0006BB+\u0018\t\u0003\tI\rC\u0005\u0002$^\t\t\u0011\"\u0012\u0002&\"I\u00111Z\f\u0002\u0002\u0013\u0005\u0015Q\u001a\u0005\n\u0003'<\u0012\u0011!CA\u0003+D\u0011\"a:\u0018\u0003\u0003%I!!;\u0007\r5\u001b\u0005aQAy\u0011!\tWD!A!\u0002\u0013\u0011\u0007BCA\u0000;\t\u0005\t\u0015!\u0003\u0003\u0002!Q!\u0011C\u000f\u0003\u0002\u0003\u0006IA!\u0001\t\u0015\tMQD!A!\u0002\u0013\u0011\t\u0001\u0003\u0004V;\u0011\u0005!Q\u0003\u0005\n\u0005Ci\"\u0019!C\u0005\u0005GA\u0001B!\n\u001eA\u0003%\u0011\u0011\u0013\u0005\t\tv\u0011\r\u0011\"\u0001\u0003(!A!qF\u000f!\u0002\u0013\u0011I\u0003C\u0005\u00032u\u0011\r\u0011\"\u0011\u00034!A!\u0011I\u000f!\u0002\u0013\u0011)\u0004C\u0005\u0003Du\u0011\r\u0011\"\u0003\u0003F!A!1K\u000f!\u0002\u0013\u00119\u0005C\u0005\u0003Vu\u0001\r\u0011\"\u0003\u0003X!I!QN\u000fA\u0002\u0013%!q\u000e\u0005\t\u0005sj\u0002\u0015)\u0003\u0003Z!I!1P\u000fA\u0002\u0013\u0005!Q\u0010\u0005\n\u0005\u0003k\u0002\u0019!C\u0001\u0005\u0007C\u0001Ba\"\u001eA\u0003&!q\u0010\u0005\n\u0005\u0013k\u0002\u0019!C\u0001\u0005/B\u0011Ba#\u001e\u0001\u0004%\tA!$\t\u0011\tEU\u0004)Q\u0005\u00053BqAa%\u001e\t\u0003\u0012)\nC\u0004\u0003\u0018v!\tE!&\t\u000f\teU\u0004\"\u0011\u0003\u001c\"9!\u0011V\u000f\u0005\u0002\t-\u0006b\u0002B];\u0011%!1\u0018\u0005\b\u0005\u007fkB\u0011\u0001Ba\u0011\u001d\u0011)-\bC\u0001\u0005\u000fDqA!4\u001e\t\u0003\u0011y\rC\u0004\u0003Vv!\tAa6\t\u000f\tuW\u0004\"\u0011\u0003`\"9!q^\u000f\u0005B\tE\bb\u0002B{;\u0011E#q\u001f\u0005\b\u0005wlB\u0011\u0002B\u007f\u0011\u001d\u0019\t!\bC\u0001\u0007\u0007\tAc\u00117vgR,'OU3n_R,w+\u0019;dQ\u0016\u0014(B\u0001#F\u0003\u001d\u0019G.^:uKJT!AR$\u0002\u000bA,7n[8\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'o\u001a\t\u0003\u0019\u0006i\u0011a\u0011\u0002\u0015\u00072,8\u000f^3s%\u0016lw\u000e^3XCR\u001c\u0007.\u001a:\u0014\u0005\u0005y\u0005C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005Y\u0015!\u00029s_B\u001cHc\u0001.aWB\u00111LX\u0007\u00029*\u0011Q,R\u0001\u0006C\u000e$xN]\u0005\u0003?r\u0013Q\u0001\u0015:paNDQ!Y\u0002A\u0002\t\fqBZ1jYV\u0014X\rR3uK\u000e$xN\u001d\t\u0004G\u001aDW\"\u00013\u000b\u0005\u0015,\u0015A\u0002:f[>$X-\u0003\u0002hI\n9b)Y5mkJ,G)\u001a;fGR|'OU3hSN$(/\u001f\t\u00037&L!A\u001b/\u0003\u000f\u0005#GM]3tg\")An\u0001a\u0001[\u0006A1/\u001a;uS:<7\u000f\u0005\u0002d]&\u0011q\u000e\u001a\u0002\u000f%\u0016lw\u000e^3TKR$\u0018N\\4t\u0005E!U\r\\1zK\u0012\fV/\u0019:b]RLg.Z\n\u0006\t=\u0013X\u000f\u001f\t\u00037NL!\u0001\u001e/\u0003C9{7+\u001a:jC2L'0\u0019;j_:4VM]5gS\u000e\fG/[8o\u001d\u0016,G-\u001a3\u0011\u0005A3\u0018BA<R\u0005\u001d\u0001&o\u001c3vGR\u00042!_A\u0002\u001d\tQxP\u0004\u0002|}6\tAP\u0003\u0002~-\u00061AH]8pizJ\u0011AU\u0005\u0004\u0003\u0003\t\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\t9A\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002\u0002E\u000b\u0011!\\\u000b\u0003\u0003\u001b\u00012\u0001TA\b\u0013\r\t\tb\u0011\u0002\u0007\u001b\u0016l'-\u001a:\u0002\u00055\u0004\u0013A\u00049sKZLw.^:Ti\u0006$Xo]\u000b\u0003\u00033\u00012\u0001TA\u000e\u0013\r\tib\u0011\u0002\r\u001b\u0016l'-\u001a:Ti\u0006$Xo]\u0001\u0010aJ,g/[8vgN#\u0018\r^;tAQ1\u00111EA\u0014\u0003S\u00012!!\n\u0005\u001b\u0005\t\u0001bBA\u0005\u0013\u0001\u0007\u0011Q\u0002\u0005\b\u0003+I\u0001\u0019AA\r\u0003\u0011\u0019w\u000e]=\u0015\r\u0005\r\u0012qFA\u0019\u0011%\tIA\u0003I\u0001\u0002\u0004\ti\u0001C\u0005\u0002\u0016)\u0001\n\u00111\u0001\u0002\u001a\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u001cU\u0011\ti!!\u000f,\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0012R\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\nyDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002P)\"\u0011\u0011DA\u001d\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0013\u0001\u00026bm\u0006LA!a\u0019\u0002Z\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001b\u0011\u0007A\u000bY'C\u0002\u0002nE\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001d\u0002zA\u0019\u0001+!\u001e\n\u0007\u0005]\u0014KA\u0002B]fD\u0011\"a\u001f\u0010\u0003\u0003\u0005\r!!\u001b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\t\u0005\u0004\u0002\u0004\u0006%\u00151O\u0007\u0003\u0003\u000bS1!a\"R\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAI\u0003/\u00032\u0001UAJ\u0013\r\t)*\u0015\u0002\b\u0005>|G.Z1o\u0011%\tY(EA\u0001\u0002\u0004\t\u0019(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA+\u0003;C\u0011\"a\u001f\u0013\u0003\u0003\u0005\r!!\u001b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u001b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0016\u0002\r\u0015\fX/\u00197t)\u0011\t\t*a+\t\u0013\u0005mT#!AA\u0002\u0005M\u0014!\u0005#fY\u0006LX\rZ)vCJ\fg\u000e^5oKB\u0019\u0011QE\f\u0014\u000b]\t\u0019,a0\u0011\u0015\u0005U\u00161XA\u0007\u00033\t\u0019#\u0004\u0002\u00028*\u0019\u0011\u0011X)\u0002\u000fI,h\u000e^5nK&!\u0011QXA\\\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*!\u0011QYA/\u0003\tIw.\u0003\u0003\u0002\u0006\u0005\rGCAAX\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\u0019#a4\u0002R\"9\u0011\u0011\u0002\u000eA\u0002\u00055\u0001bBA\u000b5\u0001\u0007\u0011\u0011D\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9.a9\u0011\u000bA\u000bI.!8\n\u0007\u0005m\u0017K\u0001\u0004PaRLwN\u001c\t\b!\u0006}\u0017QBA\r\u0013\r\t\t/\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005\u00158$!AA\u0002\u0005\r\u0012a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u001e\t\u0005\u0003/\ni/\u0003\u0003\u0002p\u0006e#AB(cU\u0016\u001cGoE\u0003\u001e\u0003g\fI\u0010E\u0002d\u0003kL1!a>e\u00055\u0011V-\\8uK^\u000bGo\u00195feB\u00191,a?\n\u0007\u0005uHL\u0001\u0004US6,'o]\u0001\u0012Q\u0016\f'\u000f\u001e2fCRLe\u000e^3sm\u0006d\u0007\u0003\u0002B\u0002\u0005\u001bi!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\tIV\u0014\u0018\r^5p]*\u0019!1B)\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0003\u0010\t\u0015!A\u0004$j]&$X\rR;sCRLwN\\\u0001\u001ak:\u0014X-Y2iC\ndWMU3ba\u0016\u0014\u0018J\u001c;feZ\fG.\u0001\u0010iK\u0006\u0014HOY3bi\u0016C\b/Z2uK\u0012\u0014Vm\u001d9p]N,\u0017I\u001a;feRQ!q\u0003B\r\u00057\u0011iBa\b\u0011\u00051k\u0002\"B1#\u0001\u0004\u0011\u0007bBA\u0000E\u0001\u0007!\u0011\u0001\u0005\b\u0005#\u0011\u0003\u0019\u0001B\u0001\u0011\u001d\u0011\u0019B\ta\u0001\u0005\u0003\tQ\"\u0019:uKJLXI\\1cY\u0016$WCAAI\u00039\t'\u000f^3ss\u0016s\u0017M\u00197fI\u0002*\"A!\u000b\u0011\u00071\u0013Y#C\u0002\u0003.\r\u0013qa\u00117vgR,'/\u0001\u0005dYV\u001cH/\u001a:!\u0003\rawnZ\u000b\u0003\u0005k\u0001BAa\u000e\u0003>5\u0011!\u0011\b\u0006\u0004\u0005w)\u0015!B3wK:$\u0018\u0002\u0002B \u0005s\u0011a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013AE<bi\u000eD\u0007+\u0019;i\u00032dwn\u001e'jgR,\"Aa\u0012\u0011\r\t%#qJA+\u001b\t\u0011YE\u0003\u0003\u0003N\u0005\u0015\u0015!C5n[V$\u0018M\u00197f\u0013\u0011\u0011\tFa\u0013\u0003\u0007M+G/A\nxCR\u001c\u0007\u000eU1uQ\u0006cGn\\<MSN$\b%\u0001\rqK:$\u0017N\\4EK2\f\u00170\u001a3Rk\u0006\u0014\u0018M\u001c;j]\u0016,\"A!\u0017\u0011\r\tm#1\rB4\u001d\u0011\u0011iFa\u0018\u0011\u0005m\f\u0016b\u0001B1#\u00061\u0001K]3eK\u001aLAA!\u0015\u0003f)\u0019!\u0011M)\u0011\u00071\u0013I'C\u0002\u0003l\r\u0013Q\"\u00168jcV,\u0017\t\u001a3sKN\u001c\u0018\u0001\b9f]\u0012Lgn\u001a#fY\u0006LX\rZ)vCJ\fg\u000e^5oK~#S-\u001d\u000b\u0005\u0005c\u00129\bE\u0002Q\u0005gJ1A!\u001eR\u0005\u0011)f.\u001b;\t\u0013\u0005mD&!AA\u0002\te\u0013!\u00079f]\u0012Lgn\u001a#fY\u0006LX\rZ)vCJ\fg\u000e^5oK\u0002\nAb\u00197vgR,'OT8eKN,\"Aa \u0011\u000b\tm#1\r5\u0002!\rdWo\u001d;fe:{G-Z:`I\u0015\fH\u0003\u0002B9\u0005\u000bC\u0011\"a\u001f0\u0003\u0003\u0005\rAa \u0002\u001b\rdWo\u001d;fe:{G-Z:!\u0003AiW-\u001c2feR{WNY:u_:,7/\u0001\u000bnK6\u0014WM\u001d+p[\n\u001cHo\u001c8fg~#S-\u001d\u000b\u0005\u0005c\u0012y\tC\u0005\u0002|I\n\t\u00111\u0001\u0003Z\u0005\tR.Z7cKJ$v.\u001c2ti>tWm\u001d\u0011\u0002\u0011A\u0014Xm\u0015;beR$\"A!\u001d\u0002\u0011A|7\u000f^*u_B\fqA]3dK&4X-\u0006\u0002\u0003\u001eB!!q\u0014BQ\u001b\u0005i\u0012\u0002\u0002BR\u0005K\u0013qAU3dK&4X-C\u0002\u0003(r\u0013Q!Q2u_J\f1C]3dK&4Xm\u00117vgR,'/\u0012<f]R,\"A!,\u0011\t\t=&Q\u0017\b\u00047\nE\u0016b\u0001BZ9\u0006)\u0011i\u0019;pe&!!1\u0015B\\\u0015\r\u0011\u0019\fX\u0001\r[\u0016l'-\u001a:K_&tW\r\u001a\u000b\u0005\u0005c\u0012i\fC\u0004\u0002\na\u0002\r!!\u0004\u0002\u00115,WNY3s+B$BA!\u001d\u0003D\"9\u0011\u0011B\u001dA\u0002\u00055\u0011!D7f[\n,'OU3n_Z,G\r\u0006\u0004\u0003r\t%'1\u001a\u0005\b\u0003\u0013Q\u0004\u0019AA\u0007\u0011\u001d\t)B\u000fa\u0001\u00033\t\u0001$];be\u0006tG/\u001b8f\u001f2$\u0017J\\2be:\fG/[8o)\u0011\u0011\tH!5\t\u000f\tM7\b1\u0001\u0002\u000e\u0005qa.Z<J]\u000e\f'O\\1uS>t\u0017!\u00053fY\u0006LX\rZ)vCJ\fg\u000e^5oKR1!\u0011\u000fBm\u00057Dq!!\u0003=\u0001\u0004\ti\u0001C\u0004\u0002\u0016q\u0002\r!!\u0007\u0002\u0011\u0005$GmV1uG\"$bA!\u001d\u0003b\n-\bb\u0002Br{\u0001\u0007!Q]\u0001\bo\u0006$8\r[3f!\rY&q]\u0005\u0004\u0005Sd&\u0001E%oi\u0016\u0014h.\u00197BGR|'OU3g\u0011\u001d\u0011i/\u0010a\u0001\u0005K\fqa^1uG\",'/A\u0005xCR\u001c\u0007NT8eKR!!\u0011\u000fBz\u0011\u001d\u0011\u0019O\u0010a\u0001\u0005K\f1b\u001d5pk2$w+\u0019;dQR!\u0011\u0011\u0013B}\u0011\u001d\u0011\u0019o\u0010a\u0001\u0005K\fA$[:XCR\u001c\u0007nT;ug&$Wm\u00117vgR,'/\u00117m_^,G\r\u0006\u0003\u0002\u0012\n}\bb\u0002Br\u0001\u0002\u0007!Q]\u0001\u0017i\u0006\\Wm\u0014<feJ+7\u000f]8og&\u0014\u0017\u000e\\5usR!!\u0011OB\u0003\u0011\u0019\u00199!\u0011a\u0001Q\u00069\u0011\r\u001a3sKN\u001c\b")
public class ClusterRemoteWatcher
extends RemoteWatcher
implements Timers {
    private final boolean arteryEnabled;
    private final Cluster cluster;
    private final LoggingAdapter log;
    private final Set<String> watchPathAllowList;
    private Set<UniqueAddress> pendingDelayedQuarantine;
    private Set<Address> clusterNodes;
    private Set<UniqueAddress> memberTombstones;
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;

    public static Props props(FailureDetectorRegistry<Address> failureDetector, RemoteSettings settings) {
        return ClusterRemoteWatcher$.MODULE$.props(failureDetector, settings);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive2, (Object)msg);
    }

    public final TimerScheduler timers() {
        return Timers.timers$((Timers)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Timers.aroundPreRestart$((Timers)this, (Throwable)reason, message);
    }

    public void aroundPostStop() {
        Timers.aroundPostStop$((Timers)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Timers.aroundReceive$((Timers)this, receive2, (Object)msg);
    }

    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    public final void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$1) {
        this.org$apache$pekko$actor$Timers$$_timers = x$1;
    }

    private boolean arteryEnabled() {
        return this.arteryEnabled;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private Set<String> watchPathAllowList() {
        return this.watchPathAllowList;
    }

    private Set<UniqueAddress> pendingDelayedQuarantine() {
        return this.pendingDelayedQuarantine;
    }

    private void pendingDelayedQuarantine_$eq(Set<UniqueAddress> x$1) {
        this.pendingDelayedQuarantine = x$1;
    }

    public Set<Address> clusterNodes() {
        return this.clusterNodes;
    }

    public void clusterNodes_$eq(Set<Address> x$1) {
        this.clusterNodes = x$1;
    }

    public Set<UniqueAddress> memberTombstones() {
        return this.memberTombstones;
    }

    public void memberTombstones_$eq(Set<UniqueAddress> x$1) {
        this.memberTombstones = x$1;
    }

    public void preStart() {
        Actor.preStart$((Actor)this);
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.MemberTombstonesChanged.class}));
    }

    public void postStop() {
        super.postStop();
        this.cluster().unsubscribe(this.self());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.receiveClusterEvent().orElse(super.receive());
    }

    public PartialFunction<Object, BoxedUnit> receiveClusterEvent() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterRemoteWatcher $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.clusterNodes_$eq((Set<Address>)((Set)currentClusterState.members().collect((PartialFunction)new Serializable(this){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$receiveClusterEvent$1 $outer;

                        public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Address address = A1.address();
                            Address address2 = this.$outer.org$apache$pekko$cluster$ClusterRemoteWatcher$$anonfun$$$outer().cluster().selfAddress();
                            if (address == null ? address2 != null : !address.equals(address2)) {
                                return (B1)A1.address();
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Member x1) {
                            Member member = x1;
                            Address address = member.address();
                            Address address2 = this.$outer.org$apache$pekko$cluster$ClusterRemoteWatcher$$anonfun$$$outer().cluster().selfAddress();
                            return address == null ? address2 != null : !address.equals(address2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Address$.MODULE$.addressOrdering())));
                    this.$outer.clusterNodes().foreach((Function1 & Serializable)address -> {
                        $anonfun$receiveClusterEvent$1.$anonfun$applyOrElse$2(this, address);
                        return BoxedUnit.UNIT;
                    });
                    this.$outer.unreachable_$eq((Set)this.$outer.unreachable().diff(this.$outer.clusterNodes()));
                    this.$outer.memberTombstones_$eq(currentClusterState.memberTombstones());
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberJoined) {
                    ClusterEvent.MemberJoined memberJoined = (ClusterEvent.MemberJoined)A1;
                    Member m = memberJoined.member();
                    this.$outer.org$apache$pekko$cluster$ClusterRemoteWatcher$$memberJoined(m);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberUp) {
                    ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)A1;
                    Member m = memberUp.member();
                    this.$outer.memberUp(m);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberWeaklyUp) {
                    ClusterEvent.MemberWeaklyUp memberWeaklyUp = (ClusterEvent.MemberWeaklyUp)A1;
                    Member m = memberWeaklyUp.member();
                    this.$outer.memberUp(m);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    MemberStatus previousStatus = memberRemoved.previousStatus();
                    this.$outer.memberRemoved(m, previousStatus);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberTombstonesChanged) {
                    ClusterEvent.MemberTombstonesChanged memberTombstonesChanged = (ClusterEvent.MemberTombstonesChanged)A1;
                    Set<UniqueAddress> tombstones = memberTombstonesChanged.tombstones();
                    this.$outer.memberTombstones_$eq(tombstones);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof DelayedQuarantine) {
                    DelayedQuarantine delayedQuarantine = (DelayedQuarantine)A1;
                    Member m = delayedQuarantine.m();
                    MemberStatus previousStatus = delayedQuarantine.previousStatus();
                    this.$outer.delayedQuarantine(m, previousStatus);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberJoined) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberWeaklyUp) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberTombstonesChanged) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                return object instanceof DelayedQuarantine;
            }

            public /* synthetic */ ClusterRemoteWatcher org$apache$pekko$cluster$ClusterRemoteWatcher$$anonfun$$$outer() {
                return this.$outer;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$receiveClusterEvent$1 $this, Address address) {
                $this.$outer.takeOverResponsibility(address);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2$adapted(org.apache.pekko.cluster.ClusterRemoteWatcher$$anonfun$receiveClusterEvent$1 org.apache.pekko.actor.Address )}, serializedLambda);
            }
        };
    }

    public void org$apache$pekko$cluster$ClusterRemoteWatcher$$memberJoined(Member m) {
        Address address = m.address();
        Address address2 = this.cluster().selfAddress();
        if (address == null ? address2 != null : !address.equals(address2)) {
            this.quarantineOldIncarnation(m);
            return;
        }
    }

    public void memberUp(Member m) {
        Address address = m.address();
        Address address2 = this.cluster().selfAddress();
        if (address == null ? address2 != null : !address.equals(address2)) {
            this.quarantineOldIncarnation(m);
            this.clusterNodes_$eq((Set<Address>)((Set)this.clusterNodes().$plus((Object)m.address())));
            this.takeOverResponsibility(m.address());
            this.unreachable_$eq((Set)this.unreachable().$minus((Object)m.address()));
            return;
        }
    }

    public void memberRemoved(Member m, MemberStatus previousStatus) {
        Address address = m.address();
        Address address2 = this.cluster().selfAddress();
        if (address == null ? address2 != null : !address.equals(address2)) {
            BoxedUnit boxedUnit;
            this.clusterNodes_$eq((Set<Address>)((Set)this.clusterNodes().$minus((Object)m.address())));
            MemberStatus memberStatus = previousStatus;
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                this.quarantine(m.address(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)m.uniqueAddress().longUid())), new StringBuilder(42).append("Cluster member removed, previous status [").append(previousStatus).append("]").toString(), false);
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.arteryEnabled()) {
                this.pendingDelayedQuarantine_$eq((Set<UniqueAddress>)((Set)this.pendingDelayedQuarantine().$plus((Object)m.uniqueAddress())));
                boxedUnit = this.context().system().scheduler().scheduleOnce(this.cluster().settings().QuarantineRemovedNodeAfter(), this.self(), (Object)new DelayedQuarantine(m, previousStatus), (ExecutionContext)this.context().dispatcher(), this.self());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.publishAddressTerminated(m.address());
            return;
        }
    }

    public void quarantineOldIncarnation(Member newIncarnation) {
        if (this.pendingDelayedQuarantine().nonEmpty()) {
            this.pendingDelayedQuarantine().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterRemoteWatcher.$anonfun$quarantineOldIncarnation$1(newIncarnation, x$1))).foreach((Function1 & Serializable)oldIncarnation -> {
                ClusterRemoteWatcher.$anonfun$quarantineOldIncarnation$2(this, oldIncarnation);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void delayedQuarantine(Member m, MemberStatus previousStatus) {
        if (this.pendingDelayedQuarantine().apply((Object)m.uniqueAddress())) {
            this.pendingDelayedQuarantine_$eq((Set<UniqueAddress>)((Set)this.pendingDelayedQuarantine().$minus((Object)m.uniqueAddress())));
            this.quarantine(m.address(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)m.uniqueAddress().longUid())), new StringBuilder(42).append("Cluster member removed, previous status [").append(previousStatus).append("]").toString(), true);
            return;
        }
    }

    public void addWatch(InternalActorRef watchee, InternalActorRef watcher) {
        Address watcheeNode = watchee.path().address();
        if (!this.clusterNodes().contains((Object)watcheeNode) && this.memberTombstones().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterRemoteWatcher.$anonfun$addWatch$1(watcheeNode, x$2)))) {
            this.log().debug("Death watch for [{}] triggered immediately because member was removed from cluster", (Object)watchee);
            watcher.sendSystemMessage((SystemMessage)new DeathWatchNotification((ActorRef)watchee, false, true));
            return;
        }
        super.addWatch(watchee, watcher);
    }

    public void watchNode(InternalActorRef watchee) {
        if (!this.clusterNodes().apply((Object)watchee.path().address())) {
            super.watchNode(watchee);
            return;
        }
    }

    public boolean shouldWatch(InternalActorRef watchee) {
        return this.clusterNodes().apply((Object)watchee.path().address()) || super.shouldWatch(watchee) || this.isWatchOutsideClusterAllowed(watchee);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWatchOutsideClusterAllowed(InternalActorRef watchee) {
        String string = this.context().system().name();
        String string2 = watchee.path().address().system();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String pathPrefix = ((IterableOnceOps)watchee.path().elements().take(2)).mkString("/", "/", "/");
        if (!this.watchPathAllowList().contains((Object)pathPrefix)) return false;
        return true;
    }

    public void takeOverResponsibility(Address address) {
        if (this.watchingNodes().apply((Object)address)) {
            this.log().debug("Cluster is taking over responsibility of node: [{}]", (Object)address);
            this.unwatchNode(address);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$quarantineOldIncarnation$1(Member newIncarnation$1, UniqueAddress x$1) {
        Address address = x$1.address();
        Address address2 = newIncarnation$1.address();
        return !(address != null ? !address.equals(address2) : address2 != null);
    }

    public static final /* synthetic */ void $anonfun$quarantineOldIncarnation$2(ClusterRemoteWatcher $this, UniqueAddress oldIncarnation) {
        $this.pendingDelayedQuarantine_$eq((Set<UniqueAddress>)((Set)$this.pendingDelayedQuarantine().$minus((Object)oldIncarnation)));
        $this.quarantine(oldIncarnation.address(), (Option)new Some((Object)BoxesRunTime.boxToLong((long)oldIncarnation.longUid())), "Cluster member removed, new incarnation joined", true);
    }

    public static final /* synthetic */ boolean $anonfun$addWatch$1(Address watcheeNode$1, UniqueAddress x$2) {
        Address address = x$2.address();
        Address address2 = watcheeNode$1;
        return !(address != null ? !address.equals(address2) : address2 != null);
    }

    public ClusterRemoteWatcher(FailureDetectorRegistry<Address> failureDetector, FiniteDuration heartbeatInterval, FiniteDuration unreachableReaperInterval, FiniteDuration heartbeatExpectedResponseAfter) {
        super(failureDetector, heartbeatInterval, unreachableReaperInterval, heartbeatExpectedResponseAfter);
        Timers.$init$((Timers)this);
        this.arteryEnabled = ((RARP)RARP$.MODULE$.apply(this.context().system())).provider().remoteSettings().Artery().Enabled();
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.log = Logging$.MODULE$.apply(this.context().system(), (Object)new ActorWithLogClass((Actor)this, ClusterLogClass$.MODULE$.ClusterCore()), LogSource$.MODULE$.fromActorWithLoggerClass());
        this.watchPathAllowList = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/system/sharding/"}));
        this.pendingDelayedQuarantine = Predef$.MODULE$.Set().empty();
        this.clusterNodes = Predef$.MODULE$.Set().empty();
        this.memberTombstones = Predef$.MODULE$.Set().empty();
        Statics.releaseFence();
    }

    private static final class DelayedQuarantine
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Member m;
        private final MemberStatus previousStatus;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Member m() {
            return this.m;
        }

        public MemberStatus previousStatus() {
            return this.previousStatus;
        }

        public DelayedQuarantine copy(Member m, MemberStatus previousStatus) {
            return new DelayedQuarantine(m, previousStatus);
        }

        public Member copy$default$1() {
            return this.m();
        }

        public MemberStatus copy$default$2() {
            return this.previousStatus();
        }

        public String productPrefix() {
            return "DelayedQuarantine";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.m();
                }
                case 1: {
                    return this.previousStatus();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedQuarantine;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "m";
                }
                case 1: {
                    return "previousStatus";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DelayedQuarantine)) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedQuarantine delayedQuarantine = (DelayedQuarantine)x$1;
            Member member = this.m();
            Member member2 = delayedQuarantine.m();
            if (member == null) {
                if (member2 != null) {
                    return false;
                }
            } else if (!((Object)member).equals(member2)) return false;
            MemberStatus memberStatus = this.previousStatus();
            MemberStatus memberStatus2 = delayedQuarantine.previousStatus();
            if (memberStatus == null) {
                if (memberStatus2 == null) return true;
                return false;
            } else {
                if (!memberStatus.equals(memberStatus2)) return false;
                return true;
            }
        }

        public DelayedQuarantine(Member m, MemberStatus previousStatus) {
            this.m = m;
            this.previousStatus = previousStatus;
            Product.$init$((Product)this);
        }
    }
}

