/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.ws.FrameData;
import org.apache.pekko.http.impl.engine.ws.FrameEvent;
import org.apache.pekko.http.impl.engine.ws.FrameEventRenderer$;
import org.apache.pekko.http.impl.engine.ws.FrameHeader;
import org.apache.pekko.http.impl.engine.ws.FrameStart;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r4Qa\u0003\u0007\u0003%iAQ!\r\u0001\u0005\u0002MBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004;\u0001\u0001\u0006Ia\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0001\u0005\u0001)A\u0005{!9\u0011\t\u0001b\u0001\n\u0003\u0012\u0005BB\"\u0001A\u0003%1\u0005C\u0003E\u0001\u0011\u0005S\tC\u0003O\u0001\u0011%q\nC\u0003V\u0001\u0011%aK\u0001\nGe\u0006lW-\u0012<f]R\u0014VM\u001c3fe\u0016\u0014(BA\u0007\u000f\u0003\t98O\u0003\u0002\u0010!\u00051QM\\4j]\u0016T!!\u0005\n\u0002\t%l\u0007\u000f\u001c\u0006\u0003'Q\tA\u0001\u001b;ua*\u0011QCF\u0001\u0006a\u0016\\7n\u001c\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0005\u0002\u00017A\u0019A$I\u0012\u000e\u0003uQ!AH\u0010\u0002\u000bM$\u0018mZ3\u000b\u0005\u0001\"\u0012AB:ue\u0016\fW.\u0003\u0002#;\tQqI]1qQN#\u0018mZ3\u0011\t\u0011*seK\u0007\u0002?%\u0011ae\b\u0002\n\r2|wo\u00155ba\u0016\u0004\"\u0001K\u0015\u000e\u00031I!A\u000b\u0007\u0003\u0015\u0019\u0013\u0018-\\3Fm\u0016tG\u000f\u0005\u0002-_5\tQF\u0003\u0002/)\u0005!Q\u000f^5m\u0013\t\u0001TF\u0001\u0006CsR,7\u000b\u001e:j]\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002iA\u0011\u0001\u0006A\u0001\u0003S:,\u0012a\u000e\t\u0004Ia:\u0013BA\u001d \u0005\u0015Ie\u000e\\3u\u0003\rIg\u000eI\u0001\u0004_V$X#A\u001f\u0011\u0007\u0011r4&\u0003\u0002@?\t1q*\u001e;mKR\fAa\\;uA\u0005)1\u000f[1qKV\t1%\u0001\u0004tQ\u0006\u0004X\rI\u0001\fGJ,\u0017\r^3M_\u001eL7\r\u0006\u0002G\u0013B\u0011AdR\u0005\u0003\u0011v\u0011qb\u0012:ba\"\u001cF/Y4f\u0019><\u0017n\u0019\u0005\u0006\u0015\"\u0001\raS\u0001\u0014S:DWM]5uK\u0012\fE\u000f\u001e:jEV$Xm\u001d\t\u0003I1K!!T\u0010\u0003\u0015\u0005#HO]5ckR,7/A\u0006sK:$WM]*uCJ$HCA\u0016Q\u0011\u0015\t\u0016\u00021\u0001S\u0003\u0015\u0019H/\u0019:u!\tA3+\u0003\u0002U\u0019\tQaI]1nKN#\u0018M\u001d;\u0002\u0019I,g\u000eZ3s\u0011\u0016\fG-\u001a:\u0015\u0005-:\u0006\"\u0002-\u000b\u0001\u0004I\u0016A\u00025fC\u0012,'\u000f\u0005\u0002)5&\u00111\f\u0004\u0002\f\rJ\fW.\u001a%fC\u0012,'\u000f\u000b\u0002\u0001;B\u0011a,Y\u0007\u0002?*\u0011\u0001\rF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00012`\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public final class FrameEventRenderer
extends GraphStage<FlowShape<FrameEvent, ByteString>> {
    private final Inlet<FrameEvent> in = Inlet$.MODULE$.apply("FrameEventRenderer.in");
    private final Outlet<ByteString> out = Outlet$.MODULE$.apply("FrameEventRenderer.out");
    private final FlowShape<FrameEvent, ByteString> shape = new FlowShape(this.in(), this.out());

    public Inlet<FrameEvent> in() {
        return this.in;
    }

    public Outlet<ByteString> out() {
        return this.out;
    }

    public FlowShape<FrameEvent, ByteString> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new GraphStageLogic(this){
            private final InHandler Initial;
            private final /* synthetic */ FrameEventRenderer $outer;

            private InHandler Initial() {
                return this.Initial;
            }

            public InHandler org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$renderData(long initialRemaining, InHandler nextState) {
                return new InHandler(this, initialRemaining, nextState){
                    private long remaining;
                    private final /* synthetic */ $anon$1 $outer;
                    private final InHandler nextState$1;

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    private long remaining() {
                        return this.remaining;
                    }

                    private void remaining_$eq(long x$1) {
                        this.remaining = x$1;
                    }

                    public void onPush() {
                        FrameEvent frameEvent = (FrameEvent)this.$outer.grab(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                        if (frameEvent instanceof FrameData) {
                            FrameData frameData = (FrameData)frameEvent;
                            ByteString data = frameData.data();
                            boolean lastPart = frameData.lastPart();
                            if ((long)data.size() > this.remaining()) {
                                throw new IllegalStateException(new StringBuilder(30).append("Expected ").append(this.remaining()).append(" frame bytes but got ").append(data.size()).toString());
                            }
                            if ((long)data.size() == this.remaining()) {
                                if (!lastPart) {
                                    throw new IllegalStateException("Frame data complete but `lastPart` flag not set");
                                }
                                this.$outer.setHandler(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in(), this.nextState$1);
                                this.$outer.push(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), data);
                                return;
                            }
                            this.remaining_$eq(this.remaining() - (long)data.size());
                            this.$outer.push(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), data);
                            return;
                        }
                        if (frameEvent instanceof FrameStart) {
                            this.$outer.fail(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), new IllegalStateException("unexpected FrameStart (need more FrameData first)"));
                            return;
                        }
                        throw new MatchError((Object)frameEvent);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nextState$1 = nextState$1;
                        InHandler.$init$((InHandler)this);
                        this.remaining = initialRemaining$1;
                    }
                };
            }

            public /* synthetic */ FrameEventRenderer org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                this.Initial = new InHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onUpstreamFinish() throws Exception {
                        InHandler.onUpstreamFinish$((InHandler)this);
                    }

                    public void onUpstreamFailure(Throwable ex) throws Exception {
                        InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
                    }

                    public void onPush() {
                        FrameEvent frameEvent = (FrameEvent)this.$outer.grab(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                        if (frameEvent instanceof FrameStart) {
                            FrameStart frameStart = (FrameStart)frameEvent;
                            FrameHeader header = frameStart.header();
                            ByteString data = frameStart.data();
                            Predef$.MODULE$.require(header.length() >= (long)data.size());
                            if (!frameStart.lastPart() && header.length() > 0L) {
                                this.$outer.setHandler(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in(), this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$renderData(header.length() - (long)data.length(), this));
                            }
                            this.$outer.push(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$renderStart(frameStart));
                            return;
                        }
                        if (frameEvent instanceof FrameData) {
                            this.$outer.fail(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().out(), new IllegalStateException("unexpected FrameData (need FrameStart first)"));
                            return;
                        }
                        throw new MatchError((Object)frameEvent);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        InHandler.$init$((InHandler)this);
                    }
                };
                this.setHandler($outer.in(), this.Initial());
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$1 $outer;

                    public void onDownstreamFinish() throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this);
                    }

                    public void onDownstreamFinish(Throwable cause) throws Exception {
                        OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
                    }

                    public void onPull() {
                        this.$outer.pull(this.$outer.org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$anon$$$outer().in());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        OutHandler.$init$((OutHandler)this);
                    }
                });
            }
        };
    }

    public ByteString org$apache$pekko$http$impl$engine$ws$FrameEventRenderer$$renderStart(FrameStart start) {
        return this.renderHeader(start.header()).$plus$plus(start.data());
    }

    private ByteString renderHeader(FrameHeader header) {
        Tuple2.mcII.sp sp2;
        long length = header.length();
        long l = length;
        Tuple2.mcII.sp sp3 = l < 126L ? new Tuple2.mcII.sp((int)l, 0) : (sp2 = l <= 65535L ? new Tuple2.mcII.sp(126, 2) : new Tuple2.mcII.sp(127, 8));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int lengthBits = sp2._1$mcI$sp();
        int extraLengthBytes = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(lengthBits, extraLengthBytes);
        int lengthBits2 = sp4._1$mcI$sp();
        int extraLengthBytes2 = sp4._2$mcI$sp();
        int maskBytes = header.mask().isDefined() ? 4 : 0;
        int totalSize = 2 + extraLengthBytes2 + maskBytes;
        byte[] data = new byte[totalSize];
        int flags = FrameEventRenderer.bool$1(header.fin(), 128) | FrameEventRenderer.bool$1(header.rsv1(), 64) | FrameEventRenderer.bool$1(header.rsv2(), 32) | FrameEventRenderer.bool$1(header.rsv3(), 16);
        data[0] = (byte)(flags | header.opcode().code());
        data[1] = (byte)(FrameEventRenderer.bool$1(header.mask().isDefined(), 128) | lengthBits2);
        int n = extraLengthBytes2;
        switch (n) {
            case 0: {
                break;
            }
            case 2: {
                data[2] = (byte)((length & 0xFF00L) >> 8);
                data[3] = (byte)((length & 0xFFL) >> 0);
                break;
            }
            case 8: {
                this.addLongBytes$1(Long.rotateLeft(length, 8), 0, data);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        int maskOffset = 2 + extraLengthBytes2;
        header.mask().foreach((Function1)(JFunction1.mcVI.sp & Serializable)mask -> {
            data$1[maskOffset$1 + 0] = (byte)((mask & 0xFF000000) >> 24);
            data$1[maskOffset$1 + 1] = (byte)((mask & 0xFF0000) >> 16);
            data$1[maskOffset$1 + 2] = (byte)((mask & 0xFF00) >> 8);
            data$1[maskOffset$1 + 3] = (byte)((mask & 0xFF) >> 0);
        });
        return ByteString$.MODULE$.apply(data);
    }

    private static final int bool$1(boolean b, int mask) {
        if (b) {
            return mask;
        }
        return 0;
    }

    private final void addLongBytes$1(long l, int writtenBytes, byte[] data$1) {
        while (writtenBytes < 8) {
            data$1[2 + writtenBytes] = (byte)(l & 0xFFL);
            ++writtenBytes;
            l = Long.rotateLeft(l, 8);
        }
    }
}

