/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.ArrayInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;

public class JdbcValuesSourceProcessingStateStandardImpl
implements JdbcValuesSourceProcessingState {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JdbcValuesSourceProcessingStateStandardImpl.class);
    private final ExecutionContext executionContext;
    private final JdbcValuesSourceProcessingOptions processingOptions;
    private List<EntityHolder> loadingEntityHolders;
    private List<EntityHolder> reloadedEntityHolders;
    private Map<CollectionKey, LoadingCollectionEntry> loadingCollectionMap;
    private List<CollectionInitializer> arrayInitializers;
    private final PreLoadEvent preLoadEvent;
    private final PostLoadEvent postLoadEvent;

    public JdbcValuesSourceProcessingStateStandardImpl(ExecutionContext executionContext, JdbcValuesSourceProcessingOptions processingOptions) {
        this.executionContext = executionContext;
        this.processingOptions = processingOptions;
        if (executionContext.getSession().isEventSource()) {
            EventSource eventSource = executionContext.getSession().asEventSource();
            this.preLoadEvent = new PreLoadEvent(eventSource);
            this.postLoadEvent = new PostLoadEvent(eventSource);
        } else {
            this.preLoadEvent = null;
            this.postLoadEvent = null;
        }
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.executionContext.getQueryOptions();
    }

    @Override
    public JdbcValuesSourceProcessingOptions getProcessingOptions() {
        return this.processingOptions;
    }

    @Override
    public PreLoadEvent getPreLoadEvent() {
        return this.preLoadEvent;
    }

    @Override
    public PostLoadEvent getPostLoadEvent() {
        return this.postLoadEvent;
    }

    @Override
    public void registerLoadingEntityHolder(EntityHolder holder) {
        if (this.loadingEntityHolders == null) {
            this.loadingEntityHolders = new ArrayList<EntityHolder>();
        }
        this.loadingEntityHolders.add(holder);
    }

    @Override
    public List<EntityHolder> getLoadingEntityHolders() {
        return this.loadingEntityHolders;
    }

    @Override
    public void registerReloadedEntityHolder(EntityHolder holder) {
        if (this.reloadedEntityHolders == null) {
            this.reloadedEntityHolders = new ArrayList<EntityHolder>();
        }
        this.reloadedEntityHolders.add(holder);
    }

    @Override
    public List<EntityHolder> getReloadedEntityHolders() {
        return this.reloadedEntityHolders;
    }

    @Override
    public LoadingCollectionEntry findLoadingCollectionLocally(CollectionKey key) {
        if (this.loadingCollectionMap == null) {
            return null;
        }
        return this.loadingCollectionMap.get(key);
    }

    @Override
    public void registerLoadingCollection(CollectionKey key, LoadingCollectionEntry loadingCollectionEntry) {
        if (this.loadingCollectionMap == null) {
            this.loadingCollectionMap = new HashMap<CollectionKey, LoadingCollectionEntry>();
        }
        this.loadingCollectionMap.put(key, loadingCollectionEntry);
        if (loadingCollectionEntry.getInitializer() instanceof ArrayInitializer) {
            if (this.arrayInitializers == null) {
                this.arrayInitializers = new ArrayList<CollectionInitializer>();
            }
            this.arrayInitializers.add(loadingCollectionEntry.getInitializer());
        }
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.executionContext.getSession();
    }

    @Override
    public void finishUp(boolean registerSubselects) {
        this.finishLoadingCollections();
        Consumer<EntityHolder> holderConsumer = registerSubselects ? this.executionContext::registerLoadingEntityHolder : null;
        this.executionContext.getSession().getPersistenceContextInternal().postLoad(this, holderConsumer);
    }

    private boolean isReadOnly() {
        if (this.getQueryOptions().isReadOnly() != null) {
            return this.getQueryOptions().isReadOnly();
        }
        if (this.executionContext.getSession() instanceof EventSource) {
            return this.executionContext.getSession().isDefaultReadOnly();
        }
        return false;
    }

    private void finishLoadingCollections() {
        if (this.loadingCollectionMap != null) {
            for (LoadingCollectionEntry loadingCollectionEntry : this.loadingCollectionMap.values()) {
                loadingCollectionEntry.finishLoading(this.getExecutionContext());
            }
            this.loadingCollectionMap = null;
        }
    }
}

