/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import java.util.List;
import org.mockito.CheckReturnValue;
import org.mockito.Mockito;
import org.mockito.internal.matchers.CapturingMatcher;
import org.mockito.internal.util.Primitives;

@CheckReturnValue
public class ArgumentCaptor<T> {
    private final CapturingMatcher<T> capturingMatcher;
    private final Class<? extends T> clazz;

    private ArgumentCaptor(Class<? extends T> clazz) {
        this.clazz = clazz;
        this.capturingMatcher = new CapturingMatcher<T>(clazz);
    }

    public T capture() {
        T ignored = Mockito.argThat(this.capturingMatcher);
        return Primitives.defaultValue(this.clazz);
    }

    public T getValue() {
        return this.capturingMatcher.getLastValue();
    }

    public List<T> getAllValues() {
        return this.capturingMatcher.getAllValues();
    }

    public static <U, S extends U> ArgumentCaptor<U> forClass(Class<S> clazz) {
        return new ArgumentCaptor<S>(clazz);
    }
}

