/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.collections.CollectionUtils;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.IWeaveXml;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.testng.xml.XmlUtils;

class DefaultXmlWeaver
implements IWeaveXml {
    private final String defaultComment;

    DefaultXmlWeaver() {
        this(null);
    }

    DefaultXmlWeaver(String string) {
        this.defaultComment = string;
    }

    @Override
    public String asXml(XmlSuite xmlSuite) {
        Iterator<XmlTest> iterator;
        Object object;
        XmlSuite.ParallelMode parallelMode;
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        xMLStringBuffer.setDefaultComment(this.defaultComment);
        xMLStringBuffer.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        Properties properties = new Properties();
        properties.setProperty("name", xmlSuite.getName());
        if (xmlSuite.getVerbose() != null) {
            XmlUtils.setProperty(properties, "verbose", xmlSuite.getVerbose().toString(), XmlSuite.DEFAULT_VERBOSE.toString());
        }
        if ((parallelMode = xmlSuite.getParallel()) != null && !XmlSuite.DEFAULT_PARALLEL.equals((Object)parallelMode)) {
            properties.setProperty("parallel", parallelMode.toString());
        }
        XmlUtils.setProperty(properties, "group-by-instances", String.valueOf(xmlSuite.getGroupByInstances()), XmlSuite.DEFAULT_GROUP_BY_INSTANCES.toString());
        XmlUtils.setProperty(properties, "configfailurepolicy", xmlSuite.getConfigFailurePolicy().toString(), XmlSuite.DEFAULT_CONFIG_FAILURE_POLICY.toString());
        XmlUtils.setProperty(properties, "thread-count", String.valueOf(xmlSuite.getThreadCount()), XmlSuite.DEFAULT_THREAD_COUNT.toString());
        XmlUtils.setProperty(properties, "data-provider-thread-count", String.valueOf(xmlSuite.getDataProviderThreadCount()), XmlSuite.DEFAULT_DATA_PROVIDER_THREAD_COUNT.toString());
        if (Utils.isStringNotEmpty(xmlSuite.getTimeOut())) {
            properties.setProperty("time-out", xmlSuite.getTimeOut());
        }
        if (!XmlSuite.DEFAULT_JUNIT.equals(xmlSuite.isJUnit())) {
            properties.setProperty("junit", xmlSuite.isJUnit() != null ? xmlSuite.isJUnit().toString() : "false");
        }
        XmlUtils.setProperty(properties, "skipfailedinvocationcounts", xmlSuite.skipFailedInvocationCounts().toString(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS.toString());
        if (null != xmlSuite.getObjectFactory()) {
            properties.setProperty("object-factory", xmlSuite.getObjectFactory().getClass().getName());
        }
        if (Utils.isStringNotEmpty(xmlSuite.getParentModule())) {
            properties.setProperty("parent-module", xmlSuite.getParentModule());
        }
        if (Utils.isStringNotEmpty(xmlSuite.getGuiceStage())) {
            properties.setProperty("guice-stage", xmlSuite.getGuiceStage());
        }
        XmlUtils.setProperty(properties, "allow-return-values", String.valueOf(xmlSuite.getAllowReturnValues()), XmlSuite.DEFAULT_ALLOW_RETURN_VALUES.toString());
        xMLStringBuffer.push("suite", properties);
        XmlUtils.dumpParameters(xMLStringBuffer, xmlSuite.getParameters());
        if (CollectionUtils.hasElements(xmlSuite.getListeners())) {
            xMLStringBuffer.push("listeners");
            for (String object22 : xmlSuite.getLocalListeners()) {
                object = new Properties();
                ((Properties)object).setProperty("class-name", object22);
                xMLStringBuffer.addEmptyElement("listener", (Properties)object);
            }
            xMLStringBuffer.pop("listeners");
        }
        if (CollectionUtils.hasElements(xmlSuite.getXmlPackages())) {
            xMLStringBuffer.push("packages");
            for (XmlPackage xmlPackage : xmlSuite.getXmlPackages()) {
                xMLStringBuffer.getStringBuffer().append(xmlPackage.toXml("    "));
            }
            xMLStringBuffer.pop("packages");
        }
        if (xmlSuite.getXmlMethodSelectors() != null) {
            xMLStringBuffer.getStringBuffer().append(xmlSuite.getXmlMethodSelectors().toXml("  "));
        } else if (CollectionUtils.hasElements(xmlSuite.getMethodSelectors())) {
            xMLStringBuffer.push("method-selectors");
            for (XmlMethodSelector xmlMethodSelector : xmlSuite.getMethodSelectors()) {
                xMLStringBuffer.getStringBuffer().append(xmlMethodSelector.toXml("  "));
            }
            xMLStringBuffer.pop("method-selectors");
        }
        Iterator<XmlMethodSelector> iterator2 = xmlSuite.getSuiteFiles();
        if (!iterator2.isEmpty()) {
            xMLStringBuffer.push("suite-files");
            Iterator iterator3 = iterator2.iterator();
            while (iterator3.hasNext()) {
                object = (String)iterator3.next();
                iterator = new Properties();
                ((Properties)((Object)iterator)).setProperty("path", (String)object);
                xMLStringBuffer.addEmptyElement("suite-file", (Properties)((Object)iterator));
            }
            xMLStringBuffer.pop("suite-files");
        }
        List<String> list = xmlSuite.getIncludedGroups();
        object = xmlSuite.getExcludedGroups();
        if (CollectionUtils.hasElements(list) || CollectionUtils.hasElements(object)) {
            xMLStringBuffer.push("groups");
            xMLStringBuffer.push("run");
            for (String string : list) {
                xMLStringBuffer.addEmptyElement("include", "name", string);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)((Object)iterator.next());
                xMLStringBuffer.addEmptyElement("exclude", "name", string);
            }
            xMLStringBuffer.pop("run");
            xMLStringBuffer.pop("groups");
        }
        if (xmlSuite.getGroups() != null) {
            xMLStringBuffer.getStringBuffer().append(xmlSuite.getGroups().toXml("  "));
        }
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            xMLStringBuffer.getStringBuffer().append(xmlTest.toXml("  "));
        }
        xMLStringBuffer.pop("suite");
        return xMLStringBuffer.toXML();
    }

    @Override
    public String asXml(XmlTest xmlTest, String string) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string);
        xMLStringBuffer.setDefaultComment(this.defaultComment);
        Properties properties = new Properties();
        properties.setProperty("name", xmlTest.getName());
        XmlUtils.setProperty(properties, "junit", Boolean.toString(xmlTest.isJUnit()), XmlSuite.DEFAULT_JUNIT.toString());
        XmlUtils.setProperty(properties, "parallel", xmlTest.getParallel().toString(), XmlSuite.DEFAULT_PARALLEL.toString());
        XmlUtils.setProperty(properties, "verbose", Integer.toString(xmlTest.getVerbose()), XmlSuite.DEFAULT_VERBOSE.toString());
        if (null != xmlTest.getTimeOut()) {
            properties.setProperty("time-out", xmlTest.getTimeOut());
        }
        if (xmlTest.getPreserveOrder() != null && !XmlSuite.DEFAULT_PRESERVE_ORDER.equals(xmlTest.getPreserveOrder())) {
            properties.setProperty("preserve-order", xmlTest.getPreserveOrder().toString());
        }
        if (xmlTest.getThreadCount() != -1) {
            properties.setProperty("thread-count", Integer.toString(xmlTest.getThreadCount()));
        }
        XmlUtils.setProperty(properties, "group-by-instances", String.valueOf(xmlTest.getGroupByInstances()), XmlSuite.DEFAULT_GROUP_BY_INSTANCES.toString());
        xMLStringBuffer.push("test", properties);
        if (null != xmlTest.getMethodSelectors() && !xmlTest.getMethodSelectors().isEmpty()) {
            xMLStringBuffer.push("method-selectors");
            for (XmlMethodSelector object : xmlTest.getMethodSelectors()) {
                xMLStringBuffer.getStringBuffer().append(object.toXml(string + "    "));
            }
            xMLStringBuffer.pop("method-selectors");
        }
        XmlUtils.dumpParameters(xMLStringBuffer, xmlTest.getLocalParameters());
        if (!((xmlTest.getXmlGroups() == null || xmlTest.getXmlGroups().getDefines().isEmpty() && (xmlTest.getXmlGroups().getRun() == null || xmlTest.getXmlGroups().getRun().getIncludes().isEmpty() && xmlTest.getXmlGroups().getRun().getExcludes().isEmpty())) && xmlTest.getXmlDependencyGroups().isEmpty())) {
            Properties properties2;
            xMLStringBuffer.push("groups");
            if (xmlTest.getXmlGroups() != null) {
                for (XmlDefine xmlDefine : xmlTest.getXmlGroups().getDefines()) {
                    properties2 = new Properties();
                    properties2.setProperty("name", xmlDefine.getName());
                    xMLStringBuffer.push("define", properties2);
                    for (String string2 : xmlDefine.getIncludes()) {
                        Properties properties3 = new Properties();
                        properties3.setProperty("name", string2);
                        xMLStringBuffer.addEmptyElement("include", properties3);
                    }
                    xMLStringBuffer.pop("define");
                }
            }
            if (!(xmlTest.getXmlGroups() == null || xmlTest.getXmlGroups().getRun() == null || xmlTest.getXmlGroups().getRun().getIncludes().isEmpty() && xmlTest.getXmlGroups().getRun().getExcludes().isEmpty())) {
                xMLStringBuffer.push("run");
                for (String string3 : xmlTest.getXmlGroups().getRun().getIncludes()) {
                    properties2 = new Properties();
                    properties2.setProperty("name", string3);
                    xMLStringBuffer.addEmptyElement("include", properties2);
                }
                for (String string4 : xmlTest.getXmlGroups().getRun().getExcludes()) {
                    properties2 = new Properties();
                    properties2.setProperty("name", string4);
                    xMLStringBuffer.addEmptyElement("exclude", properties2);
                }
                xMLStringBuffer.pop("run");
            }
            if (xmlTest.getXmlDependencyGroups() != null && !xmlTest.getXmlDependencyGroups().isEmpty()) {
                xMLStringBuffer.push("dependencies");
                for (Map.Entry entry : xmlTest.getXmlDependencyGroups().entrySet()) {
                    xMLStringBuffer.addEmptyElement("group", "name", (String)entry.getKey(), "depends-on", (String)entry.getValue());
                }
                xMLStringBuffer.pop("dependencies");
            }
            xMLStringBuffer.pop("groups");
        }
        if (null != xmlTest.getXmlPackages() && !xmlTest.getXmlPackages().isEmpty()) {
            xMLStringBuffer.push("packages");
            for (XmlPackage xmlPackage : xmlTest.getXmlPackages()) {
                xMLStringBuffer.getStringBuffer().append(xmlPackage.toXml("      "));
            }
            xMLStringBuffer.pop("packages");
        }
        if (null != xmlTest.getXmlClasses() && !xmlTest.getXmlClasses().isEmpty()) {
            xMLStringBuffer.push("classes");
            for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                xMLStringBuffer.getStringBuffer().append(xmlClass.toXml(string + "    "));
            }
            xMLStringBuffer.pop("classes");
        }
        xMLStringBuffer.pop("test");
        return xMLStringBuffer.toXML();
    }
}

