/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.LongObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.ConsumedPage;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCounterRebuildManager
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PagingStore pgStore;
    private final PagingManager pagingManager;
    private final StorageManager sm;
    private final Map<Long, PageTransactionInfo> transactions;
    private boolean paging;
    private long limitPageId;
    private int limitMessageNr;
    private LongObjectHashMap<CopiedSubscription> copiedSubscriptionMap = new LongObjectHashMap();
    private final Set<Long> storedLargeMessages;

    public PageCounterRebuildManager(PagingManager pagingManager, PagingStore store, Map<Long, PageTransactionInfo> transactions, Set<Long> storedLargeMessages, AtomicLong minPageTXIDFound) {
        this.initialize(store);
        this.pagingManager = pagingManager;
        this.pgStore = store;
        this.sm = store.getStorageManager();
        this.transactions = transactions;
        this.storedLargeMessages = storedLargeMessages;
    }

    private void initialize(PagingStore store) {
        block7: {
            store.lock(-1L);
            this.paging = store.isPaging();
            if (this.paging) break block7;
            logger.trace("Destination {} was not paging, no need to rebuild counters");
            store.getCursorProvider().forEachSubscription(subscription -> {
                subscription.getCounter().markRebuilding();
                subscription.getCounter().finishRebuild();
            });
            store.getCursorProvider().counterRebuildDone();
            store.unlock();
            return;
        }
        try {
            try {
                store.getCursorProvider().counterRebuildStarted();
                Page currentPage = store.getCurrentPage();
                this.limitPageId = store.getCurrentWritingPage();
                this.limitMessageNr = currentPage.getNumberOfMessages();
                if (logger.isDebugEnabled()) {
                    logger.trace("PageCounterRebuild for {}, Current writing page {} and limit will be {} with lastMessage on last page={}", new Object[]{store.getStoreName(), store.getCurrentWritingPage(), this.limitPageId, this.limitMessageNr});
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                this.limitPageId = store.getCurrentWritingPage();
            }
            logger.trace("Copying page store ack information from address {}", (Object)store.getAddress());
            store.getCursorProvider().forEachSubscription(subscription -> {
                if (logger.isTraceEnabled()) {
                    logger.trace("Copying subscription ID {}", (Object)subscription.getId());
                }
                CopiedSubscription copiedSubscription = new CopiedSubscription((PageSubscription)subscription);
                copiedSubscription.subscriptionCounter.markRebuilding();
                this.copiedSubscriptionMap.put(subscription.getId(), (Object)copiedSubscription);
                subscription.forEachConsumedPage(consumedPage -> {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Copying page {}", (Object)consumedPage.getPageId());
                    }
                    CopiedConsumedPage copiedConsumedPage = new CopiedConsumedPage();
                    copiedSubscription.consumedPageMap.put(consumedPage.getPageId(), (Object)copiedConsumedPage);
                    if (consumedPage.isDone()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Marking page {} as done on the copy", (Object)consumedPage.getPageId());
                        }
                        copiedConsumedPage.done = true;
                    } else {
                        consumedPage.forEachAck((messageNR, pagePosition) -> {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Marking messageNR {} as acked on pageID={} copy", messageNR, (Object)consumedPage.getPageId());
                            }
                            if (copiedConsumedPage.acks == null) {
                                copiedConsumedPage.acks = new IntObjectHashMap();
                            }
                            copiedConsumedPage.acks.put(messageNR, (Object)Boolean.TRUE);
                        });
                    }
                });
            });
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            store.unlock();
        }
    }

    private synchronized PageSubscriptionCounter getCounter(long queueID) {
        CopiedSubscription copiedSubscription = (CopiedSubscription)this.copiedSubscriptionMap.get(queueID);
        if (copiedSubscription != null) {
            return copiedSubscription.subscriptionCounter;
        }
        return null;
    }

    private CopiedSubscription getSubscription(long queueID) {
        return (CopiedSubscription)this.copiedSubscriptionMap.get(queueID);
    }

    private boolean isACK(long queueID, long pageNR, int messageNR) {
        CopiedSubscription subscription = this.getSubscription(queueID);
        if (subscription == null) {
            return true;
        }
        CopiedConsumedPage consumedPage = subscription.getPage(pageNR);
        if (consumedPage == null) {
            return false;
        }
        return consumedPage.isAck(messageNR);
    }

    private void done() {
        this.copiedSubscriptionMap.forEach((k, copiedSubscription) -> {
            if (!copiedSubscription.empty) {
                copiedSubscription.subscription.notEmpty();
                try {
                    copiedSubscription.subscriptionCounter.increment(null, copiedSubscription.addUp, copiedSubscription.sizeUp);
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (!copiedSubscription.empty) {
                copiedSubscription.subscription.notEmpty();
            }
            if (copiedSubscription.subscriptionCounter != null) {
                copiedSubscription.subscriptionCounter.finishRebuild();
            }
        });
        this.pgStore.getCursorProvider().counterRebuildDone();
        this.pgStore.getCursorProvider().scheduleCleanup();
    }

    @Override
    public void run() {
        try {
            this.rebuild();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void rebuild() throws Exception {
        if (this.pgStore == null) {
            logger.trace("Page store is null during rebuildCounters");
            return;
        }
        if (!this.paging) {
            logger.trace("Ignoring call to rebuild pgStore {}", (Object)this.pgStore.getAddress());
        }
        logger.debug("Rebuilding page counter for address {}", (Object)this.pgStore.getAddress());
        block5: for (long pgid = this.pgStore.getFirstPage(); pgid <= this.limitPageId; ++pgid) {
            if (logger.isDebugEnabled()) {
                logger.trace("Rebuilding counter on messages from page {} on rebuildCounters for address {}", (Object)pgid, (Object)this.pgStore.getAddress());
            }
            logger.debug("{} reading paging {} of {}", new Object[]{this.pgStore.getAddress(), pgid, this.limitPageId});
            Page page = this.pgStore.newPageObject(pgid);
            if (!page.getFile().exists()) {
                if (!logger.isDebugEnabled()) continue;
                logger.trace("Skipping page {} on store {}", (Object)pgid, (Object)this.pgStore.getAddress());
                continue;
            }
            page.open(false);
            LinkedList<PagedMessage> msgs = page.read(this.sm);
            page.close(false, false);
            try (LinkedListIterator iter = msgs.iterator();){
                while (iter.hasNext()) {
                    Transaction preparedTX;
                    final PagedMessage msg = (PagedMessage)iter.next();
                    if (this.storedLargeMessages != null && msg.getMessage().isLargeMessage()) {
                        if (logger.isDebugEnabled()) {
                            logger.trace("removing storedLargeMessage {}", (Object)msg.getMessage().getMessageID());
                        }
                        this.storedLargeMessages.remove(msg.getMessage().getMessageID());
                    }
                    if (this.limitPageId == pgid && msg.getMessageNumber() >= this.limitMessageNr) {
                        if (!logger.isDebugEnabled()) continue block5;
                        logger.trace("Rebuild counting on {} reached the last message at {}-{}", new Object[]{this.pgStore.getAddress(), this.limitPageId, this.limitMessageNr});
                        continue block5;
                    }
                    msg.initMessage(this.sm);
                    long[] routedQueues = msg.getQueueIDs();
                    if (logger.isTraceEnabled()) {
                        logger.trace("reading message for rebuild cursor on address={}, pg={}, messageNR={}, routedQueues={}, message={}, queueLIst={}", new Object[]{this.pgStore.getAddress(), msg.getPageNumber(), msg.getMessageNumber(), routedQueues, msg, routedQueues});
                    }
                    PageTransactionInfo txInfo = null;
                    if (msg.getTransactionID() > 0L && (txInfo = this.transactions.get(msg.getTransactionID())) != null) {
                        txInfo.setOrphaned(false);
                    }
                    Transaction transaction = preparedTX = txInfo == null ? null : txInfo.getPreparedTransaction();
                    if (logger.isTraceEnabled()) {
                        logger.trace("lookup on {}, tx={}, preparedTX={}", new Object[]{msg.getTransactionID(), txInfo, preparedTX});
                    }
                    for (long queueID : routedQueues) {
                        boolean txIncluded;
                        boolean ok;
                        boolean bl = ok = !this.isACK(queueID, msg.getPageNumber(), msg.getMessageNumber());
                        if (preparedTX != null) {
                            final PageSubscription subscription = this.pgStore.getCursorProvider().getSubscription(queueID);
                            preparedTX.addOperation(new TransactionOperationAbstract(){

                                @Override
                                public void afterCommit(Transaction tx) {
                                    PageCounterRebuildManager.this.pagingManager.execute(() -> {
                                        try {
                                            subscription.getCounter().increment(null, 1, msg.getStoredSize());
                                        }
                                        catch (Exception e) {
                                            logger.warn(e.getMessage(), (Throwable)e);
                                        }
                                    });
                                }
                            });
                            continue;
                        }
                        boolean bl2 = txIncluded = msg.getTransactionID() <= 0L || this.transactions == null || txInfo != null;
                        if (!txIncluded) {
                            logger.trace("TX is not included for {}", (Object)msg);
                        }
                        if (ok && txIncluded) {
                            CopiedSubscription copiedSubscription;
                            if (logger.isTraceEnabled()) {
                                logger.trace("Message pageNumber={}/{} NOT acked on queue {}", new Object[]{msg.getPageNumber(), msg.getMessageNumber(), queueID});
                            }
                            if ((copiedSubscription = (CopiedSubscription)this.copiedSubscriptionMap.get(queueID)) == null) continue;
                            copiedSubscription.empty = false;
                            ++copiedSubscription.addUp;
                            copiedSubscription.sizeUp += msg.getPersistentSize();
                            continue;
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Message pageNumber={}/{} IS acked on queue {}", new Object[]{msg.getPageNumber(), msg.getMessageNumber(), queueID});
                    }
                }
                continue;
            }
        }
        logger.debug("Counter rebuilding done for address {}", (Object)this.pgStore.getAddress());
        this.done();
    }

    private static class CopiedConsumedPage
    implements ConsumedPage {
        boolean done;
        IntObjectHashMap<Boolean> acks;

        private CopiedConsumedPage() {
        }

        @Override
        public long getPageId() {
            throw new RuntimeException("method not implemented");
        }

        @Override
        public void forEachAck(BiConsumer<Integer, PagePosition> ackConsumer) {
            throw new RuntimeException("method not implemented");
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean isAck(int messageNumber) {
            if (this.done) {
                return true;
            }
            if (this.acks != null) {
                return this.acks.get(messageNumber) != null;
            }
            return false;
        }
    }

    private static class CopiedSubscription {
        private boolean empty = true;
        LongObjectHashMap<CopiedConsumedPage> consumedPageMap = new LongObjectHashMap();
        PageSubscriptionCounter subscriptionCounter;
        PageSubscription subscription;
        int addUp;
        long sizeUp;

        CopiedSubscription(PageSubscription subscription) {
            this.subscriptionCounter = subscription.getCounter();
            this.subscription = subscription;
        }

        CopiedConsumedPage getPage(long pageNr) {
            return (CopiedConsumedPage)this.consumedPageMap.get(pageNr);
        }
    }
}

