/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw;

import com.nqzero.permit.Permit;
import com.sun.jna.PlatformEx;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.rzo.yajsw.YajswVersion;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPProcess;
import org.rzo.yajsw.tools.ConfigGenerator;
import org.rzo.yajsw.tray.TrayIconMain;
import org.rzo.yajsw.util.MyKeyStoreInterface;
import org.rzo.yajsw.wrapper.WrappedProcess;
import org.rzo.yajsw.wrapper.WrappedProcessFactory;
import org.rzo.yajsw.wrapper.WrappedProcessList;
import org.rzo.yajsw.wrapper.WrappedService;

public class WrapperExe {
    static String confFile;
    static List confFileList;
    static List properties;
    static List cmds;
    static int pid;
    static String defaultFile;
    static WrappedService _service;
    static boolean _exitOnTerminate;
    static int _exitCode;
    static Map<String, Object> _properties;
    static List keyValue;
    static Options options;
    static CommandLine cl;

    private static WrappedService getService() {
        if (_service != null) {
            return _service;
        }
        WrapperExe.prepareProperties();
        _service = new WrappedService();
        if (confFileList != null && confFileList.size() > 1) {
            _service.setConfFilesList(confFileList);
        }
        _service.setLocalConfiguration((Configuration)new MapConfiguration(_properties));
        _service.setCliProperties(properties);
        _service.init();
        return _service;
    }

    public static void main(String[] args) {
        Permit.godMode();
        System.out.println("YAJSW: yajsw-stable-13.14");
        System.out.println("OS   : " + YajswVersion.OS_VERSION);
        System.out.println("JVM  : " + YajswVersion.JAVA_VERSION);
        String wrapperJar = WrapperLoader.getWrapperJar();
        String homeDir = new File(wrapperJar).getParent();
        if (!OperatingSystem.instance().setWorkingDir(homeDir)) {
            System.out.println("could not set working dir, pls check configuration or user rights: " + homeDir);
        }
        WrapperExe.buildOptions();
        WrapperExe.parseCommand(args);
        for (Option option : cl.getOptions()) {
            WrapperExe.executeCommand(option);
        }
        if (_exitOnTerminate) {
            Runtime.getRuntime().halt(_exitCode);
        }
    }

    private static File File(String property) {
        return null;
    }

    private static void executeCommand(Option cmd) {
        String opt = cmd.getOpt();
        if ("c".equals(opt)) {
            WrapperExe.doConsole();
        } else if ("t".equals(opt)) {
            WrapperExe.doStart();
        } else if ("p".equals(opt)) {
            WrapperExe.doStop();
        } else if ("tx".equals(opt)) {
            WrapperExe.doStartPosix();
        } else if ("px".equals(opt)) {
            WrapperExe.doStopPosix();
        } else if ("i".equals(opt)) {
            WrapperExe.doInstall();
        } else if ("r".equals(opt)) {
            WrapperExe.doRemove();
        } else if ("rw".equals(opt)) {
            WrapperExe.doRemoveWait();
        } else if ("n".equals(opt)) {
            WrapperExe.doReconnect();
        } else if ("g".equals(opt)) {
            WrapperExe.doGenerate();
        } else if ("q".equals(opt)) {
            WrapperExe.doState();
        } else if ("qs".equals(opt)) {
            WrapperExe.doStateSilent();
        } else if ("qx".equals(opt)) {
            WrapperExe.doStatePosix();
        } else if ("y".equals(opt)) {
            WrapperExe.doStartTrayIcon();
        } else if ("k".equals(opt)) {
            keyValue = Arrays.asList(cl.getOptionValues("k"));
            WrapperExe.doAddKey();
        } else {
            System.out.println("unimplemented option ");
        }
    }

    private static void doAddKey() {
        String key = (String)keyValue.get(0);
        String value = (String)keyValue.get(1);
        try {
            MyKeyStoreInterface ks = WrapperExe.getMyKeystore();
            ks.init();
            ks.put(key, value.toCharArray());
            System.out.println("added key " + key + " to keystore " + ks.getFile());
        }
        catch (Exception ex) {
            System.out.println("error storing data in keystore -> check folder or user rights");
            System.out.println(ex.getMessage());
        }
    }

    private static MyKeyStoreInterface getMyKeystore() throws Exception {
        Class<?> clazz = MyKeyStoreInterface.class.getClassLoader().loadClass("org.rzo.yajsw.util.MyKeyStore");
        return (MyKeyStoreInterface)clazz.newInstance();
    }

    private static void doReconnect() {
        WrapperExe.prepareProperties();
        MapConfiguration localConf = new MapConfiguration(_properties);
        YajswConfigurationImpl conf = new YajswConfigurationImpl((Configuration)localConf, true);
        WrappedProcess w = WrappedProcessFactory.createProcess(conf);
        System.out.println("************* RECONNECTING WRAPPER TO PID  " + pid + " ***********************");
        System.out.println();
        if (w.reconnect(pid)) {
            System.out.println("Connected to PID " + pid);
        } else {
            System.out.println("NOT connected to PID " + pid);
        }
        _exitOnTerminate = false;
    }

    private static void doRemove() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        System.out.println("************* REMOVING " + w.getServiceName() + " ***********************");
        System.out.println();
        boolean result = w.uninstall();
        if (PlatformEx.isWinVista() && w.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        if (result) {
            System.out.println("Service " + w.getServiceName() + " removed");
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT removed");
        }
    }

    private static void doRemoveWait() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        System.out.println("************* REMOVING " + w.getServiceName() + " ***********************");
        System.out.println();
        boolean result = w.uninstall();
        if (PlatformEx.isWinVista() && w.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        if (result) {
            while (w.isInstalled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            System.out.println("Service " + w.getServiceName() + " removed");
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT removed");
        }
    }

    private static void doInstall() {
        WrappedService w = WrapperExe.getService();
        System.out.println("************* INSTALLING " + w.getServiceName() + " ***********************");
        System.out.println();
        int i = 0;
        while (w.isInstalled() && i < 10) {
            if (PlatformEx.isWinVista() && w.requiresElevate()) {
                System.out.println("try uac elevate");
                WindowsXPProcess.elevateMe();
                return;
            }
            ++i;
            w.uninstall();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        boolean result = w.install();
        if (PlatformEx.isWinVista() && w.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        if (result) {
            System.out.println("Service " + w.getServiceName() + " installed");
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT installed");
        }
    }

    private static void doStop() {
        WrappedService w = WrapperExe.getService();
        System.out.println("************* STOPPING " + w.getServiceName() + " ***********************");
        System.out.println();
        try {
            w.stop();
            if (PlatformEx.isWinVista() && w.requiresElevate()) {
                System.out.println("try uac elevate");
                WindowsXPProcess.elevateMe();
                return;
            }
            if (w.isRunning()) {
                System.out.println("Service " + w.getServiceName() + " NOT stopped");
            } else {
                System.out.println("Service " + w.getServiceName() + " stopped");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void doStopPosix() {
        WrappedService w = WrapperExe.getService();
        System.out.println("************* STOPPING " + w.getServiceName() + " ***********************");
        System.out.println();
        try {
            w.stopProcess();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!w.isRunning()) {
            System.out.println("Service " + w.getServiceName() + " stopped");
            _exitCode = 0;
            _exitOnTerminate = true;
        } else {
            System.out.println("Service" + w.getServiceName() + " NOT stopped");
            _exitCode = 1;
            _exitOnTerminate = true;
        }
    }

    private static void doStart() {
        WrappedService w = WrapperExe.getService();
        w.init();
        System.out.println("************* STARTING " + w.getServiceName() + " ***********************");
        System.out.println();
        w.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (PlatformEx.isWinVista() && w.requiresElevate()) {
            System.out.println("try uac elevate");
            WindowsXPProcess.elevateMe();
            return;
        }
        int i = 0;
        while (!w.isRunning() && i++ < 30) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            if (w.isStarting()) continue;
        }
        if (w.isRunning()) {
            System.out.println("Service " + w.getServiceName() + " started");
            _exitCode = 0;
            _exitOnTerminate = true;
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT started");
            _exitCode = 1;
            _exitOnTerminate = true;
        }
    }

    private static void doStartPosix() {
        WrappedService w = WrapperExe.getService();
        System.out.println("************* STARTING " + w.getServiceName() + " ***********************");
        System.out.println();
        w.startProcess();
        int i = 0;
        while (!w.isRunning() && i < 10) {
            ++i;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (w.isRunning()) {
            System.out.println("Service " + w.getServiceName() + " started");
        } else {
            System.out.println("Service " + w.getServiceName() + " NOT started");
        }
        _exitOnTerminate = true;
    }

    private static void doStartTrayIcon() {
        WrapperExe.prepareProperties();
        String[] args = _service != null ? new String[]{_service.getConfigLocalPath()} : new String[]{confFile};
        try {
            TrayIconMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        _exitOnTerminate = true;
    }

    private static void doState() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        int state = w.state();
        System.out.print("Name        : ");
        System.out.println(w.getServiceName());
        System.out.print("Installed   : ");
        System.out.println(w.isInstalled(state));
        System.out.print("Running     : ");
        System.out.println(w.isRunning(state));
        System.out.print("Interactive : ");
        System.out.println(w.isInteractive(state));
        System.out.print("Automatic   : ");
        System.out.println(w.isAutomatic(state));
        System.out.print("Manual      : ");
        System.out.println(w.isManual(state));
        System.out.print("Disabled    : ");
        System.out.println(w.isDisabled(state));
        System.out.print("Paused      : ");
        System.out.println(w.isPaused(state));
        System.out.print("Unknown      : ");
        System.out.println(w.isStateUnknown(state));
    }

    private static void doStateSilent() {
        int state;
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        w.init();
        _exitCode = state = w.state();
        _exitOnTerminate = true;
    }

    private static void doStatePosix() {
        WrapperExe.prepareProperties();
        WrappedService w = WrapperExe.getService();
        int state = w.state();
        _exitCode = w.isRunning(state) ? 0 : 3;
        _exitOnTerminate = true;
    }

    private static void doConsole() {
        WrapperExe.prepareProperties();
        WrappedProcessList list = WrappedProcessFactory.createProcessList(_properties, confFileList, true);
        list.startAll();
        _exitOnTerminate = false;
    }

    private static void doGenerate() {
        System.out.println("************* GENERATING YAJSW CONFIGURATION FOR PID " + pid + " ***********************");
        System.out.println();
        if (defaultFile != null) {
            ConfigGenerator.generate(pid, new File(defaultFile), new File(confFile));
        } else {
            ConfigGenerator.generate(pid, null, new File(confFile));
        }
    }

    private static void doHelp(String reason) {
        HelpFormatter formatter = new HelpFormatter();
        String header = reason != null ? "Error: " + reason : "";
        String footer = "";
        formatter.printHelp("java -jar wrapper.jar", header, options, footer, true);
    }

    private static void prepareProperties() {
        if (confFile != null) {
            _properties.put("wrapper.config", confFile);
        }
        if (defaultFile != null) {
            _properties.put("wrapperx.default.config", defaultFile);
        }
        if (properties != null) {
            for (String prop : properties) {
                String key = prop.substring(0, prop.indexOf(61));
                String value = prop.substring(prop.indexOf(61) + 1);
                _properties.put(key, value);
            }
        }
    }

    private static void parseCommand(String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            cl = parser.parse(options, args);
        }
        catch (Exception exception) {
            WrapperExe.doHelp(exception.getMessage());
        }
        if (cl == null) {
            System.exit(-1);
        }
        try {
            confFileList = new ArrayList();
            for (Option option : cl.getOptions()) {
                if (option.hasArgName() && option.getArgName().equals("configFile")) {
                    for (String val : option.getValues()) {
                        if (Pattern.matches("wrapper\\..*=.*", val)) {
                            properties.add(val);
                            continue;
                        }
                        confFileList.add(val);
                    }
                    continue;
                }
                if (!option.hasArgName() || !option.getArgName().equals("PID")) continue;
                pid = Integer.parseInt(option.getValue());
            }
            for (String string : cl.getArgs()) {
                if (Pattern.matches("wrapper\\..*=.*", string)) {
                    properties.add(string);
                    continue;
                }
                confFileList.add(string);
            }
            if (confFileList.isEmpty()) {
                if (!cl.getOptions()[0].getOpt().equals("k")) {
                    System.out.println("no wrapper config file found ");
                }
            } else {
                confFile = (String)confFileList.get(0);
            }
        }
        catch (Exception exception) {
            System.out.println("no wrapper config file found ");
        }
        try {
            defaultFile = cl.getOptionValue("d");
            if (defaultFile != null) {
                defaultFile = new File(defaultFile).getCanonicalPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void buildOptions() {
        options = new Options();
        options.addOption(Option.builder((String)"c").argName("configFile").longOpt("console").desc("run as a Console application").hasArgs().build());
        options.addOption(Option.builder((String)"t").argName("configFile").longOpt("start").desc("starT an NT service or Unix daemon").hasArgs().build());
        options.addOption(Option.builder((String)"p").argName("configFile").longOpt("stop").desc("stoP a running NT service or Unix daemon").hasArgs().build());
        options.addOption(Option.builder((String)"tx").argName("configFile").longOpt("startx").desc("starT -internal a Posix daemon").hasArgs().build());
        options.addOption(Option.builder((String)"px").argName("configFile").longOpt("stopx").desc("stoP -internal- a running Posix daemon").hasArgs().build());
        options.addOption(Option.builder((String)"i").argName("configFile").longOpt("install").desc("Install an NT service or Unix daemon").hasArgs().build());
        options.addOption(Option.builder((String)"r").argName("configFile").longOpt("remove").desc("Remove an NT service or Unix daemon").hasArg().build());
        options.addOption(Option.builder((String)"rw").argName("configFile").longOpt("removeWait").desc("Remove an NT service or Unix daemon and wait until it is removed").hasArgs().build());
        options.addOption(Option.builder((String)"q").argName("configFile").longOpt("query").desc("Query the status of an NT service or Unix daemon").hasArgs().build());
        options.addOption(Option.builder((String)"y").argName("configFile").longOpt("tray").desc("Start System Tray Icon").hasArgs().build());
        options.addOption(Option.builder((String)"k").argName("key value").numberOfArgs(2).longOpt("addKey").desc("Add Key/Value to Keystore").build());
        options.addOption(Option.builder((String)"qs").argName("configFile").hasArgs().longOpt("querysilent").desc("Silent Query the status of an NT service or Unix daemon").build());
        options.addOption(Option.builder((String)"qx").argName("configFile").hasArgs().longOpt("queryposix").desc("Query the status of a posix daemon. Return status as exit code").build());
        options.addOption(Option.builder((String)"n").argName("PID").longOpt("reconnect").desc("recoNnect to existing application").hasArg().type(Integer.class).build());
        options.addOption(Option.builder((String)"d").argName("defConfFile").hasArg().longOpt("defaultConf").desc("Default Configuration File").build());
        options.addOption(Option.builder((String)"g").argName("PID").longOpt("genconfig").desc("Generate configuration file from pid").hasArg().type(Integer.class).build());
        options.addOption(Option.builder((String)"h").longOpt("help").desc("help").build());
    }

    static {
        properties = new ArrayList();
        _service = null;
        _exitOnTerminate = true;
        _exitCode = 0;
        _properties = new HashMap<String, Object>();
        options = new Options();
    }
}

