/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.JavaSerializer;
import org.apache.pekko.serialization.NullSerializer$;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationSetup;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerDetails;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011%w!\u0002/^\u0011\u00031g!\u00025^\u0011\u0003I\u0007\"\u00029\u0002\t\u0003\tX\u0001\u0002:\u0002\u0001MD!\"!\t\u0002\u0005\u0004%\taXA\u0012\u0011!\t\t0\u0001Q\u0001\n\u0005\u0015bABA\u0000\u0003\u0001\u0011\t\u0001\u0003\u0006\u0003\u0004\u0019\u0011)\u0019!C\u0001\u0005\u000bA!B!\u0007\u0007\u0005\u0003\u0005\u000b\u0011\u0002B\u0004\u0011\u0019\u0001h\u0001\"\u0001\u0003\u001c!I!\u0011\u0005\u0004C\u0002\u0013\u0005!1\u0005\u0005\t\u0005_1\u0001\u0015!\u0003\u0003&!I!\u0011\u0007\u0004C\u0002\u0013\u0005!1\u0005\u0005\t\u0005g1\u0001\u0015!\u0003\u0003&!9!Q\u0007\u0004\u0005\u000e\t]\u0002b\u0002B\u001f\u0003\u0011\u0005!q\b\u0004\u0007\u0003k\t!)a\u000e\t\u0015\u0005E\u0003C!f\u0001\n\u0003\t\u0019\u0006\u0003\u0006\u0002bA\u0011\t\u0012)A\u0005\u0003+B!\"a\u0019\u0011\u0005+\u0007I\u0011AA3\u0011)\ti\u0007\u0005B\tB\u0003%\u0011q\r\u0005\u0007aB!\t!a\u001c\t\u0013\u0005U\u0004#!A\u0005\u0002\u0005]\u0004\"CA?!E\u0005I\u0011AA@\u0011%\t)\nEI\u0001\n\u0003\t9\nC\u0005\u0002\u001cB\t\t\u0011\"\u0011\u0002\u001e\"I\u0011q\u0016\t\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003s\u0003\u0012\u0011!C\u0001\u0003wC\u0011\"!1\u0011\u0003\u0003%\t%a1\t\u0013\u0005E\u0007#!A\u0005\u0002\u0005M\u0007\"CAo!\u0005\u0005I\u0011IAp\u0011%\t\u0019\u000fEA\u0001\n\u0003\n)\u000fC\u0005\u0002hB\t\t\u0011\"\u0011\u0002j\"I\u00111\u001e\t\u0002\u0002\u0013\u0005\u0013Q^\u0004\n\u0005\u0017\n\u0011\u0011!E\u0001\u0005\u001b2\u0011\"!\u000e\u0002\u0003\u0003E\tAa\u0014\t\rA\u001cC\u0011\u0001B4\u0011%\t9oIA\u0001\n\u000b\nI\u000fC\u0005\u0003j\r\n\t\u0011\"!\u0003l!I!\u0011O\u0012\u0002\u0002\u0013\u0005%1\u000f\u0005\n\u0005\u0003\u001b\u0013\u0011!C\u0005\u0005\u0007CqAa#\u0002\t\u0003\u0011i\tC\u0004\u0003,\u0006!\tA!,\u0007\u000b!l\u0006Aa,\t\u0015\u0005\r4F!b\u0001\n\u0003\u00119\f\u0003\u0006\u0002n-\u0012\t\u0011)A\u0005\u0005KCa\u0001]\u0016\u0005\u0002\te\u0006\"\u0003B`W\t\u0007I\u0011\u0001Ba\u0011!\u00119m\u000bQ\u0001\n\t\r\u0007\"\u0003BeW\t\u0007I\u0011\u0001Bf\u0011!\u0011im\u000bQ\u0001\n\u0005U\u0007\u0002\u0003BhW\u0001\u0006IA!5\t\u0013\tu7F1A\u0005\u0002\t}\u0007\u0002\u0003BtW\u0001\u0006IA!9\t\u0013\t%8F1A\u0005\n\t-\b\u0002CB\fW\u0001\u0006IA!<\t\u0011\re1\u0006\"\u0001`\u00077AqAa#,\t\u0013\u0019\t\u0003C\u0004\u0004.-\"\taa\f\t\u000f\r\u001d3\u0006\"\u0001\u0004J!91qI\u0016\u0005\u0002\rE\u0005bBBOW\u0011%1q\u0014\u0005\b\u0007S[C\u0011ABV\u0011\u001d\u00199e\u000bC\u0001\u0007#Dqa!9,\t\u0003\u0019\u0019\u000fC\u0004\u0004h.\"\ta!;\t\u000f\re8\u0006\"\u0001\u0004|\"91\u0011`\u0016\u0005\n\u0011\r\u0001\"\u0003C\u0006W\t\u0007I\u0011\u0002C\u0007\u0011!!Yb\u000bQ\u0001\n\u0011=\u0001\"\u0003C\u000fW\t\u0007I\u0011\u0002C\u0010\u0011!!\u0019c\u000bQ\u0001\n\u0011\u0005\u0002B\u0003C\u0013W\t\u0007I\u0011A0\u0005(!AAQF\u0016!\u0002\u0013!I\u0003C\u0004\u00050-\"I\u0001\"\r\t\u000f\u0011\u00053\u0006\"\u0003\u0005D!9AQK\u0016\u0005\n\u0011]\u0003b\u0002C/W\u0011%Aq\f\u0005\b\tOZC\u0011\u0002C5\u0011%!)h\u000bb\u0001\n\u0013!9\b\u0003\u0005\u0005\f.\u0002\u000b\u0011\u0002C=\u0011%!ii\u000bb\u0001\n\u0003!y\t\u0003\u0005\u0005\u0014.\u0002\u000b\u0011\u0002CI\u0011%!)j\u000bb\u0001\n\u0013!9\n\u0003\u0005\u0005\u001c.\u0002\u000b\u0011\u0002CM\u0011\u001d!ij\u000bC\u0005\t?C\u0011\u0002\"*,\u0005\u0004%IAa3\t\u0011\u0011\u001d6\u0006)A\u0005\u0003+D\u0011\u0002\"+,\u0005\u0004%IAa3\t\u0011\u0011-6\u0006)A\u0005\u0003+Dq\u0001\",,\t\u0013!y\u000b\u0003\u0005\u00054.\"\ta\u0018C[\u00035\u0019VM]5bY&T\u0018\r^5p]*\u0011alX\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u0001\f\u0017!\u00029fW.|'B\u00012d\u0003\u0019\t\u0007/Y2iK*\tA-A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002h\u00035\tQLA\u0007TKJL\u0017\r\\5{CRLwN\\\n\u0003\u0003)\u0004\"a\u001b8\u000e\u00031T\u0011!\\\u0001\u0006g\u000e\fG.Y\u0005\u0003_2\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001g\u0005=\u0019E.Y:t'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b#B6um\u0006m\u0011BA;m\u0005\u0019!V\u000f\u001d7feA\u001aq/!\u0003\u0011\ta|\u0018Q\u0001\b\u0003sv\u0004\"A\u001f7\u000e\u0003mT!\u0001`3\u0002\rq\u0012xn\u001c;?\u0013\tqH.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t\u0019AA\u0003DY\u0006\u001c8O\u0003\u0002\u007fYB!\u0011qAA\u0005\u0019\u0001!1\"a\u0003\u0004\u0003\u0003\u0005\tQ!\u0001\u0002\u000e\t\u0019q\fJ\u0019\u0012\t\u0005=\u0011Q\u0003\t\u0004W\u0006E\u0011bAA\nY\n9aj\u001c;iS:<\u0007cA6\u0002\u0018%\u0019\u0011\u0011\u00047\u0003\u0007\u0005s\u0017\u0010E\u0002h\u0003;I1!a\b^\u0005)\u0019VM]5bY&TXM]\u0001\u001cGV\u0014(/\u001a8u)J\fgn\u001d9peRLeNZ8s[\u0006$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0002CBA\u0014\u0003[\t\t$\u0004\u0002\u0002*)\u0019\u00111\u00067\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003_\tICA\bEs:\fW.[2WCJL\u0017M\u00197f!\r\t\u0019\u0004E\u0007\u0002\u0003\tY\u0011J\u001c4pe6\fG/[8o'\u0019\u0001\".!\u000f\u0002@A\u00191.a\u000f\n\u0007\u0005uBNA\u0004Qe>$Wo\u0019;\u0011\t\u0005\u0005\u00131\n\b\u0005\u0003\u0007\n9ED\u0002{\u0003\u000bJ\u0011!\\\u0005\u0004\u0003\u0013b\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\nyE\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002J1\fq!\u00193ee\u0016\u001c8/\u0006\u0002\u0002VA!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\}\u000bQ!Y2u_JLA!a\u0018\u0002Z\t9\u0011\t\u001a3sKN\u001c\u0018\u0001C1eIJ,7o\u001d\u0011\u0002\rML8\u000f^3n+\t\t9\u0007\u0005\u0003\u0002X\u0005%\u0014\u0002BA6\u00033\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004CCBA\u0019\u0003c\n\u0019\bC\u0004\u0002RU\u0001\r!!\u0016\t\u000f\u0005\rT\u00031\u0001\u0002h\u0005!1m\u001c9z)\u0019\t\t$!\u001f\u0002|!I\u0011\u0011\u000b\f\u0011\u0002\u0003\u0007\u0011Q\u000b\u0005\n\u0003G2\u0002\u0013!a\u0001\u0003O\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0002*\"\u0011QKABW\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u0013Ut7\r[3dW\u0016$'bAAHY\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u00033SC!a\u001a\u0002\u0004\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a(\u0011\t\u0005\u0005\u00161V\u0007\u0003\u0003GSA!!*\u0002(\u0006!A.\u00198h\u0015\t\tI+\u0001\u0003kCZ\f\u0017\u0002BAW\u0003G\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAZ!\rY\u0017QW\u0005\u0004\u0003oc'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u000b\u0003{C\u0011\"a0\u001c\u0003\u0003\u0005\r!a-\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\r\u0005\u0004\u0002H\u00065\u0017QC\u0007\u0003\u0003\u0013T1!a3m\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\fIM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAk\u00037\u00042a[Al\u0013\r\tI\u000e\u001c\u0002\b\u0005>|G.Z1o\u0011%\ty,HA\u0001\u0002\u0004\t)\"\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAP\u0003CD\u0011\"a0\u001f\u0003\u0003\u0005\r!a-\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a(\u0002\r\u0015\fX/\u00197t)\u0011\t).a<\t\u0013\u0005}\u0016%!AA\u0002\u0005U\u0011\u0001H2veJ,g\u000e\u001e+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g\u000e\t\u0015\u0004\u000b\u0005U\b\u0003BA|\u0003wl!!!?\u000b\u0007\u0005=u,\u0003\u0003\u0002~\u0006e(aC%oi\u0016\u0014h.\u00197Ba&\u0014\u0001bU3ui&twm]\n\u0003\r)\faaY8oM&<WC\u0001B\u0004!\u0011\u0011IA!\u0006\u000e\u0005\t-!\u0002\u0002B\u0002\u0005\u001bQAAa\u0004\u0003\u0012\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0003\u0014\u0005\u00191m\\7\n\t\t]!1\u0002\u0002\u0007\u0007>tg-[4\u0002\u000f\r|gNZ5hAQ!!Q\u0004B\u0010!\r\t\u0019D\u0002\u0005\b\u0005\u0007I\u0001\u0019\u0001B\u0004\u0003-\u0019VM]5bY&TXM]:\u0016\u0005\t\u0015\u0002c\u0002=\u0003(\t-\"1F\u0005\u0005\u0005S\t\u0019AA\u0002NCB\u00042\u0001\u001fB\u0017\u0013\u0011\ti+a\u0001\u0002\u0019M+'/[1mSj,'o\u001d\u0011\u0002+M+'/[1mSj\fG/[8o\u0005&tG-\u001b8hg\u000612+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b%A\u0006d_:4\u0017n\u001a+p\u001b\u0006\u0004H\u0003\u0002B\u0013\u0005sAqAa\u000f\u000f\u0001\u0004\u00119!A\u0002dM\u001e\f1c]3sS\u0006d\u0017N_3e\u0003\u000e$xN\u001d)bi\"$BAa\u000b\u0003B!9!1I\bA\u0002\t\u0015\u0013\u0001C1di>\u0014(+\u001a4\u0011\t\u0005]#qI\u0005\u0005\u0005\u0013\nIF\u0001\u0005BGR|'OU3g\u0003-IeNZ8s[\u0006$\u0018n\u001c8\u0011\u0007\u0005M2eE\u0003$\u0005#\u0012i\u0006\u0005\u0006\u0003T\te\u0013QKA4\u0003ci!A!\u0016\u000b\u0007\t]C.A\u0004sk:$\u0018.\\3\n\t\tm#Q\u000b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003\u0002B0\u0005Kj!A!\u0019\u000b\t\t\r\u0014qU\u0001\u0003S>LA!!\u0014\u0003bQ\u0011!QJ\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003c\u0011iGa\u001c\t\u000f\u0005Ec\u00051\u0001\u0002V!9\u00111\r\u0014A\u0002\u0005\u001d\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005k\u0012i\bE\u0003l\u0005o\u0012Y(C\u0002\u0003z1\u0014aa\u00149uS>t\u0007CB6u\u0003+\n9\u0007C\u0005\u0003\u0000\u001d\n\t\u00111\u0001\u00022\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\u0015\u0005\u0003BAQ\u0005\u000fKAA!#\u0002$\n1qJ\u00196fGR\f\u0001d^5uQR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8o+\u0011\u0011yI!&\u0015\t\tE%1\u0015\u000b\u0005\u0005'\u0013I\n\u0005\u0003\u0002\b\tUEa\u0002BLS\t\u0007\u0011Q\u0002\u0002\u0002)\"9!1T\u0015A\u0002\tu\u0015!\u00014\u0011\u000b-\u0014yJa%\n\u0007\t\u0005FNA\u0005Gk:\u001cG/[8oa!9\u00111M\u0015A\u0002\t\u0015\u0006\u0003BA,\u0005OKAA!+\u0002Z\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u0006qr-\u001a;DkJ\u0014XM\u001c;Ue\u0006t7\u000f]8si&sgm\u001c:nCRLwN\u001c\u000b\u0003\u0003c\u0019Ba\u000b6\u00032B!\u0011q\u000bBZ\u0013\u0011\u0011),!\u0017\u0003\u0013\u0015CH/\u001a8tS>tWC\u0001BS)\u0011\u0011YL!0\u0011\u0005\u001d\\\u0003bBA2]\u0001\u0007!QU\u0001\tg\u0016$H/\u001b8hgV\u0011!1\u0019\t\u0004\u0005\u000b4aBA4\u0001\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%\u0001\fBY2|wOS1wCN+'/[1mSj\fG/[8o+\t\t).A\fBY2|wOS1wCN+'/[1mSj\fG/[8oA\u0005!q\f\\8h!\u0011\u0011\u0019N!7\u000e\u0005\tU'b\u0001Bl?\u0006)QM^3oi&!!1\u001cBk\u0005Qi\u0015M]6fe2{wmZ5oO\u0006#\u0017\r\u001d;fe\u0006\u0019An\\4\u0016\u0005\t\u0005\b\u0003\u0002Bj\u0005GLAA!:\u0003V\nqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nQ\"\\1oS\u001a,7\u000f^\"bG\",WC\u0001Bw!\u0019\u0011yOa?\u0003\u00006\u0011!\u0011\u001f\u0006\u0005\u0005g\u0014)0\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0005o\u0014I0\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u000b\u0002(&!!Q By\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003CB\u0001\u0007\u000f\u0011Yc!\u0003\u000e\u0005\r\r!\u0002BB\u0003\u0003\u0013\f\u0011\"[7nkR\f'\r\\3\n\t\t%21\u0001\t\u0006W\n]41\u0002\u0019\u0005\u0007\u001b\u0019\u0019\u0002\u0005\u0004\u0002\"\u000e=1\u0011C\u0005\u0005\u0003\u0003\t\u0019\u000b\u0005\u0003\u0002\b\rMAaCB\u000bo\u0005\u0005\t\u0011!B\u0001\u0003\u001b\u00111a\u0018\u00133\u00039i\u0017M\\5gKN$8)Y2iK\u0002\n\u0001d]3sS\u0006d\u0017N_1uS>t\u0017J\u001c4pe6\fG/[8o+\t\u0019i\u0002E\u0002\u0003FBA3\u0001OA{+\u0011\u0019\u0019ca\n\u0015\t\r\u00152\u0011\u0006\t\u0005\u0003\u000f\u00199\u0003B\u0004\u0003\u0018f\u0012\r!!\u0004\t\u000f\tm\u0015\b1\u0001\u0004,A)1Na(\u0004&\u0005I1/\u001a:jC2L'0\u001a\u000b\u0005\u0007c\u0019\u0019\u0005\u0005\u0004\u0002(\rM2qG\u0005\u0005\u0007k\tICA\u0002Uef\u0004Ra[B\u001d\u0007{I1aa\u000fm\u0005\u0015\t%O]1z!\rY7qH\u0005\u0004\u0007\u0003b'\u0001\u0002\"zi\u0016Daa!\u0012;\u0001\u0004Q\u0017!A8\u0002\u0017\u0011,7/\u001a:jC2L'0Z\u000b\u0005\u0007\u0017\u001a\t\u0006\u0006\u0005\u0004N\rM3qKB.!\u0019\t9ca\r\u0004PA!\u0011qAB)\t\u001d\u00119j\u000fb\u0001\u0003\u001bAqa!\u0016<\u0001\u0004\u00199$A\u0003csR,7\u000fC\u0004\u0004Zm\u0002\r!a-\u0002\u0019M,'/[1mSj,'/\u00133\t\u000f\ru3\b1\u0001\u0004`\u0005)1\r\\1{uB)1Na\u001e\u0004bA\"11MB4!\u0011Axp!\u001a\u0011\t\u0005\u001d1q\r\u0003\r\u0007S\u001aY'!A\u0001\u0002\u000b\u000511\u0010\u0002\u0004?\u0012\"\u0004bBB/w\u0001\u00071Q\u000e\t\u0006W\n]4q\u000e\u0019\u0005\u0007c\u001a)\b\u0005\u0003y\u007f\u000eM\u0004\u0003BA\u0004\u0007k\"Ab!\u001b\u0004l\u0005\u0005\t\u0011!B\u0001\u0007o\nB!a\u0004\u0004zA!\u0011qAB)#\u0011\tyaa\u0014)\u0017m\u001ayh!\"\u0004\b\u000e-5Q\u0012\t\u0004W\u000e\u0005\u0015bABBY\nQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\u00121\u0011R\u0001=+N,\u0007\u0005Z3tKJL\u0017\r\\5{K\u0002\"\b.\u0019;!C\u000e\u001cW\r\u001d;tAQDW\r\t1nC:Lg-Z:uA\u0002\n7\u000fI1!G2\f7o\u001d\u0011oC6,g&A\u0003tS:\u001cW-\t\u0002\u0004\u0010\u0006Q\u0011i[6bAIrcG\f\u0019\u0015\u0011\rM5QSBL\u00073\u0003R!a\n\u00044)Dqa!\u0016=\u0001\u0004\u00199\u0004C\u0004\u0004Zq\u0002\r!a-\t\u000f\rmE\b1\u0001\u0003,\u0005AQ.\u00198jM\u0016\u001cH/\u0001\u000beKN,'/[1mSj,')\u001f;f\u0003J\u0014\u0018-\u001f\u000b\bU\u000e\u000561UBT\u0011\u001d\u0019)&\u0010a\u0001\u0007oAqa!*>\u0001\u0004\tY\"\u0001\u0006tKJL\u0017\r\\5{KJDqaa'>\u0001\u0004\u0011Y#A\u000beKN,'/[1mSj,')\u001f;f\u0005V4g-\u001a:\u0015\u000f)\u001cik!0\u0004@\"91q\u0016 A\u0002\rE\u0016a\u00012vMB!11WB]\u001b\t\u0019)L\u0003\u0003\u00048\u0006\u001d\u0016a\u00018j_&!11XB[\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u00073r\u0004\u0019AAZ\u0011\u001d\u0019YJ\u0010a\u0001\u0005WASAPBb\u0007\u001f\u0004Ra[Bc\u0007\u0013L1aa2m\u0005\u0019!\bN]8xgB!!qLBf\u0013\u0011\u0019iM!\u0019\u000319{GoU3sS\u0006d\u0017N_1cY\u0016,\u0005pY3qi&|gn\t\u0002\u0004JV!11[Bm)\u0019\u0019)na7\u0004^B1\u0011qEB\u001a\u0007/\u0004B!a\u0002\u0004Z\u00129!qS C\u0002\u00055\u0001bBB+\u007f\u0001\u00071q\u0007\u0005\b\u0007;z\u0004\u0019ABp!\u0011Axpa6\u0002#\u0019Lg\u000eZ*fe&\fG.\u001b>fe\u001a{'\u000f\u0006\u0003\u0002\u001c\r\u0015\bBBB#\u0001\u0002\u0007!.A\u0007tKJL\u0017\r\\5{KJ4uN\u001d\u000b\u0005\u00037\u0019Y\u000fC\u0004\u0004^\u0005\u0003\ra!<1\t\r=81\u001f\t\u0005q~\u001c\t\u0010\u0005\u0003\u0002\b\rMH\u0001DB{\u0007W\f\t\u0011!A\u0003\u0002\u00055!aA0%q!*\u0011ia1\u0004P\u0006a1/\u001a:jC2L'0\u001a:PMR!1Q`B\u0000!\u0019\t9ca\r\u0002\u001c!9A\u0011\u0001\"A\u0002\t-\u0012!D:fe&\fG.\u001b>fe\u001a\u000bf\n\u0006\u0004\u0004~\u0012\u0015A\u0011\u0002\u0005\b\t\u000f\u0019\u0005\u0019\u0001B\u0016\u0003-\u0011\u0017N\u001c3j]\u001et\u0015-\\3\t\u000f\u0011\u00051\t1\u0001\u0003,\u0005\t2/\u001a:jC2L'0\u001a:EKR\f\u0017\u000e\\:\u0016\u0005\u0011=\u0001CBB\u0001\t#!)\"\u0003\u0003\u0005\u0014\r\r!aA*fcB\u0019q\rb\u0006\n\u0007\u0011eQLA\tTKJL\u0017\r\\5{KJ$U\r^1jYN\f!c]3sS\u0006d\u0017N_3s\t\u0016$\u0018-\u001b7tA\u0005Y1/\u001a:jC2L'0\u001a:t+\t!\t\u0003E\u0004y\u0005O\u0011Y#a\u0007\u0002\u0019M,'/[1mSj,'o\u001d\u0011\u0002\u0011\tLg\u000eZ5oON,\"\u0001\"\u000b\u0011\r\r\u0005A\u0011\u0003C\u0016!\r\u0011)mA\u0001\nE&tG-\u001b8hg\u0002\nA$\u001a8tkJ,wJ\u001c7z\u00032dwn^3e'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000f\u0006\u0003\u00054\u0011e\u0002cA6\u00056%\u0019Aq\u00077\u0003\tUs\u0017\u000e\u001e\u0005\b\twQ\u0005\u0019\u0001C\u001f\u0003\u0011IG/\u001a:\u0011\r\u0005\u0005CqHA\u000e\u0013\u0011\ty-a\u0014\u0002A]\f'O\\+oKb\u0004Xm\u0019;fI:{g\u000eU3lW>\u001cVM]5bY&TXM\u001d\u000b\u0007\u0003+$)\u0005\"\u0015\t\u000f\ru3\n1\u0001\u0005HA\"A\u0011\nC'!\u0011Ax\u0010b\u0013\u0011\t\u0005\u001dAQ\n\u0003\r\t\u001f\")%!A\u0001\u0002\u000b\u0005\u0011Q\u0002\u0002\u0005?\u0012\n\u0004\u0007C\u0004\u0005T-\u0003\r!a\u0007\u0002\u0007M,'/A\ndQ\u0016\u001c7nR8pO2,\u0007K]8u_\n,h\r\u0006\u0003\u0002V\u0012e\u0003b\u0002C.\u0019\u0002\u0007!1F\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00195fG.\u001cE.Y:t)\u0019\t)\u000e\"\u0019\u0005f!9A1M'A\u0002\t-\u0012A\u00029sK\u001aL\u0007\u0010C\u0004\u0005\\5\u0003\rAa\u000b\u0002\tM|'\u000f\u001e\u000b\u0005\tS!Y\u0007C\u0004\u0005n9\u0003\r\u0001b\u001c\u0002\u0005%t\u0007CBA!\tc\"Y#\u0003\u0003\u0005t\u0005=#\u0001C%uKJ\f'\r\\3\u0002\u001bM,'/[1mSj,'/T1q+\t!I\b\u0005\u0005\u0005|\u0011uD\u0011QA\u000e\u001b\t\u0011)0\u0003\u0003\u0005\u0000\tU(!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\"A1\u0011CD!\u0011Ax\u0010\"\"\u0011\t\u0005\u001dAq\u0011\u0003\f\t\u0013\u0003\u0016\u0011!A\u0001\u0006\u0003\tiA\u0001\u0003`IE\n\u0014AD:fe&\fG.\u001b>fe6\u000b\u0007\u000fI\u0001\u0015g\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=\u0016\u0005\u0011E\u0005c\u0002=\u0003(\u0005M\u00161D\u0001\u0016g\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=!\u0003e\tX/[2l'\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=\u0016\u0005\u0011e\u0005#B6\u0004:\u0005m\u0011AG9vS\u000e\\7+\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif\u0004\u0013!E4fiN+'/[1mSj,'OQ=JIR!\u00111\u0004CQ\u0011\u001d!\u0019+\u0016a\u0001\u0003g\u000b!!\u001b3\u0002C%\u001c(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8XCJt\u0017N\\4F]\u0006\u0014G.\u001a3\u0002E%\u001c(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8XCJt\u0017N\\4F]\u0006\u0014G.\u001a3!\u0003\u0001J7oV1s]&twm\u00148O_Z+'/\u001b4jG\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0002C%\u001cx+\u0019:oS:<wJ\u001c(p-\u0016\u0014\u0018NZ5dCRLwN\\#oC\ndW\r\u001a\u0011\u00025%\u001cH)[:bY2|w/\u001a3KCZ\f7+\u001a:jC2L'0\u001a:\u0015\t\u0005UG\u0011\u0017\u0005\b\u0007KS\u0006\u0019AA\u000e\u0003u\u0019\bn\\;mI^\u000b'O\\!c_V$(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u0014HCBAk\to#)\rC\u0004\u0005:n\u0003\r\u0001b/\u0002\u001fM,'/[1mSj,Gm\u00117bgN\u0004D\u0001\"0\u0005BB!\u0001p C`!\u0011\t9\u0001\"1\u0005\u0019\u0011\rGqWA\u0001\u0002\u0003\u0015\t!!\u0004\u0003\t}#\u0013g\r\u0005\b\u0007K[\u0006\u0019AA\u000eQ\rY\u0016Q\u001f")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<scala.collection.immutable.Map<String, Option<Class<?>>>> manifestCache;
    private final Seq<SerializerDetails> serializerDetails;
    private final scala.collection.immutable.Map<String, Serializer> serializers;
    private final Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final scala.collection.immutable.Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<scala.collection.immutable.Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        Try try_;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.findSerializerFor(o$1).toBinary(o$1));
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return try_;
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Object object;
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1 & Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0 & Serializable)() -> "")).append(". ").append("The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
            try {
                if (withTransportInformation_oldInfo == null) {
                    Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
                }
                object = serializer2.fromBinary(bytes, clazz);
            }
            finally {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
            }
            return object;
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        Object object;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = Serialization.$anonfun$deserializeByteArray$1(this, serializer, bytes, manifest);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return object;
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(170).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if (serializer2 instanceof ByteBufferSerializer) {
                object = ((ByteBufferSerializer)((Object)serializer2)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object = this.deserializeByteArray(bytes, serializer2, manifest);
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        Try try_;
        Information withTransportInformation_oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (withTransportInformation_oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.serializerFor(clazz$2).fromBinary(bytes$4, (Option<Class<?>>)new Some((Object)clazz$2)));
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)withTransportInformation_oldInfo);
        }
        return try_;
    }

    public Serializer findSerializerFor(Object o) {
        if (o == null) {
            return NullSerializer$.MODULE$;
        }
        return this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer = this.serializerMap().get(clazz);
        if (serializer == null) {
            Serializer serializer2;
            SeqOps seqOps;
            Seq seq = (Seq)this.bindings().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq))) {
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                    throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
                }
            }
            if (Serialization.unique$1(seq)) {
                serializer2 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                Seq possibilitiesWithoutJavaSerializer = (Seq)seq.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((IterableOnceOps)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable)x0$3 -> {
                        if (x0$3 != null) {
                            return ((Serializer)x0$3._2()).getClass().getName();
                        }
                        throw new MatchError(null);
                    })).mkString(", "));
                }
                serializer2 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer2;
            Serializer serializer3 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer3 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'pekko.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonPekkoSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                return ser;
            }
            return serializer3;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.serializerOf("", serializerFQN);
    }

    /*
     * Unable to fully structure code
     */
    private Try<Serializer> serializerOf(String bindingName, String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var4_3 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this, fqn, bindingName){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            public final String fqn$1;
            public final String bindingName$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof NoSuchMethodException) {
                    return (B1)this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this){
                        private static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$serializerOf$1 $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            if (x1 instanceof NoSuchMethodException) {
                                NoSuchMethodException noSuchMethodException = (NoSuchMethodException)x1;
                                String string = this.$outer.bindingName$1;
                                String string2 = "";
                                if (string != null && string.equals(string2)) {
                                    throw noSuchMethodException;
                                }
                                return (B1)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system().dynamicAccess().createInstanceFor(this.$outer.fqn$1, (Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)this.$outer.bindingName$1), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Serializer.class));
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            return x1 instanceof NoSuchMethodException;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 instanceof NoSuchMethodException;
            }

            public /* synthetic */ Serialization org$apache$pekko$serialization$Serialization$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
                this.bindingName$1 = bindingName$1;
            }
        });
    }

    private Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private scala.collection.immutable.Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        if (!this.system().settings().AllowJavaSerialization()) {
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0 & Serializable)() -> "Disallowed JavaSerializer binding.");
            return;
        }
    }

    private boolean warnUnexpectedNonPekkoSerializer(Class<?> clazz, Serializer ser) {
        if (clazz.getName().startsWith("org.apache.pekko.") && !ser.getClass().getName().startsWith("org.apache.pekko.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Apache Pekko. It's not recommended to replace serializers for messages provided by Apache Pekko.", (Object)ser.getClass().getName(), (Object)clazz.getName());
            return true;
        }
        return false;
    }

    private boolean checkGoogleProtobuf(String className) {
        return this.checkClass("com.google.protobuf", className);
    }

    private boolean checkClass(String prefix, String className) {
        return !className.startsWith(prefix) || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return (Seq)((IterableOnceOps)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    buf.append(ca);
                    break;
                }
                default: {
                    buf.insert(n, ca);
                }
            }
            return buf;
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public scala.collection.immutable.Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer = this.quickSerializerByIdentity()[id];
            if (serializer == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            return serializer;
        }
        return (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("org.apache.pekko.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    public static final /* synthetic */ Object $anonfun$deserialize$4(Serializer serializer$1, byte[] bytes$1, Option clazz$1) {
        return serializer$1.fromBinary(bytes$1, clazz$1);
    }

    private final boolean updateCache$1(scala.collection.immutable.Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, (scala.collection.immutable.Map<String, Option<Class<?>>>)cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ Object $anonfun$deserializeByteArray$1(Serialization $this, Serializer serializer$2, byte[] bytes$3, String manifest$2) {
        if (serializer$2 instanceof SerializerWithStringManifest) {
            return ((SerializerWithStringManifest)serializer$2).fromBinary(bytes$3, manifest$2);
        }
        String string = manifest$2;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            return serializer$2.fromBinary(bytes$3, (Option<Class<?>>)None$.MODULE$);
        }
        scala.collection.immutable.Map<String, Option<Class<?>>> cache = $this.manifestCache().get();
        Option option = cache.get((Object)manifest$2);
        if (option instanceof Some) {
            Option cachedClassManifest = (Option)((Some)option).value();
            return serializer$2.fromBinary(bytes$3, cachedClassManifest);
        }
        if (None$.MODULE$.equals(option)) {
            Try try_ = $this.system().dynamicAccess().getClassFor(manifest$2, ClassTag$.MODULE$.AnyRef());
            if (try_ instanceof Success) {
                Class classManifest = (Class)((Success)try_).value();
                Some classManifestOption = new Some((Object)classManifest);
                $this.updateCache$1(cache, manifest$2, (Option)classManifestOption);
                return serializer$2.fromBinary(bytes$3, (Option<Class<?>>)classManifestOption);
            }
            if (try_ instanceof Failure) {
                throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest$2).append("] for serializer with id [").append(serializer$2.identifier()).append("].").toString());
            }
            throw new MatchError(try_);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Class)x0$1._1()).isAssignableFrom(clazz$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        if (x0$2 != null && x0$2._2() instanceof JavaSerializer) {
            return false;
        }
        return x0$2 == null || !(x0$2._2() instanceof DisabledJavaSerializer);
    }

    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        if (check$ifrefutable$1 != null) {
            String k = (String)check$ifrefutable$1._1();
            String v = (String)check$ifrefutable$1._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        if (check$ifrefutable$2 != null) {
            String className = (String)check$ifrefutable$2._1();
            String alias = (String)check$ifrefutable$2._2();
            if (className != null && alias != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        if (x$4 != null) {
            String className = (String)x$4._1();
            String alias = (String)x$4._2();
            if (className != null && alias != null) {
                return !alias.equals("none") && $this.checkGoogleProtobuf(className);
            }
        }
        throw new MatchError((Object)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$bindings$7(Serialization $this, Tuple2 x0$3) {
        if (x0$3 != null) {
            Class clazz = (Class)x0$3._1();
            Serializer ser = (Serializer)x0$3._2();
            return $this.warnUnexpectedNonPekkoSerializer(clazz, ser);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$6) {
        if (x0$6 != null) {
            int id = x0$6._1$mcI$sp();
            Serializer ser = (Serializer)x0$6._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    /*
     * WARNING - void declaration
     */
    public Serialization(ExtendedActorSystem system) {
        void var3_3;
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<scala.collection.immutable.Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            vector = (Seq)((SerializationSetup)((Some)option).value()).createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (Seq)vector.collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            /*
             * WARNING - void declaration
             */
            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x1.serializer())) {
                    void apply_useFor;
                    void apply_serializer;
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
                    Seq<Class<?>> seq = x1.useFor();
                    DisabledJavaSerializer disabledJavaSerializer = new DisabledJavaSerializer(this.$outer.system());
                    String apply_alias = x1.alias();
                    return (B1)new SerializerDetails(apply_alias, (Serializer)apply_serializer, (Seq<Class<?>>)apply_useFor);
                }
                return (B1)x1;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                if (x1 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x1.serializer())) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.immutable.Map result = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.settings().Serializers().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable)x$3 -> {
            if (x$3 != null) {
                String k = (String)x$3._1();
                String v = (String)x$3._2();
                if (k != null && v != null) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), this.serializerOf(k, v).get());
                }
            }
            throw new MatchError(x$3);
        })).$plus$plus((IterableOnce)this.serializerDetails().map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer())));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result.iterator().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (Serializer)x0$1._2();
            }
            throw new MatchError(null);
        }));
        this.serializers = var3_3;
        scala.collection.immutable.Map fromConfig = (scala.collection.immutable.Map)this.settings().SerializationBindings().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable)x$5 -> {
            if (x$5 != null) {
                String className = (String)x$5._1();
                String alias = (String)x$5._2();
                if (className != null && alias != null) {
                    return new Tuple2(this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)alias));
                }
            }
            throw new MatchError(x$5);
        });
        Seq fromSettings = (Seq)this.serializerDetails().flatMap((Function1 & Serializable)detail -> (Seq)detail.useFor().map((Function1 & Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer())));
        Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig.$plus$plus((IterableOnce)fromSettings));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result2.iterator().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (Serializer)x0$2._2();
            }
            throw new MatchError(null);
        }));
        result2.foreach((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$7(this, x0$3)));
        this.bindings = result2;
        this.serializerMap = (ConcurrentHashMap)this.bindings().foldLeft(new ConcurrentHashMap(), (Function2 & Serializable)(x0$4, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$4, x1$1);
            if (x1$1 != null) {
                Class c = (Class)x1$1._1();
                Serializer s = (Serializer)x1$1._2();
                x0$4.put(c, s);
                return x0$4;
            }
            throw new MatchError((Object)tuple2);
        });
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)NullSerializer$.MODULE$);
        scala.collection.immutable.Map zero = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.serializerByIdentity = (scala.collection.immutable.Map)this.serializers().foldLeft((Object)zero, (Function2 & Serializable)(x0$5, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$5, x1$2);
            if (x1$2 != null) {
                Serializer ser = (Serializer)x1$2._2();
                int id = ser.identifier();
                Option option = x0$5.get((Object)BoxesRunTime.boxToInteger((int)id));
                if (option instanceof Some) {
                    Serializer serializer = (Serializer)((Some)option).value();
                    if (serializer == null || !serializer.equals(ser)) {
                        throw new IllegalArgumentException(new StringBuilder(68).append("Serializer identifier [").append(id).append("] of [").append(ser.getClass().getName()).append("] ").append("is not unique. It is also used by [").append(x0$5.apply((Object)BoxesRunTime.boxToInteger((int)id)).getClass().getName()).append("].").toString());
                    }
                }
                return (scala.collection.immutable.Map)x0$5.updated((Object)BoxesRunTime.boxToInteger((int)id), (Object)ser);
            }
            throw new MatchError((Object)tuple2);
        });
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable)x0$6 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$6);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("pekko.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("pekko.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    Serializable {
        private final Address address;
        private final ActorSystem system;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.address();
                }
                case 1: {
                    return this.system();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "address";
                }
                case 1: {
                    return "system";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof Information)) break block3;
                    Information information = (Information)x$1;
                    Address address = this.address();
                    Address address2 = information.address();
                    if (address != null ? !((Object)address).equals(address2) : address2 != null) break block3;
                    ActorSystem actorSystem = this.system();
                    ActorSystem actorSystem2 = information.system();
                    if (actorSystem != null ? !actorSystem.equals(actorSystem2) : actorSystem2 != null) break block3;
                }
                return true;
            }
            return false;
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final scala.collection.immutable.Map<String, String> Serializers;
        private final scala.collection.immutable.Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public scala.collection.immutable.Map<String, String> Serializers() {
            return this.Serializers;
        }

        public scala.collection.immutable.Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final scala.collection.immutable.Map<String, String> configToMap(Config cfg) {
            return (scala.collection.immutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)package$JavaConverters$.MODULE$, (Map)cfg.root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    Object v = x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                }
                throw new MatchError(null);
            });
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("pekko.actor.serializers"));
            Config bindings = config.getConfig("pekko.actor.serialization-bindings");
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

