/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.List;
import org.hibernate.boot.internal.ClassmateContext;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorBypassedImpl;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorStandardImpl;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.converter.internal.JpaAttributeConverterImpl;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractConverterDescriptor
implements ConverterDescriptor {
    private final Class<? extends AttributeConverter<?, ?>> converterClass;
    private final ResolvedType domainType;
    private final ResolvedType jdbcType;
    private final AutoApplicableConverterDescriptor autoApplicableDescriptor;

    public AbstractConverterDescriptor(Class<? extends AttributeConverter<?, ?>> converterClass, Boolean forceAutoApply, ClassmateContext classmateContext) {
        this.converterClass = converterClass;
        List<ResolvedType> converterParamTypes = ConverterHelper.resolveConverterClassParamTypes(converterClass, classmateContext);
        this.domainType = converterParamTypes.get(0);
        this.jdbcType = converterParamTypes.get(1);
        this.autoApplicableDescriptor = this.resolveAutoApplicableDescriptor(converterClass, forceAutoApply);
    }

    private AutoApplicableConverterDescriptor resolveAutoApplicableDescriptor(Class<? extends AttributeConverter> converterClass, Boolean forceAutoApply) {
        Converter annotation;
        boolean autoApply = forceAutoApply != null ? forceAutoApply : (annotation = converterClass.getAnnotation(Converter.class)) != null && annotation.autoApply();
        return autoApply ? new AutoApplicableConverterDescriptorStandardImpl(this) : AutoApplicableConverterDescriptorBypassedImpl.INSTANCE;
    }

    @Override
    public Class<? extends AttributeConverter<?, ?>> getAttributeConverterClass() {
        return this.converterClass;
    }

    @Override
    public ResolvedType getDomainValueResolvedType() {
        return this.domainType;
    }

    @Override
    public ResolvedType getRelationalValueResolvedType() {
        return this.jdbcType;
    }

    @Override
    public AutoApplicableConverterDescriptor getAutoApplyDescriptor() {
        return this.autoApplicableDescriptor;
    }

    @Override
    public JpaAttributeConverter<?, ?> createJpaAttributeConverter(JpaAttributeConverterCreationContext context) {
        JavaType converterJtd = context.getJavaTypeRegistry().getDescriptor(this.getAttributeConverterClass());
        Class domainJavaType = this.getDomainValueResolvedType().getErasedType();
        Class jdbcJavaType = this.getRelationalValueResolvedType().getErasedType();
        return new JpaAttributeConverterImpl(this.createManagedBean(context), converterJtd, domainJavaType, jdbcJavaType, context);
    }

    protected abstract ManagedBean<? extends AttributeConverter<?, ?>> createManagedBean(JpaAttributeConverterCreationContext var1);
}

