/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.PropertyAccessSerializationException;

public abstract class AbstractSetterMethodSerialForm
implements Serializable {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> declaringClass;
    private final @UnknownKeyFor @NonNull @Initialized String methodName;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> argumentType;

    public AbstractSetterMethodSerialForm(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method method) {
        this.containerClass = containerClass;
        this.propertyName = propertyName;
        this.declaringClass = method.getDeclaringClass();
        this.methodName = method.getName();
        this.argumentType = method.getParameterTypes()[0];
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getContainerClass() {
        return this.containerClass;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.propertyName;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDeclaringClass() {
        return this.declaringClass;
    }

    public @UnknownKeyFor @NonNull @Initialized String getMethodName() {
        return this.methodName;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getArgumentType() {
        return this.argumentType;
    }

    protected @UnknownKeyFor @NonNull @Initialized Method resolveMethod() {
        try {
            Method method = this.declaringClass.getDeclaredMethod(this.methodName, this.argumentType);
            ReflectHelper.ensureAccessibility(method);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new PropertyAccessSerializationException("Unable to resolve setter method on deserialization : " + this.declaringClass.getName() + "#" + this.methodName + "(" + this.argumentType.getName() + ")");
        }
    }
}

