/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import javax.interceptor.InvocationContext;
import org.infinispan.commons.util.Util;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractCachePutInterceptor
implements Serializable {
    private final CacheResolver defaultCacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    public AbstractCachePutInterceptor(CacheResolver defaultCacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.defaultCacheResolver = defaultCacheResolver;
        this.contextFactory = contextFactory;
    }

    public Object cachePut(InvocationContext invocationContext) throws Exception {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Interception of method '%s.%s'", (Object)invocationContext.getMethod().getDeclaringClass().getName(), (Object)invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContextImpl cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = cacheKeyInvocationContext.getCacheKeyGenerator();
        CachePut cachePut = (CachePut)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        CacheResolver cacheResolver = cacheKeyInvocationContext.getCacheResolver();
        if (cacheResolver == null) {
            cacheResolver = this.defaultCacheResolver;
        }
        Cache cache = cacheResolver.resolveCache(cacheKeyInvocationContext);
        Object valueToCache = cacheKeyInvocationContext.getValueParameter().getValue();
        if (!cachePut.afterInvocation() && valueToCache != null) {
            cache.put((Object)cacheKey, valueToCache);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Value stored before invocation in cache '%s' with key '%s': '%s'", (Object)cache.getName(), (Object)cacheKey, (Object)Util.toStr((Object)valueToCache));
            }
        }
        Object result = invocationContext.proceed();
        if (cachePut.afterInvocation() && valueToCache != null) {
            cache.put((Object)cacheKey, valueToCache);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Value stored after invocation in cache '%s' with key '%s': '%s'", (Object)cache.getName(), (Object)cacheKey, (Object)Util.toStr((Object)valueToCache));
            }
        }
        return result;
    }

    protected abstract Log getLog();
}

