/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;

public class Outliner {
    public List<Entry> generate(Indexer idx, String abspath) throws Exception {
        NModuleType mt = idx.getModuleForFile(abspath);
        if (mt == null) {
            return new ArrayList<Entry>();
        }
        return this.generate(mt.getTable(), abspath);
    }

    public List<Entry> generate(Scope scope, String path) {
        ArrayList<Entry> result2 = new ArrayList<Entry>();
        TreeSet<NBinding> entries = new TreeSet<NBinding>();
        for (NBinding nb : scope.values()) {
            if (nb.isSynthetic() || nb.isBuiltin() || nb.getDefs().isEmpty() || !path.equals(nb.getSignatureNode().getFile())) continue;
            entries.add(nb);
        }
        for (NBinding nb : entries) {
            Def signode = nb.getSignatureNode();
            List<Entry> kids = null;
            if (nb.getKind() == NBinding.Kind.CLASS) {
                NType realType = nb.followType();
                if (realType.isUnionType()) {
                    for (NType t : realType.asUnionType().getTypes()) {
                        if (!t.isClassType()) continue;
                        realType = t;
                        break;
                    }
                }
                kids = this.generate(realType.getTable(), path);
            }
            Entry kid = kids != null ? new Branch() : new Leaf();
            kid.setOffset(signode.start());
            kid.setQname(nb.getQname());
            kid.setKind(nb.getKind());
            if (kids != null) {
                kid.setChildren(kids);
            }
            result2.add(kid);
        }
        return result2;
    }

    public static class Leaf
    extends Entry {
        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean isBranch() {
            return false;
        }

        public Leaf() {
        }

        public Leaf(String qname, int start, NBinding.Kind kind) {
            super(qname, start, kind);
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public List<Entry> getChildren() {
            return new ArrayList<Entry>();
        }

        @Override
        public void setChildren(List<Entry> children) {
            throw new UnsupportedOperationException("Leaf nodes cannot have children.");
        }
    }

    public static class Branch
    extends Entry {
        private List<Entry> children = new ArrayList<Entry>();

        public Branch() {
        }

        public Branch(String qname, int start, NBinding.Kind kind) {
            super(qname, start, kind);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isBranch() {
            return true;
        }

        @Override
        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        @Override
        public List<Entry> getChildren() {
            return this.children;
        }

        @Override
        public void setChildren(List<Entry> children) {
            this.children = children;
        }
    }

    public static abstract class Entry {
        protected String qname;
        protected int offset;
        protected NBinding.Kind kind;

        public Entry() {
        }

        public Entry(String qname, int offset, NBinding.Kind kind) {
            this.qname = qname;
            this.offset = offset;
            this.kind = kind;
        }

        public abstract boolean isLeaf();

        public Leaf asLeaf() {
            return (Leaf)this;
        }

        public abstract boolean isBranch();

        public Branch asBranch() {
            return (Branch)this;
        }

        public abstract boolean hasChildren();

        public abstract List<Entry> getChildren();

        public abstract void setChildren(List<Entry> var1);

        public String getQname() {
            return this.qname;
        }

        public void setQname(String qname) {
            if (qname == null) {
                throw new IllegalArgumentException("qname param cannot be null");
            }
            this.qname = qname;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public NBinding.Kind getKind() {
            return this.kind;
        }

        public void setKind(NBinding.Kind kind) {
            if (kind == null) {
                throw new IllegalArgumentException("kind param cannot be null");
            }
            this.kind = kind;
        }

        public String getName() {
            String[] parts = this.qname.split("[.&@%]");
            return parts[parts.length - 1];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, 0);
            return sb.toString().trim();
        }

        public void toString(StringBuilder sb, int depth) {
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            sb.append((Object)this.getKind());
            sb.append(" ");
            sb.append(this.getName());
            sb.append("\n");
            if (this.hasChildren()) {
                for (Entry e : this.getChildren()) {
                    e.toString(sb, depth + 1);
                }
            }
        }
    }
}

