/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.artery.tcp.SecureRandomFactory$;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.SSLSettings;
import org.apache.pekko.stream.Client$;
import org.apache.pekko.stream.Server$;
import org.apache.pekko.stream.TLSRole;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\t\u0012\u0001yA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tB\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001BC\u0002\u0013%1\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00035\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015A\u0004\u0001\"\u0001>\u0011!1\u0005\u0001#b\u0001\n\u00139\u0005\"\u0002*\u0001\t#\u0019\u0006\"B6\u0001\t#a\u0007\"B:\u0001\t#!\b\"B=\u0001\t\u0003Q\b\"\u0002@\u0001\t\u0003z\bBBA\u0004\u0001\u0011\u0005s\u0010C\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\u001e\t92i\u001c8gS\u001e\u001c6\u000bT#oO&tW\r\u0015:pm&$WM\u001d\u0006\u0003%M\tQA\\3uifT!\u0001F\u000b\u0002\u0013Q\u0014\u0018M\\:q_J$(B\u0001\f\u0018\u0003\u0019\u0011X-\\8uK*\u0011\u0001$G\u0001\u0006a\u0016\\7n\u001c\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M\u001dj\u0011!E\u0005\u0003QE\u0011\u0011cU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u0003\rawnZ\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011afF\u0001\u0006KZ,g\u000e^\u0005\u0003a5\u0012A#T1sW\u0016\u0014Hj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0001b]3ui&twm]\u000b\u0002iA\u0011a%N\u0005\u0003mE\u00111bU*M'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007iZD\b\u0005\u0002'\u0001!)\u0011&\u0002a\u0001W!)!'\u0002a\u0001iQ\u0011!H\u0010\u0005\u0006\u007f\u0019\u0001\r\u0001Q\u0001\u0007gf\u001cH/Z7\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r;\u0012!B1di>\u0014\u0018BA#C\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0015M\u001cHnQ8oi\u0016DH/F\u0001I!\tI\u0005+D\u0001K\u0015\tYE*A\u0002tg2T!!\u0014(\u0002\u00079,GOC\u0001P\u0003\u0015Q\u0017M^1y\u0013\t\t&J\u0001\u0006T'2\u001buN\u001c;fqR\fA\u0002\\8bI.+\u0017p\u001d;pe\u0016$2\u0001\u0016/j!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017,\u0003\u0011-+\u0017p\u0015;pe\u0016DQ!\u0018\u0005A\u0002y\u000b\u0001BZ5mK:\fW.\u001a\t\u0003?\u001at!\u0001\u00193\u0011\u0005\u0005\fS\"\u00012\u000b\u0005\rl\u0012A\u0002\u001fs_>$h(\u0003\u0002fC\u00051\u0001K]3eK\u001aL!a\u001a5\u0003\rM#(/\u001b8h\u0015\t)\u0017\u0005C\u0003k\u0011\u0001\u0007a,\u0001\u0005qCN\u001cxo\u001c:e\u0003-YW-_'b]\u0006<WM]:\u0016\u00035\u00042\u0001\t8q\u0013\ty\u0017EA\u0003BeJ\f\u0017\u0010\u0005\u0002Jc&\u0011!O\u0013\u0002\u000b\u0017\u0016LX*\u00198bO\u0016\u0014\u0018!\u0004;skN$X*\u00198bO\u0016\u00148/F\u0001v!\r\u0001cN\u001e\t\u0003\u0013^L!\u0001\u001f&\u0003\u0019Q\u0013Xo\u001d;NC:\fw-\u001a:\u0002%\r\u0014X-\u0019;f'\u0016\u001cWO]3SC:$w.\u001c\u000b\u0002wB\u0011Q\u000b`\u0005\u0003{Z\u0013AbU3dkJ,'+\u00198e_6\fQc\u0019:fCR,7+\u001a:wKJ\u001c6\u000bT#oO&tW\r\u0006\u0002\u0002\u0002A\u0019\u0011*a\u0001\n\u0007\u0005\u0015!JA\u0005T'2+enZ5oK\u0006)2M]3bi\u0016\u001cE.[3oiN\u001bF*\u00128hS:,\u0017aD2sK\u0006$XmU*M\u000b:<\u0017N\\3\u0015\t\u0005\u0005\u0011Q\u0002\u0005\b\u0003\u001fq\u0001\u0019AA\t\u0003\u0011\u0011x\u000e\\3\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u0018\u0003\u0019\u0019HO]3b[&!\u00111DA\u000b\u0005\u001d!Fj\u0015*pY\u0016$b!!\u0001\u0002 \u0005\u0005\u0002\"\u0002$\u0010\u0001\u0004A\u0005bBA\b\u001f\u0001\u0007\u0011\u0011\u0003\u0015\f\u0001\u0005\u0015\u00121FA\u0017\u0003c\t\u0019\u0004E\u0002!\u0003OI1!!\u000b\"\u0005)!W\r\u001d:fG\u0006$X\rZ\u0001\b[\u0016\u001c8/Y4fC\t\ty#\u0001\u0016DY\u0006\u001c8/[2!e\u0016lw\u000e^5oO\u0002J7\u000f\t3faJ,7-\u0019;fI2\u0002So]3!\u0003J$XM]=\u0002\u000bMLgnY3\"\u0005\u0005U\u0012AC!lW\u0006\u0004#G\f\u001c/a\u0001")
public class ConfigSSLEngineProvider
implements SSLEngineProvider {
    private SSLContext sslContext;
    private final MarkerLoggingAdapter log;
    private final SSLSettings settings;
    private volatile boolean bitmap$0;

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    private SSLSettings settings() {
        return this.settings;
    }

    private SSLContext sslContext$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.sslContext = this.liftedTree1$1();
                this.bitmap$0 = true;
            }
        }
        return this.sslContext;
    }

    private SSLContext sslContext() {
        if (!this.bitmap$0) {
            return this.sslContext$lzycompute();
        }
        return this.sslContext;
    }

    public KeyStore loadKeystore(String filename, String password) {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        try {
            keyStore.load(fin, password.toCharArray());
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> fin.close());
        }
        return keyStore;
    }

    public KeyManager[] keyManagers() {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(this.loadKeystore(this.settings().SSLKeyStore(), this.settings().SSLKeyStorePassword()), this.settings().SSLKeyPassword().toCharArray());
        return factory.getKeyManagers();
    }

    public TrustManager[] trustManagers() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.loadKeystore(this.settings().SSLTrustStore(), this.settings().SSLTrustStorePassword()));
        return trustManagerFactory.getTrustManagers();
    }

    public SecureRandom createSecureRandom() {
        return SecureRandomFactory$.MODULE$.createSecureRandom(this.settings().SSLRandomNumberGenerator(), this.log());
    }

    @Override
    public SSLEngine createServerSSLEngine() {
        return this.createSSLEngine((TLSRole)Server$.MODULE$);
    }

    @Override
    public SSLEngine createClientSSLEngine() {
        return this.createSSLEngine((TLSRole)Client$.MODULE$);
    }

    private SSLEngine createSSLEngine(TLSRole role) {
        return this.createSSLEngine(this.sslContext(), role);
    }

    private SSLEngine createSSLEngine(SSLContext sslContext, TLSRole role) {
        SSLEngine engine = sslContext.createSSLEngine();
        TLSRole tLSRole = role;
        Client$ client$ = Client$.MODULE$;
        engine.setUseClientMode(tLSRole != null && tLSRole.equals(client$));
        engine.setEnabledCipherSuites((String[])this.settings().SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
        engine.setEnabledProtocols(new String[]{this.settings().SSLProtocol()});
        TLSRole tLSRole2 = role;
        Client$ client$2 = Client$.MODULE$;
        if ((tLSRole2 == null || !tLSRole2.equals(client$2)) && this.settings().SSLRequireMutualAuthentication()) {
            engine.setNeedClientAuth(true);
        }
        return engine;
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ SSLContext liftedTree1$1() {
        try {
            void var2_2;
            SecureRandom rng = this.createSecureRandom();
            SSLContext ctx = SSLContext.getInstance(this.settings().SSLProtocol());
            ctx.init(this.keyManagers(), this.trustManagers(), rng);
            return var2_2;
        }
        catch (FileNotFoundException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", e);
        }
        catch (IOException e) {
            throw new RemoteTransportException(new StringBuilder(56).append("Server SSL connection could not be established because: ").append(e.getMessage()).toString(), e);
        }
        catch (GeneralSecurityException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
    }

    public ConfigSSLEngineProvider(MarkerLoggingAdapter log, SSLSettings settings) {
        this.log = log;
        this.settings = settings;
    }

    public ConfigSSLEngineProvider(ActorSystem system) {
        this(Logging$.MODULE$.withMarker(system, (Object)ConfigSSLEngineProvider.class.getName(), LogSource$.MODULE$.fromString()), new SSLSettings(system.settings().config().getConfig("pekko.remote.classic.netty.ssl.security")));
    }
}

