/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Visitor;
import org.jboss.windup.util.exception.WindupException;

public class FileVisit {
    public static void visit(File directory, Predicate<File> predicate, Visitor<File> visitor) {
        if (directory.exists()) {
            List<File> files = FileVisit.visit(directory, predicate);
            for (File file : files) {
                visitor.visit((Object)file);
            }
        }
    }

    public static List<File> visit(File directory, final Predicate<File> predicate) {
        try {
            final ArrayList<File> result = new ArrayList<File>();
            if (directory != null && directory.isDirectory()) {
                Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (predicate.accept((Object)file.toFile())) {
                            result.add(file.toFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return result;
        }
        catch (Exception e) {
            throw new WindupException("Failed to visit directory filesystem at [" + directory + "]", e);
        }
    }
}

