/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.type.descriptor.java.JavaType;

public interface ManagedMappingType
extends MappingType,
FetchableContainer {
    @Override
    default public JavaType<?> getJavaType() {
        return this.getMappedJavaType();
    }

    @Override
    default public MappingType getPartMappingType() {
        return this;
    }

    public int getNumberOfAttributeMappings();

    public AttributeMapping getAttributeMapping(int var1);

    default public AttributeMapping findAttributeMapping(String name) {
        return null;
    }

    public AttributeMappingsList getAttributeMappings();

    public void forEachAttributeMapping(Consumer<? super AttributeMapping> var1);

    default public void forEachAttributeMapping(IndexedConsumer<? super AttributeMapping> consumer) {
        this.getAttributeMappings().indexedForEach(consumer);
    }

    public Object[] getValues(Object var1);

    default public Object getValue(Object instance, int position) {
        return this.getAttributeMapping(position).getPropertyAccess().getGetter().get(instance);
    }

    public void setValues(Object var1, Object[] var2);

    default public void setValue(Object instance, int position, Object value) {
        this.getAttributeMapping(position).getPropertyAccess().getSetter().set(instance, value);
    }

    default public boolean anyRequiresAggregateColumnWriter() {
        int end = this.getNumberOfAttributeMappings();
        for (int i = 0; i < end; ++i) {
            MappingType mappedType = this.getAttributeMapping(i).getMappedType();
            if (!(mappedType instanceof EmbeddableMappingType) || !((EmbeddableMappingType)mappedType).anyRequiresAggregateColumnWriter()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean hasPartitionedSelectionMapping() {
        AttributeMappingsList attributeMappings = this.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = attributeMappings.get(i);
            if (!attributeMapping.hasPartitionedSelectionMapping()) continue;
            return true;
        }
        return false;
    }

    default public boolean isAffectedByEnabledFilters(Set<ManagedMappingType> visitedTypes, LoadQueryInfluencers influencers, boolean onlyApplyForLoadByKey) {
        if (!visitedTypes.add(this)) {
            return false;
        }
        AttributeMappingsList attributeMappings = this.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            EntityMappingType entityMappingType;
            CollectionPersister collectionDescriptor;
            AttributeMapping attributeMapping = attributeMappings.get(i);
            FetchOptions mappedFetchOptions = attributeMapping.getMappedFetchOptions();
            if (mappedFetchOptions.getTiming() != FetchTiming.IMMEDIATE || mappedFetchOptions.getStyle() != FetchStyle.JOIN || !(attributeMapping instanceof PluralAttributeMapping ? (collectionDescriptor = ((PluralAttributeMapping)attributeMapping).getCollectionDescriptor()).isAffectedByEnabledFilters(visitedTypes, influencers, onlyApplyForLoadByKey) : attributeMapping instanceof ToOneAttributeMapping && (entityMappingType = ((ToOneAttributeMapping)attributeMapping).getEntityMappingType()).isAffectedByEnabledFilters(visitedTypes, influencers, onlyApplyForLoadByKey))) continue;
            return true;
        }
        return false;
    }
}

