/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.scheduler;

import com.xebialabs.deployit.engine.spi.event.CiBaseEvent;
import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.CisDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.CisUpdatedEvent;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.engine.spi.event.SystemStoppedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlplatform.scheduler.ActorJob;
import com.xebialabs.xlplatform.scheduler.ControlTaskExecutor;
import com.xebialabs.xlplatform.scheduler.Scheduler;
import com.xebialabs.xlplatform.scheduler.SchedulerActorSystem$;
import com.xebialabs.xlplatform.scheduler.ci.ControlTaskInvokable;
import com.xebialabs.xlplatform.scheduler.ci.ScheduledJob;
import com.xebialabs.xlplatform.scheduler.spring.ServiceHolder;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import nl.javadude.t2bus.Subscribe;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOps;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContextExecutor;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\f\u0018\u0001\u0001B\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\ta\f\u0005\ty\u0001\u0011\t\u0011)A\u0005a!AQ\b\u0001BC\u0002\u0013\u0005q\u0006\u0003\u0005?\u0001\t\u0005\t\u0015!\u00031\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b)\u0003A\u0011A&\t\u000b)\u0003A\u0011A)\t\u000fI\u0003!\u0019!C\u0002'\"1q\u000b\u0001Q\u0001\nQCq\u0001\u0017\u0001C\u0002\u0013\r\u0011\f\u0003\u0004a\u0001\u0001\u0006IA\u0017\u0005\u0006C\u0002!\tA\u0019\u0005\u0006y\u0002!\t! \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!a\t\u0001\t\u0003\t)\u0003\u0003\u0005\u00022\u0001!\taFA\u001a\u0011!\t)\t\u0001C\u0001/\u0005\u001d\u0005\u0002CAM\u0001\u0011\u0005q#a'\t\u0011\u0005}\u0005\u0001\"\u0001\u0018\u0003C\u0013Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014(B\u0001\r\u001a\u0003%\u00198\r[3ek2,'O\u0003\u0002\u001b7\u0005Q\u0001\u0010\u001c9mCR4wN]7\u000b\u0005qi\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005q\u0012aA2p[\u000e\u00011c\u0001\u0001\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u000bMdg\r\u000e6\u000b\u00031\n\u0001b\u001a:jujdW\rZ\u0005\u0003]%\u0012q\u0001T8hO&tw-F\u00011!\t\t$(D\u00013\u0015\t\u0019D'A\u0003bGR|'O\u0003\u00026m\u0005)\u0001/Z6l_*\u0011q\u0007O\u0001\u0007CB\f7\r[3\u000b\u0003e\n1a\u001c:h\u0013\tY$G\u0001\u0005BGR|'OU3g\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0014G>tGO]8m)\u0006\u001c8.\u0012=fGV$xN]\u0001\u0015G>tGO]8m)\u0006\u001c8.\u0012=fGV$xN\u001d\u0011\u0002#I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-F\u0001B!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0006sKB|7/\u001b;pefT!AR\u000e\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001S\"\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW-\u0001\nsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003M\u001d>\u0003\u0006CA'\u0001\u001b\u00059\u0002\"\u0002\r\b\u0001\u0004\u0001\u0004\"B\u001f\b\u0001\u0004\u0001\u0004\"B \b\u0001\u0004\tE#\u0001'\u0002\u0017\u0005\u001cGo\u001c:TsN$X-\\\u000b\u0002)B\u0011\u0011'V\u0005\u0003-J\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u0006a\u0011m\u0019;peNK8\u000f^3nA\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u00025B\u00111LX\u0007\u00029*\u0011QlI\u0001\u000bG>t7-\u001e:sK:$\u0018BA0]\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013A\u0005:fG\u0016Lg/Z*zgR,Wn\u0015;beR$\"a\u00194\u0011\u0005\t\"\u0017BA3$\u0005\u0011)f.\u001b;\t\u000b\u001dl\u0001\u0019\u00015\u0002\u000b\u00154XM\u001c;\u0011\u0005%|W\"\u00016\u000b\u0005\u001d\\'B\u00017n\u0003\r\u0019\b/\u001b\u0006\u0003]\u0016\u000ba!\u001a8hS:,\u0017B\u00019k\u0005I\u0019\u0016p\u001d;f[N#\u0018M\u001d;fI\u00163XM\u001c;)\u00055\u0011\bCA:{\u001b\u0005!(BA;w\u0003\u0015!(GY;t\u0015\t9\b0\u0001\u0005kCZ\fG-\u001e3f\u0015\u0005I\u0018A\u00018m\u0013\tYHOA\u0005Tk\n\u001c8M]5cK\u0006\t\"/Z2fSZ,7)[:De\u0016\fG/\u001a3\u0015\u0005\rt\b\"B4\u000f\u0001\u0004y\bcA5\u0002\u0002%\u0019\u00111\u00016\u0003\u001f\rK7o\u0011:fCR,G-\u0012<f]RD#A\u0004:\u0002#I,7-Z5wK\u000eK7/\u00169eCR,G\rF\u0002d\u0003\u0017AaaZ\bA\u0002\u00055\u0001cA5\u0002\u0010%\u0019\u0011\u0011\u00036\u0003\u001f\rK7/\u00169eCR,G-\u0012<f]RD#a\u0004:\u0002#I,7-Z5wK\u000eK7\u000fR3mKR,G\rF\u0002d\u00033Aaa\u001a\tA\u0002\u0005m\u0001cA5\u0002\u001e%\u0019\u0011q\u00046\u0003\u001f\rK7\u000fR3mKR,G-\u0012<f]RD#\u0001\u0005:\u0002#I,7-Z5wKNK8\u000f^3n'R|\u0007\u000fF\u0002d\u0003OAaaZ\tA\u0002\u0005%\u0002cA5\u0002,%\u0019\u0011Q\u00066\u0003%MK8\u000f^3n'R|\u0007\u000f]3e\u000bZ,g\u000e\u001e\u0015\u0003#I\f\u0011BZ5mi\u0016\u00148)[:\u0016\t\u0005U\u0012Q\n\u000b\u0005\u0003o\ti\b\u0006\u0003\u0002:\u00055\u0004CBA\u001e\u0003\u000b\nI%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u001diW\u000f^1cY\u0016T1!a\u0011$\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\niD\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003\u0017\ni\u0005\u0004\u0001\u0005\u000f\u0005=#C1\u0001\u0002R\t\tA+\u0005\u0003\u0002T\u0005e\u0003c\u0001\u0012\u0002V%\u0019\u0011qK\u0012\u0003\u000f9{G\u000f[5oOB!\u00111LA5\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014aA;e[*!\u00111MA3\u0003\r\t\u0007/\u001b\u0006\u0004\u0003O*\u0015A\u00029mk\u001eLg.\u0003\u0003\u0002l\u0005u#!E\"p]\u001aLw-\u001e:bi&|g.\u0013;f[\"9\u0011q\u000e\nA\u0004\u0005E\u0014AA2u!\u0019\t\u0019(!\u001f\u0002J5\u0011\u0011Q\u000f\u0006\u0004\u0003o\u001a\u0013a\u0002:fM2,7\r^\u0005\u0005\u0003w\n)H\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u00199'\u00031\u0001\u0002\u0000A\u0019\u0011.!!\n\u0007\u0005\r%NA\u0006DS\n\u000b7/Z#wK:$\u0018A\u0003:fgR\f'\u000f\u001e&pER\u00191-!#\t\u000f\u0005-5\u00031\u0001\u0002\u000e\u0006\u0019!n\u001c2\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%\u0018\u0003\t\u0019\u0017.\u0003\u0003\u0002\u0018\u0006E%\u0001D*dQ\u0016$W\u000f\\3e\u0015>\u0014\u0017\u0001C:uCJ$(j\u001c2\u0015\u0007\r\fi\nC\u0004\u0002\fR\u0001\r!!$\u0002\u000fM$x\u000e\u001d&pER\u00191-a)\t\u000f\u0005-U\u00031\u0001\u0002\u000e\u0002")
public class EventListener
implements Logging {
    private final ActorRef scheduler;
    private final ActorRef controlTaskExecutor;
    private final RepositoryService repositoryService;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor executionContext;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EventListener eventListener = this;
        synchronized (eventListener) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ActorRef scheduler() {
        return this.scheduler;
    }

    public ActorRef controlTaskExecutor() {
        return this.controlTaskExecutor;
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    @Subscribe
    public void receiveSystemStart(SystemStartedEvent event) {
        this.logger().debug((Function0 & Serializable)() -> "Starting scheduled control task jobs");
        Type scheduledJobType = Type.valueOf(ScheduledJob.class);
        this.logger().debug((Function0 & Serializable)() -> "Searching all nodes of type " + scheduledJobType);
        List cis = this.repositoryService().list(new SearchParameters().setType(scheduledJobType).setAncestor(Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName()).setResultsPerPage(-1L));
        this.logger().debug((Function0 & Serializable)() -> "Found " + cis.size() + " jobs matching criteria");
        CollectionConverters$.MODULE$.ListHasAsScala(cis).asScala().foreach((Function1 & Serializable)cid -> {
            this.startJob((ScheduledJob)this.repositoryService().read(cid.getId()));
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveCisCreated(CisCreatedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1 & Serializable)job -> {
            this.startJob(job);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveCisUpdated(CisUpdatedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1 & Serializable)job -> {
            this.restartJob(job);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveCisDeleted(CisDeletedEvent event) {
        this.filterCis((CiBaseEvent)event, ClassTag$.MODULE$.apply(ScheduledJob.class)).foreach((Function1 & Serializable)job -> {
            this.stopJob(job);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void receiveSystemStop(SystemStoppedEvent event) {
        this.logger().info((Function0 & Serializable)() -> "Stopping scheduled control task jobs");
        SchedulerActorSystem$.MODULE$.shutdownTheSystem();
    }

    public <T extends ConfigurationItem> Buffer<T> filterCis(CiBaseEvent event, ClassTag<T> ct) {
        return (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(event.getCis()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EventListener.$anonfun$filterCis$1(ct, x$1)))).map((Function1 & Serializable)x$2 -> x$2);
    }

    public void restartJob(ScheduledJob job) {
        this.stopJob(job);
        this.startJob(job);
    }

    public void startJob(ScheduledJob job) {
        if (job.enabled()) {
            ScheduledJob scheduledJob = job;
            if (!(scheduledJob instanceof ControlTaskInvokable)) {
                throw new IllegalArgumentException("Unable to schedule unknown job " + job + "!");
            }
            ScheduledJob scheduledJob2 = scheduledJob;
            ControlTaskExecutor.Messages.InvokeControlTask message = new ControlTaskExecutor.Messages.InvokeControlTask(((ControlTaskInvokable)((Object)scheduledJob2)).getConfigurationItemId(), ((ControlTaskInvokable)((Object)scheduledJob2)).getControlTaskName(), ((ControlTaskInvokable)((Object)scheduledJob2)).getControlTaskParams());
            Scheduler.Messages.ScheduleJob x$1 = new Scheduler.Messages.ScheduleJob(new ActorJob(job.getId(), this.controlTaskExecutor(), message), job.getTrigger());
            ActorRef x$2 = this.scheduler().$bang$default$2((Object)x$1);
            this.scheduler().$bang((Object)x$1, x$2);
            return;
        }
    }

    public void stopJob(ScheduledJob job) {
        Scheduler.Messages.CancelJob x$1 = new Scheduler.Messages.CancelJob(job.getId());
        ActorRef x$2 = this.scheduler().$bang$default$2((Object)x$1);
        this.scheduler().$bang((Object)x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$filterCis$1(ClassTag ct$1, ConfigurationItem x$1) {
        return x$1.getType().isSubTypeOf(Type.valueOf((Class)ct$1.runtimeClass()));
    }

    public EventListener(ActorRef scheduler, ActorRef controlTaskExecutor, RepositoryService repositoryService) {
        this.scheduler = scheduler;
        this.controlTaskExecutor = controlTaskExecutor;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        EventBusHolder.register((Object)this);
        this.actorSystem = SchedulerActorSystem$.MODULE$.actorSystem();
        this.executionContext = this.actorSystem().dispatcher();
    }

    public EventListener() {
        this(SchedulerActorSystem$.MODULE$.scheduler(), SchedulerActorSystem$.MODULE$.controlTaskExecutor(), ServiceHolder.getRepositoryService());
    }
}

