/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class LOBInputStream
extends InputStream
implements PositionedStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;
    private long updateCount;

    LOBInputStream(LOBStreamControl lOBStreamControl, long l) {
        this.control = lOBStreamControl;
        this.pos = l;
        this.updateCount = lOBStreamControl.getUpdateCount();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage((String)"J104", (Object[])new Object[0]));
        }
        try {
            int n3 = this.control.read(byArray, n, n2, this.pos);
            if (n3 != -1) {
                this.pos += (long)n3;
                return n3;
            }
            return -1;
        }
        catch (StandardException standardException) {
            String string = standardException.getSQLState();
            if (string.equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ076.S"))) {
                return -1;
            }
            if (string.equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(standardException.getMessage());
            }
            throw Util.newIOException(standardException);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage((String)"J104", (Object[])new Object[0]));
        }
        try {
            int n = this.control.read(this.pos);
            if (n != -1) {
                ++this.pos;
            }
            return n;
        }
        catch (StandardException standardException) {
            throw Util.newIOException(standardException);
        }
    }

    boolean isObsolete() {
        return this.updateCount != this.control.getUpdateCount();
    }

    void reInitialize() {
        this.updateCount = this.control.getUpdateCount();
        this.pos = 0L;
    }

    long length() throws IOException {
        return this.control.getLength();
    }

    @Override
    public InputStream asInputStream() {
        return this;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void reposition(long l) throws IOException {
        if (l > this.length()) {
            this.pos = 0L;
            throw new EOFException();
        }
        this.pos = l;
    }
}

