/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.collections4.CollectionUtils;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;
import org.kamranzafar.jtar.TarOutputStream;

public class TarUtil {
    private static Logger LOG = Logger.getLogger(TarUtil.class.getName());

    public static void tarDirectory(Path outputFile, Path inputDirectory) throws IOException {
        TarUtil.tarDirectory(outputFile, inputDirectory, Collections.emptyList());
    }

    public static void tarDirectory(Path outputFile, Path inputDirectory, List<String> pathPrefixesToExclude) throws IOException {
        LOG.info("Creating archive at: " + outputFile);
        Collection collectionPathPrefixesToExclude = CollectionUtils.emptyIfNull(pathPrefixesToExclude);
        FileOutputStream dest = new FileOutputStream(outputFile.toFile());
        Path outputFileAbsolute = outputFile.normalize().toAbsolutePath();
        Path inputDirectoryAbsolute = inputDirectory.normalize().toAbsolutePath();
        int inputPathLength = inputDirectoryAbsolute.toString().length();
        try (TarOutputStream out = new TarOutputStream((OutputStream)new BufferedOutputStream(dest));){
            Files.walk(inputDirectoryAbsolute, new FileVisitOption[0]).forEach(entry -> {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    return;
                }
                if (entry.equals(outputFileAbsolute)) {
                    return;
                }
                try {
                    int count;
                    String relativeName = entry.toString().substring(inputPathLength + 1);
                    if (collectionPathPrefixesToExclude.stream().anyMatch(pathPrefixToExclude -> relativeName.startsWith((String)pathPrefixToExclude))) {
                        return;
                    }
                    out.putNextEntry(new TarEntry(entry.toFile(), relativeName));
                    BufferedInputStream origin = new BufferedInputStream(new FileInputStream(entry.toFile()));
                    byte[] data = new byte[2048];
                    while ((count = origin.read(data)) != -1) {
                        out.write(data, 0, count);
                    }
                    out.flush();
                    origin.close();
                }
                catch (IOException e) {
                    LOG.severe("Failed to add tar entry due to: " + e.getMessage());
                    e.printStackTrace();
                }
            });
        }
    }

    public static void untar(Path outputDirectory, Path inputTarFile) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(inputTarFile.toFile());){
            TarUtil.untar(outputDirectory, fileInputStream);
        }
    }

    public static void untar(Path outputDirectory, InputStream inputStream) throws IOException {
        try (TarInputStream tarInputStream = new TarInputStream(inputStream);){
            TarEntry entry;
            while ((entry = tarInputStream.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[32768];
                File outputFile = new File(outputDirectory + "/" + entry.getName());
                if (!outputFile.getParentFile().isDirectory()) {
                    outputFile.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(outputFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos);
                while ((count = tarInputStream.read(data)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
        }
    }
}

